/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thedeepvoid.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelroot_entity<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("the_deep_void", "modelroot_entity"), "main");
    public final ModelPart left_leg;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart right_leg;
    public final ModelPart body;
    public final ModelPart head;

    public Modelroot_entity(ModelPart root) {
        this.left_leg = root.getChild("left_leg");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.right_leg = root.getChild("right_leg");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(24, 32).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 28.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-4.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -1.0f, -1.5f, 3.0f, 41.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-17.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(12, 0).addBox(-2.5f, -1.0f, -1.5f, 3.0f, 41.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-17.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(36, 32).addBox(-2.0f, 0.0f, -1.5f, 3.0f, 28.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-4.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(56, 8).addBox(-5.0f, -6.0f, -2.0f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(56, 15).addBox(-5.0f, -3.0f, -2.0f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 50).addBox(-5.0f, -15.0f, -2.5f, 10.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(56, 0).addBox(-5.0f, -12.0f, -2.5f, 10.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(48, 32).addBox(-5.5f, -18.0f, -3.0f, 11.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(48, 41).addBox(-5.5f, -15.0f, -3.0f, 11.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 44).addBox(-4.0f, -12.0f, -2.0f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 0).addBox(-4.0f, -11.0f, -4.0f, 8.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 19).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

