/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.updater;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.deadlydiamond98.koalalib.KoalaLib;
import net.deadlydiamond98.koalalib.config.KoalaLibConfigs;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModOrigin;

public class KoalaUpdateChecker {
    public static final List<UpdatableMod> MOD_UPDATE_LIST = new ArrayList<UpdatableMod>();
    private static final String MODRINTH_URL = "https://api.modrinth.com/v2/version_file/";
    private static final String VERSION = "1.20.1";
    private static final String LOADER = "fabric";

    public static void addModUpdateChecker(String modid) {
        Optional optional;
        if (KoalaLibConfigs.Main.checkForUpdates && (optional = FabricLoader.getInstance().getModContainer(modid)).isPresent()) {
            ModContainer container = (ModContainer)optional.get();
            String name = container.getMetadata().getName();
            try {
                URL url = new URL(MODRINTH_URL + KoalaUpdateChecker.getSHA512Hash(name, container) + "/update?algorithm=sha512");
                JsonObject jsonObject = JsonParser.parseString((String)KoalaUpdateChecker.requestJSONString(url)).getAsJsonObject();
                JsonObject primaryRelease = KoalaUpdateChecker.getPrimaryRelease(jsonObject).getAsJsonObject();
                String modFilepath = KoalaUpdateChecker.getJarLocation((ModContainer)FabricLoader.getInstance().getModContainer(modid).orElseThrow()).toString();
                String modrinthName = primaryRelease.get("filename").getAsString();
                if (!modFilepath.contains(modrinthName)) {
                    String modUrl = primaryRelease.get("url").getAsString();
                    MOD_UPDATE_LIST.add(new UpdatableMod(name, modUrl));
                    KoalaLib.LOGGER.info("-------------------------------\n");
                    KoalaLib.LOGGER.info("An update for {} has been detected!", (Object)name);
                    KoalaLib.LOGGER.info("You can download the latest version of {} here: \n{}", (Object)name, (Object)modUrl);
                    KoalaLib.LOGGER.info("\n-------------------------------\n");
                }
            }
            catch (Exception ignored) {
                KoalaLib.LOGGER.info("Failed to find {} on Modrinth!", (Object)name);
            }
        }
    }

    private static String requestJSONString(URL url) throws Exception {
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        http.setRequestMethod("POST");
        http.setDoOutput(true);
        http.setRequestProperty("Content-Type", "application/json");
        http.setRequestProperty("User-Agent", KoalaUpdateChecker.getContact());
        String data = "{\"loaders\":[\"fabric\"],\"game_versions\":[\"1.20.1\"]}";
        byte[] out = data.getBytes(StandardCharsets.UTF_8);
        OutputStream stream = http.getOutputStream();
        stream.write(out);
        String str = new BufferedReader(new InputStreamReader(http.getInputStream())).readLine();
        http.disconnect();
        return str;
    }

    private static JsonElement getPrimaryRelease(JsonObject jsonObject) {
        return jsonObject.getAsJsonArray("files").asList().stream().filter(jsonElement -> jsonElement.getAsJsonObject().get("primary").getAsBoolean()).findFirst().orElseThrow();
    }

    private static Path getJarLocation(ModContainer container) {
        return container.getOrigin().getPaths().stream().filter(path -> path.toString().toLowerCase(Locale.ROOT).endsWith(".jar")).findFirst().orElseThrow();
    }

    private static String getSHA512Hash(String name, ModContainer container) {
        try {
            File file;
            if (container.getOrigin().getKind() == ModOrigin.Kind.PATH && (file = KoalaUpdateChecker.getJarLocation(container).toFile()).isFile()) {
                return Files.asByteSource((File)file).hash(Hashing.sha512()).toString();
            }
        }
        catch (Exception ignored) {
            KoalaLib.LOGGER.info("Unable to get the SHA-512 Hash for [{}]", (Object)name);
        }
        return null;
    }

    private static String getContact() {
        return "Deadlydiamond98/KoalaLib/" + KoalaLib.getVersion() + " (diamonderrick1@gmail.com)";
    }

    public record UpdatableMod(String name, String url) {
    }
}

