/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.util.magic;

import java.util.UUID;
import net.deadlydiamond98.koalalib.init.KoalaLibEntityAttributes;
import net.deadlydiamond98.koalalib.util.mixinterfaces.IMagicBarData;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;

public class MagicBarHelper {
    public static boolean addMana(class_1309 entity, int amount) {
        if (amount < 0) {
            return MagicBarHelper.removeMana(entity, amount * -1);
        }
        if (MagicBarHelper.canAddMana(entity, amount)) {
            if (amount + MagicBarHelper.getMana(entity) <= MagicBarHelper.getMaxMana(entity)) {
                MagicBarHelper.setMana(entity, MagicBarHelper.getMana(entity) + amount);
            } else if (MagicBarHelper.getMana(entity) < MagicBarHelper.getMaxMana(entity) && amount + MagicBarHelper.getMana(entity) > MagicBarHelper.getMaxMana(entity)) {
                MagicBarHelper.setMana(entity, MagicBarHelper.getMaxMana(entity));
            }
            return true;
        }
        return MagicBarHelper.canAddMana(entity, amount);
    }

    public static boolean removeMana(class_1309 entity, int amount) {
        return MagicBarHelper.removeMana(entity, amount, true);
    }

    public static boolean removeMana(class_1309 entity, int amount, boolean addDelay) {
        if (amount < 0) {
            return MagicBarHelper.addMana(entity, amount * -1);
        }
        if (MagicBarHelper.canRemoveMana(entity, amount)) {
            if (MagicBarHelper.getMana(entity) - amount >= 0) {
                MagicBarHelper.setMana(entity, MagicBarHelper.getMana(entity) - amount);
            } else if (MagicBarHelper.getMana(entity) > 0 && MagicBarHelper.getMana(entity) - amount < 0) {
                MagicBarHelper.setMana(entity, 0);
            }
            MagicBarHelper.getBar(entity).koalalib$applyRegenDelay(addDelay);
            return true;
        }
        return MagicBarHelper.canRemoveMana(entity, amount);
    }

    public static boolean canAddMana(class_1309 entity, int amount) {
        if (amount + MagicBarHelper.getMana(entity) <= MagicBarHelper.getMaxMana(entity)) {
            return true;
        }
        return MagicBarHelper.getMana(entity) < MagicBarHelper.getMaxMana(entity) && amount + MagicBarHelper.getMana(entity) > MagicBarHelper.getMaxMana(entity);
    }

    public static boolean canRemoveMana(class_1309 entity, int amount) {
        return MagicBarHelper.getMana(entity) - amount >= 0;
    }

    public static void setMana(class_1309 entity, int amount) {
        MagicBarHelper.getBar(entity).koalalib$setMana(amount);
    }

    public static int getMana(class_1309 entity) {
        return MagicBarHelper.getBar(entity).koalalib$getMana();
    }

    public static int getMaxMana(class_1309 entity) {
        return (int)entity.method_26825(KoalaLibEntityAttributes.GENERIC_MAX_MAGIC);
    }

    public static int getUnmodifiedMaxMana(class_1309 entity) {
        return (int)entity.method_26826(KoalaLibEntityAttributes.GENERIC_MAX_MAGIC);
    }

    public static void applyMaxManaModifier(UUID uuid, String name, class_1309 entity, int amount) {
        class_1324 attribute = entity.method_5996(KoalaLibEntityAttributes.GENERIC_MAX_MAGIC);
        if (attribute != null) {
            MagicBarHelper.removeMaxManaModifier(uuid, entity);
            class_1322 modifier = new class_1322(uuid, name, (double)amount, class_1322.class_1323.field_6328);
            attribute.method_26837(modifier);
        }
    }

    public static void removeMaxManaModifier(UUID uuid, class_1309 entity) {
        class_1324 attribute = entity.method_5996(KoalaLibEntityAttributes.GENERIC_MAX_MAGIC);
        if (attribute != null && attribute.method_6199(uuid) != null) {
            attribute.method_6200(uuid);
        }
    }

    public static boolean canRegenerateMana(class_1309 entity) {
        return MagicBarHelper.getBar(entity).koalalib$isManaRegenEnabled();
    }

    public static void enableManaRegen(class_1309 entity, boolean bl) {
        MagicBarHelper.getBar(entity).koalalib$setManaRegenAbility(bl);
    }

    public static void requiteFullHungerForPassiveRegen(class_1309 entity, boolean bl) {
        MagicBarHelper.getBar(entity).koalalib$requireFullHungerForMagicRegen(bl);
    }

    public static int getManaRegenCap(class_1309 entity) {
        return MagicBarHelper.getBar(entity).koalalib$getMagicRegenCap();
    }

    public static void setManaRegenCap(class_1309 entity, int cap) {
        MagicBarHelper.getBar(entity).koalalib$setMagicRegenCap(cap);
    }

    public static IMagicBarData getBar(class_1309 entity) {
        return (IMagicBarData)entity;
    }
}

