/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce;

import com.mojang.logging.LogUtils;
import com.startraveler.celebratoryspruce.Config;
import com.startraveler.celebratoryspruce.ModBlockEntityTypes;
import com.startraveler.celebratoryspruce.ModBlocks;
import com.startraveler.celebratoryspruce.ModCreativeModeTabs;
import com.startraveler.celebratoryspruce.ModDataComponentTypes;
import com.startraveler.celebratoryspruce.ModItems;
import com.startraveler.celebratoryspruce.block.DecoratedLeavesBlock;
import com.startraveler.celebratoryspruce.block.RandomizedDecoratedLeavesBlock;
import com.startraveler.celebratoryspruce.block.entity.ItemRenderingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="celebratoryspruce")
public class CelebratorySpruce {
    public static final String MODID = "celebratoryspruce";
    public static final Logger LOGGER = LogUtils.getLogger();

    public CelebratorySpruce(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModCreativeModeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.register(modEventBus);
        ModDataComponentTypes.DATA_COMPONENT_TYPES.register(modEventBus);
        ItemRenderingBlockEntity.TransformTypeCodecRegistry.init();
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.addListener(this::useItemOnBlock);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static Identifier id(String name) {
        return Identifier.fromNamespaceAndPath((String)MODID, (String)name);
    }

    public void useItemOnBlock(UseItemOnBlockEvent event) {
        ItemStack stack = event.getItemStack();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        @Nullable Player player = event.getPlayer();
        if (stack.is(ModItems.ORNAMENT) && state.is(Blocks.SPRUCE_LEAVES)) {
            BlockState randomVariant;
            if (player == null || !player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if ((randomVariant = RandomizedDecoratedLeavesBlock.applyRandomVariant(((DecoratedLeavesBlock)((Object)ModBlocks.DECORATED_SPRUCE_LEAVES.get())).withPropertiesOf(state), pos, RandomizedDecoratedLeavesBlock.VARIANT)) != null) {
                level.playSound(null, pos, SoundEvents.GLASS_PLACE, SoundSource.BLOCKS);
                level.setBlockAndUpdate(pos, randomVariant);
            }
            event.cancelWithResult((InteractionResult)InteractionResult.SUCCESS);
        } else if (stack.isEmpty() && state.is(ModBlocks.DECORATED_SPRUCE_LEAVES)) {
            if (player != null) {
                player.addItem(new ItemStack((ItemLike)ModItems.ORNAMENT.get(), 1));
            }
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS);
            level.setBlockAndUpdate(pos, Blocks.SPRUCE_LEAVES.withPropertiesOf(state));
            event.cancelWithResult((InteractionResult)InteractionResult.SUCCESS);
        } else if (stack.is(ModItems.FESTIVE_LIGHT) && state.is(Blocks.SPRUCE_LEAVES)) {
            if (player == null || !player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.GLASS_PLACE, SoundSource.BLOCKS);
            level.setBlockAndUpdate(pos, ((DecoratedLeavesBlock)((Object)ModBlocks.FESTIVE_SPRUCE_LEAVES.get())).withPropertiesOf(state));
            event.cancelWithResult((InteractionResult)InteractionResult.SUCCESS);
        } else if (stack.isEmpty() && state.is(ModBlocks.FESTIVE_SPRUCE_LEAVES)) {
            if (player != null) {
                player.addItem(new ItemStack((ItemLike)ModItems.FESTIVE_LIGHT.get(), 1));
            }
            level.playSound(null, pos, SoundEvents.GLOW_ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS);
            level.setBlockAndUpdate(pos, Blocks.SPRUCE_LEAVES.withPropertiesOf(state));
            event.cancelWithResult((InteractionResult)InteractionResult.SUCCESS);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }
}

