/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce;

import com.startraveler.celebratoryspruce.CelebratorySpruce;
import com.startraveler.celebratoryspruce.ModBlockEntityTypes;
import com.startraveler.celebratoryspruce.ModBlocks;
import com.startraveler.celebratoryspruce.client.ItemRenderingBlockEntityRenderer;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceAdvancementProvider;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceBiomeModifiers;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceBlockLootTableProvider;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceBlockTagsProvider;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceDataMapProvider;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceEnglishUSLanguageProvider;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceItemTagsProvider;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceMobEffectTagProvider;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceModelProvider;
import com.startraveler.celebratoryspruce.datagen.CelebratorySpruceRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod(value="celebratoryspruce", dist={Dist.CLIENT})
@EventBusSubscriber(modid="celebratoryspruce", value={Dist.CLIENT})
public class CelebratorySpruceClient {
    public static final int SPRUCE_LEAVES_TINT = -10380959;

    public CelebratorySpruceClient(ModContainer container) {
        @NotNull IEventBus modBus = Objects.requireNonNull(container.getEventBus());
        modBus.addListener(CelebratorySpruceClient::gatherData);
        modBus.addListener(CelebratorySpruceClient::registerTints);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CELEBRATORY_SPRUCE_SAPLING.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.POTTED_CELEBRATORY_SPRUCE_SAPLING.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
        });
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.ITEM_RENDERING_BLOCK.get(), ItemRenderingBlockEntityRenderer::new);
    }

    public static void registerTints(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, blockAndTintGetter, blockPos, i) -> i == 0 ? -10380959 : -1, new Block[]{(Block)ModBlocks.DECORATED_SPRUCE_LEAVES.get(), (Block)ModBlocks.FESTIVE_SPRUCE_LEAVES.get(), (Block)ModBlocks.WREATH.get(), (Block)ModBlocks.WALL_WREATH.get(), (Block)ModBlocks.DECORATED_WREATH.get(), (Block)ModBlocks.DECORATED_WALL_WREATH.get()});
    }

    public static void gatherData(GatherDataEvent.Client event) {
        try {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = generator.getPackOutput();
            CompletableFuture lookupProvider = event.getLookupProvider();
            generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(CelebratorySpruceBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider){

                protected void validate(@NotNull WritableRegistry<LootTable> writableregistry, @NotNull ValidationContext context, // Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull ProblemReporter.Collector collector) {
                }
            });
            generator.addProvider(true, (DataProvider)new CelebratorySpruceRecipeProvider.Runner(packOutput, lookupProvider));
            CelebratorySpruceBlockTagsProvider blockTagsProvider = new CelebratorySpruceBlockTagsProvider(packOutput, lookupProvider);
            generator.addProvider(true, (DataProvider)blockTagsProvider);
            CelebratorySpruceMobEffectTagProvider mobEffectTagsProvider = new CelebratorySpruceMobEffectTagProvider(packOutput, lookupProvider);
            generator.addProvider(true, (DataProvider)mobEffectTagsProvider);
            generator.addProvider(true, (DataProvider)new CelebratorySpruceItemTagsProvider(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new CelebratorySpruceModelProvider(packOutput));
            generator.addProvider(true, (DataProvider)new CelebratorySpruceEnglishUSLanguageProvider(packOutput));
            generator.addProvider(true, (DataProvider)new AdvancementProvider(packOutput, lookupProvider, List.of(CelebratorySpruceAdvancementProvider::generate)));
            generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, new RegistrySetBuilder().add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, CelebratorySpruceBiomeModifiers::register), Set.of("celebratoryspruce", "minecraft")));
            generator.addProvider(true, (DataProvider)new CelebratorySpruceDataMapProvider(packOutput, lookupProvider));
        }
        catch (RuntimeException e) {
            CelebratorySpruce.LOGGER.error("Failed to generate data.", (Throwable)e);
        }
    }
}

