/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.block;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.Table;
import com.startraveler.celebratoryspruce.XFactHDShapeUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BoxPileBlock
extends Block {
    public static final int MIN_BOXES = 1;
    public static final int MAX_BOXES = 8;
    public static final IntegerProperty BOXES = IntegerProperty.create((String)"boxes", (int)1, (int)8);
    public static final EnumProperty<@NotNull Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final Table<Integer, Direction, VoxelShape> SHAPES = ArrayTable.create((Iterable)BOXES.getPossibleValues(), (Iterable)FACING.getPossibleValues());
    protected final Supplier<Ingredient> canIncreaseSize;

    public BoxPileBlock(BlockBehaviour.Properties properties, Supplier<Ingredient> canIncreaseSize) {
        super(properties);
        this.canIncreaseSize = canIncreaseSize;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BOXES, (Comparable)Integer.valueOf(1)));
    }

    @NotNull
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        int numBombs = (Integer)state.getValue((Property)BOXES);
        Item item = stack.getItem();
        if (numBombs < 8 && this.canIncreaseSize.get().test(stack)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BOXES, (Comparable)Integer.valueOf(numBombs + 1)));
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            stack.consume(1, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    protected boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        BlockState attachedTo = level.getBlockState(pos.below());
        return attachedTo.isFaceSturdy((BlockGetter)level, pos, Direction.UP) && super.canSurvive(state, level, pos);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int count = (Integer)state.getValue((Property)BOXES);
        Direction facing = (Direction)state.getValue(FACING);
        VoxelShape shape = (VoxelShape)SHAPES.get((Object)count, (Object)facing);
        if (shape == null) {
            shape = this.makeShape(count);
            shape = XFactHDShapeUtils.rotateShapeAroundY(Direction.NORTH, facing, shape);
            SHAPES.put((Object)count, (Object)facing, (Object)shape);
        }
        return shape;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection());
        return this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos()) ? state : null;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, @NotNull BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BOXES});
    }

    public VoxelShape makeShape(int number) {
        VoxelShape shape = Shapes.empty();
        switch (number) {
            case 1: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), (BooleanOp)BooleanOp.OR);
                break;
            }
            case 2: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.125, (double)0.5, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.375, (double)1.0, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
                break;
            }
            case 3: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.5, (double)1.0, (double)0.5, (double)1.0), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)0.5, (double)1.0), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.0, (double)0.75, (double)0.5, (double)0.5), (BooleanOp)BooleanOp.OR);
                break;
            }
            case 4: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), (BooleanOp)BooleanOp.OR);
                break;
            }
            case 5: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.5, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
                break;
            }
            case 6: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.5, (double)0.0, (double)0.9375, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.5, (double)0.5, (double)0.5625, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
                break;
            }
            case 7: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.5, (double)0.5, (double)0.75, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)0.5, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
                break;
            }
            case 8: {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
            }
        }
        return shape;
    }
}

