/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.block;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class DecoratedLeavesBlock
extends TintedParticleLeavesBlock {
    public static final int MIN_VARIANTS = 0;
    public static final int MAX_VARIANTS = 7;
    public static final IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)0, (int)7);
    @NotNull
    protected final Supplier<Ingredient> cycleIngredient;

    public DecoratedLeavesBlock(float particleProbability, @NotNull BlockBehaviour.Properties properties, @NotNull Supplier<Ingredient> cycleIngredient) {
        super(particleProbability, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)VARIANT, (Comparable)Integer.valueOf(0)));
        this.cycleIngredient = cycleIngredient;
    }

    @NotNull
    protected InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (stack.is(arg_0 -> ((Ingredient)this.cycleIngredient.get()).acceptsItem(arg_0))) {
            List values = VARIANT.getPossibleValues();
            int currentValueIndex = values.indexOf(state.getValue((Property)VARIANT));
            int numValues = values.size();
            int newValueIndex = (currentValueIndex + 1) % numValues;
            level.setBlockAndUpdate(pos, (BlockState)state.trySetValue((Property)VARIANT, (Comparable)((Integer)values.get(newValueIndex))));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, @NotNull BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VARIANT});
    }
}

