/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.startraveler.celebratoryspruce.block.entity.ItemHoldingBlockEntity;
import com.startraveler.celebratoryspruce.block.entity.ItemRenderingBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public class ItemDisplayingBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final float GLEAM_CHANCE = 0.2f;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final MapCodec<Optional<SimpleParticleType>> PARTICLE_OPTIONS_FIELD = BuiltInRegistries.PARTICLE_TYPE.byNameCodec().comapFlatMap(type -> {
        DataResult dataResult;
        if (type instanceof SimpleParticleType) {
            SimpleParticleType simpleParticleType = (SimpleParticleType)type;
            dataResult = DataResult.success((Object)simpleParticleType);
        } else {
            dataResult = DataResult.error(() -> "Not a SimpleParticleType: " + String.valueOf(type));
        }
        return dataResult;
    }, particleType -> particleType).optionalFieldOf("particle_options");
    public static final MapCodec<ItemDisplayingBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PARTICLE_OPTIONS_FIELD.forGetter(starBlock -> starBlock.gleamParticle), (App)ItemDisplayingBlock.propertiesCodec()).apply((Applicative)instance, ItemDisplayingBlock::new));
    private static final VoxelShape SHAPE = Block.column((double)12.0, (double)0.0, (double)16.0);
    protected final Optional<SimpleParticleType> gleamParticle;

    public ItemDisplayingBlock(Optional<SimpleParticleType> gleamParticle, BlockBehaviour.Properties properties) {
        super(properties);
        this.gleamParticle = gleamParticle;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected @NotNull List<@NotNull ItemRenderingBlockEntity.Transform<?>> setupDisplayTransforms(BlockState state) {
        @NotNull ArrayList<@NotNull ItemRenderingBlockEntity.Transform<?>> transforms = new ArrayList();
        transforms.addLast(new ItemRenderingBlockEntity.Translation(0.5f, 0.5f, 0.5f));
        return transforms;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state, boolean includeData, @NotNull Player player) {
        ItemHoldingBlockEntity itemHoldingBlockEntity;
        ItemStack cloneItemStack;
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof ItemHoldingBlockEntity && !(cloneItemStack = (itemHoldingBlockEntity = (ItemHoldingBlockEntity)blockEntity).getStoredItemStack()).isEmpty()) {
            return cloneItemStack;
        }
        return state.getCloneItemStack(level, pos, includeData);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess tickAccess, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return direction == Direction.DOWN && !this.canSurvive(state, level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, tickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (this.canChangeItem(state, (BlockGetter)level, pos)) {
            ItemRenderingBlockEntity itemRenderingBlockEntity;
            ItemStack stack;
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof ItemRenderingBlockEntity && !(stack = (itemRenderingBlockEntity = (ItemRenderingBlockEntity)blockEntity).getStoredItemStack()).isEmpty() && player.addItem(stack)) {
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS);
                itemRenderingBlockEntity.setStoredItemStack(ItemStack.EMPTY);
            }
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @NotNull
    protected InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (this.canChangeItem(state, (BlockGetter)level, pos) && (blockEntity = level.getBlockEntity(pos)) instanceof ItemRenderingBlockEntity) {
            ItemStack oldStack;
            ItemRenderingBlockEntity itemRenderingBlockEntity = (ItemRenderingBlockEntity)blockEntity;
            if (!level.isClientSide() && (oldStack = itemRenderingBlockEntity.getStoredItemStack()).isEmpty()) {
                ItemStack newStack = stack.copy();
                if (!player.getAbilities().instabuild) {
                    stack.setCount(0);
                }
                itemRenderingBlockEntity.setStoredItemStack(newStack);
                if (!newStack.isEmpty()) {
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS);
                    return InteractionResult.SUCCESS_SERVER;
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        return ItemDisplayingBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP) || this.alsoSurvivesWhen(state, level, pos);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public boolean canChangeItem(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return false;
    }

    @NotNull
    public MapCodec<? extends ItemDisplayingBlock> codec() {
        return CODEC;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (this.gleamParticle.isPresent() && random.nextFloat() < 0.2f) {
            AABB shape = this.getShape(state, (BlockGetter)level, pos, CollisionContext.empty()).bounds();
            double x = (double)pos.getX() + shape.minX + random.nextDouble() * shape.getXsize();
            double y = (double)pos.getY() + shape.minY + random.nextDouble() * shape.getYsize();
            double z = (double)pos.getZ() + shape.minZ + random.nextDouble() * shape.getZsize();
            level.addParticle((ParticleOptions)this.gleamParticle.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, @NotNull BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    public @Nullable BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        ItemRenderingBlockEntity itemRenderingBlockEntity = new ItemRenderingBlockEntity(blockPos, blockState);
        itemRenderingBlockEntity.setDefaultDisplayStack(this.asItem().getDefaultInstance());
        itemRenderingBlockEntity.addTransforms(this.setupDisplayTransforms(blockState));
        return itemRenderingBlockEntity;
    }

    protected boolean alsoSurvivesWhen(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).is(BlockTags.LEAVES);
    }
}

