/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.block;

import com.startraveler.celebratoryspruce.block.BoxPileBlock;
import com.startraveler.celebratoryspruce.block.entity.ItemHoldingBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public class ItemHoldingBoxPileBlock
extends BoxPileBlock
implements EntityBlock {
    public static final BooleanProperty CLOSED = BooleanProperty.create((String)"closed");

    public ItemHoldingBoxPileBlock(BlockBehaviour.Properties properties, Supplier<Ingredient> canIncreaseSize) {
        super(properties, canIncreaseSize);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CLOSED, (Comparable)Boolean.valueOf(false)));
    }

    public @Nullable BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ItemHoldingBlockEntity(blockPos, blockState);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (this.canChangeItem(state, (BlockGetter)level, pos)) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof ItemHoldingBlockEntity) {
                ItemHoldingBlockEntity itemHoldingBlockEntity = (ItemHoldingBlockEntity)blockEntity;
                ItemStack stack = itemHoldingBlockEntity.getStoredItemStack().copyAndClear();
                if (!stack.isEmpty()) {
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS);
                }
                player.addItem(stack);
                itemHoldingBlockEntity.setStoredItemStack(ItemStack.EMPTY);
            }
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected boolean triggerEvent(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, int id, int param) {
        super.triggerEvent(state, level, pos, id, param);
        BlockEntity blockentity = level.getBlockEntity(pos);
        return blockentity != null && blockentity.triggerEvent(id, param);
    }

    @Override
    @NotNull
    protected InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (this.canChangeItem(state, (BlockGetter)level, pos) && !stack.is(((Ingredient)this.canIncreaseSize.get()).getValues()) && (blockEntity = level.getBlockEntity(pos)) instanceof ItemHoldingBlockEntity) {
            ItemStack oldStack;
            ItemHoldingBlockEntity itemHoldingBlockEntity = (ItemHoldingBlockEntity)blockEntity;
            if (!level.isClientSide() && (oldStack = itemHoldingBlockEntity.getStoredItemStack()).isEmpty()) {
                ItemStack newStack = stack.copy();
                if (!player.getAbilities().instabuild) {
                    stack.setCount(0);
                }
                itemHoldingBlockEntity.setStoredItemStack(newStack);
                level.setBlockAndUpdate(pos, (BlockState)state.trySetValue((Property)CLOSED, (Comparable)Boolean.valueOf(true)));
                if (!newStack.isEmpty()) {
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS);
                    return InteractionResult.SUCCESS_SERVER;
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, @NotNull BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CLOSED});
    }

    public boolean canChangeItem(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return (Boolean)state.getValueOrElse((Property)CLOSED, (Comparable)Boolean.valueOf(false)) == false;
    }
}

