/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.block;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.startraveler.celebratoryspruce.block.RandomizedDecoratedLeavesBlock;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightNetBlock
extends MultifaceSpreadeableBlock {
    public static final MapCodec<LightNetBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LightNetBlock.propertiesCodec(), (App)Ingredient.CODEC.xmap(Suppliers::ofInstance, Supplier::get).fieldOf("ingredient").forGetter(lightNetBlock -> lightNetBlock.cycleIngredient)).apply((Applicative)instance, LightNetBlock::new));
    public static final int MIN_VARIANTS = 0;
    public static final int MAX_VARIANTS = 7;
    public static final IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)0, (int)7);
    @NotNull
    protected final @NotNull Supplier<@NotNull Ingredient> cycleIngredient;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);

    public LightNetBlock(@NotNull BlockBehaviour.Properties properties, @NotNull @NotNull Supplier<@NotNull Ingredient> cycleIngredient) {
        super(properties);
        this.cycleIngredient = cycleIngredient;
    }

    public static ToIntFunction<BlockState> emission(int light) {
        return state -> MultifaceBlock.hasAnyFace((BlockState)state) ? light : 0;
    }

    @NotNull
    public MapCodec<LightNetBlock> codec() {
        return CODEC;
    }

    @NotNull
    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, @NotNull BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VARIANT});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return RandomizedDecoratedLeavesBlock.applyRandomVariant(super.getStateForPlacement(context), context.getClickedPos(), VARIANT);
    }

    @NotNull
    protected InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (stack.is(arg_0 -> ((Ingredient)((Ingredient)this.cycleIngredient.get())).acceptsItem(arg_0))) {
            List values = VARIANT.getPossibleValues();
            int currentValueIndex = values.indexOf(state.getValue((Property)VARIANT));
            int numValues = values.size();
            int newValueIndex = (currentValueIndex + 1) % numValues;
            level.setBlockAndUpdate(pos, (BlockState)state.trySetValue((Property)VARIANT, (Comparable)((Integer)values.get(newValueIndex))));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }
}

