/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.block;

import com.mojang.math.Axis;
import com.startraveler.celebratoryspruce.block.ItemDisplayingBlock;
import com.startraveler.celebratoryspruce.block.entity.ItemRenderingBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class StandingItemDisplayingBlock
extends ItemDisplayingBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;

    public StandingItemDisplayingBlock(Optional<SimpleParticleType> gleamParticle, BlockBehaviour.Properties properties) {
        super(gleamParticle, properties);
    }

    @Override
    @NotNull
    protected @NotNull List< @NotNull ItemRenderingBlockEntity.Transform<?>> setupDisplayTransforms(BlockState state) {
        @NotNull List< @NotNull ItemRenderingBlockEntity.Transform<?>> transforms = super.setupDisplayTransforms(state);
        float angle = (float)Math.PI / 180 * this.getYRotationDegrees(state);
        transforms.addLast(new ItemRenderingBlockEntity.Rotation(Axis.YN.rotation(angle)));
        transforms.addLast(new ItemRenderingBlockEntity.Rotation(Axis.YN.rotation((float)Math.PI)));
        return transforms;
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, @NotNull BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ROTATION});
    }

    public float getYRotationDegrees(BlockState state) {
        return RotationSegment.convertToDegrees((int)((Integer)state.getValue((Property)ROTATION)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)(context.getRotation() + 180.0f))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rot.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }
}

