/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.block;

import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.startraveler.celebratoryspruce.block.ItemDisplayingBlock;
import com.startraveler.celebratoryspruce.block.entity.ItemRenderingBlockEntity;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public class WallItemDisplayingBlock
extends ItemDisplayingBlock {
    public static final EnumProperty<@NotNull Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final float DISPLAY_OFFSET = 0.0f;
    protected static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal((VoxelShape)Block.boxZ((double)16.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0));

    public WallItemDisplayingBlock(Optional<SimpleParticleType> gleamParticle, BlockBehaviour.Properties properties) {
        super(gleamParticle, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public static VoxelShape getShape(BlockState state) {
        return SHAPES.get(state.getValue(FACING));
    }

    public static boolean canSurvive(LevelReader level, BlockPos pos, Direction facing) {
        BlockPos oppositePos = pos.relative(facing.getOpposite());
        BlockState oppositeState = level.getBlockState(oppositePos);
        return oppositeState.isFaceSturdy((BlockGetter)level, oppositePos, facing);
    }

    @Override
    @NotNull
    protected @NotNull List< @NotNull ItemRenderingBlockEntity.Transform<?>> setupDisplayTransforms(BlockState state) {
        @NotNull List< @NotNull ItemRenderingBlockEntity.Transform<?>> transforms = super.setupDisplayTransforms(state);
        Direction facing = (Direction)state.getValue(FACING);
        transforms.addLast(new ItemRenderingBlockEntity.Rotation(facing.getRotation()));
        transforms.addLast(new ItemRenderingBlockEntity.Rotation(Axis.XN.rotation(1.5707964f)));
        transforms.addLast(new ItemRenderingBlockEntity.Translation(0.0f, 0.0f, -0.46875f));
        transforms.addLast(new ItemRenderingBlockEntity.Rotation(Axis.YN.rotation((float)Math.PI)));
        return transforms;
    }

    @Override
    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess tickAccess, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        return direction.getOpposite() == state.getValue(FACING) && !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, tickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        return WallItemDisplayingBlock.canSurvive(level, pos, (Direction)state.getValue(FACING)) || this.alsoSurvivesWhen(state, level, pos);
    }

    @Override
    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return WallItemDisplayingBlock.getShape(state);
    }

    @NotNull
    public MapCodec<ItemDisplayingBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, @NotNull BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Override
    protected boolean alsoSurvivesWhen(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACING);
        BlockPos oppositePos = pos.relative(facing.getOpposite());
        BlockState oppositeState = level.getBlockState(oppositePos);
        return oppositeState.is(BlockTags.LEAVES);
    }

    public @Nullable BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction[] lookingDirections = context.getNearestLookingDirections();
        FluidState fluidState = level.getFluidState(pos);
        for (Direction direction : lookingDirections) {
            Direction opposite;
            if (!direction.getAxis().isHorizontal() || !(state = (BlockState)state.setValue(FACING, (Comparable)(opposite = direction.getOpposite()))).canSurvive((LevelReader)level, pos)) continue;
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }
}

