/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.startraveler.celebratoryspruce.ModBlockEntityTypes;
import com.startraveler.celebratoryspruce.block.entity.ItemHoldingBlockEntity;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class ItemRenderingBlockEntity
extends ItemHoldingBlockEntity
implements ItemOwner {
    public static final String DEFAULT_ITEM_KEY = "default_item";
    public static final String TRANSFORMS_KEY = "transforms";
    @NotNull
    protected final List<Transform<?>> transforms = new ArrayList();
    @NotNull
    protected ItemStack defaultDisplayStack = ItemStack.EMPTY;
    protected @Nullable Matrix4f bakedTransforms = null;
    protected float bakedYRotation = 0.0f;

    public ItemRenderingBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.ITEM_RENDERING_BLOCK.get(), pos, blockState);
    }

    @Override
    public void loadAdditional(@NotNull ValueInput input) {
        super.loadAdditional(input);
        this.defaultDisplayStack = input.read(DEFAULT_ITEM_KEY, ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
        this.transforms.clear();
        this.transforms.addAll(input.read(TRANSFORMS_KEY, Transform.TRANSFORM_CODEC.listOf()).orElse(List.of()));
        this.bakedTransforms = null;
    }

    @Override
    public void saveAdditional(@NotNull ValueOutput output) {
        super.saveAdditional(output);
        output.store(DEFAULT_ITEM_KEY, ItemStack.OPTIONAL_CODEC, (Object)this.defaultDisplayStack);
        output.store(TRANSFORMS_KEY, Transform.TRANSFORM_CODEC.listOf(), this.transforms);
    }

    @Override
    public void markAsChanged() {
        super.markAsChanged();
        this.bakedTransforms = null;
    }

    public void addTransform(Transform<?> transform) {
        this.transforms.addLast(transform);
        this.markAsChanged();
    }

    public void clearTransforms() {
        this.transforms.clear();
        this.markAsChanged();
    }

    @NotNull
    public ItemStack getDefaultDisplayStack() {
        return this.defaultDisplayStack;
    }

    public void setDefaultDisplayStack(@NotNull ItemStack stack) {
        this.defaultDisplayStack = stack;
        this.markAsChanged();
    }

    @NotNull
    public ItemStack getStackForDisplay() {
        ItemStack stack = this.getStoredItemStack();
        return stack.isEmpty() ? this.getDefaultDisplayStack() : stack;
    }

    @NotNull
    public List<Transform<?>> getTransforms() {
        return this.transforms;
    }

    public void addTransforms(@NotNull List<Transform<?>> transforms) {
        this.transforms.addAll(transforms);
        this.markAsChanged();
    }

    @NotNull
    public Level level() {
        return Objects.requireNonNull(this.level);
    }

    @NotNull
    public Vec3 position() {
        return this.getBlockPos().getCenter();
    }

    public float getVisualRotationYInDegrees() {
        if (this.bakedTransforms == null) {
            AxisAngle4f angle = this.bakeTransforms().getRotation(new AxisAngle4f()).normalize();
            Vector3f yAxis = new Vector3f(0.0f, -1.0f, 0.0f);
            this.bakedYRotation = 57.295776f * angle.angle * yAxis.dot(angle.x, angle.y, angle.z);
        }
        return this.bakedYRotation;
    }

    @NotNull
    public Matrix4f bakeTransforms() {
        if (this.bakedTransforms == null) {
            this.bakedTransforms = new Matrix4f();
            for (Transform<?> transform : this.transforms) {
                transform.apply(this.bakedTransforms);
            }
        }
        return this.bakedTransforms;
    }

    public static abstract class Transform<T>
    implements Function<Matrix4f, Matrix4f> {
        public static final Codec<Transform<?>> TRANSFORM_CODEC = TransformType.CODEC.dispatch(Transform::getType, transformType -> transformType.codec().fieldOf("transform"));
        public static final StreamCodec<ByteBuf, Transform<?>> TRANSFORM_STREAM_CODEC = TransformType.STREAM_CODEC.dispatch(Transform::getType, TransformType::streamCodec);
        protected final TransformType type;

        protected Transform(TransformType type) {
            this.type = type;
        }

        public TransformType getType() {
            return this.type;
        }

        @Override
        public abstract Matrix4f apply(Matrix4f var1);

        @NotNull
        public abstract @NotNull StreamCodec<ByteBuf, @NotNull T> streamCodec();

        @NotNull
        public abstract @NotNull Codec<@NotNull T> codec();
    }

    public static class Scale
    extends Transform<Scale> {
        public static final Codec<Scale> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(s -> Float.valueOf(s.x)), (App)Codec.FLOAT.fieldOf("y").forGetter(s -> Float.valueOf(s.y)), (App)Codec.FLOAT.fieldOf("z").forGetter(s -> Float.valueOf(s.z))).apply((Applicative)instance, Scale::new));
        public static final StreamCodec<ByteBuf, Scale> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, s -> Float.valueOf(s.x), (StreamCodec)ByteBufCodecs.FLOAT, s -> Float.valueOf(s.y), (StreamCodec)ByteBufCodecs.FLOAT, s -> Float.valueOf(s.z), Scale::new);
        protected final float x;
        protected final float y;
        protected final float z;

        public Scale(float s) {
            super(TransformType.SCALE);
            this.x = s;
            this.y = s;
            this.z = s;
        }

        public Scale(float x, float y, float z) {
            super(TransformType.SCALE);
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Scale(Vector3f vector) {
            super(TransformType.ROTATION);
            this.x = vector.x;
            this.y = vector.y;
            this.z = vector.z;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        @NotNull
        public Vector3f vector() {
            return new Vector3f(this.x, this.y, this.z);
        }

        @Override
        public Matrix4f apply(Matrix4f stack) {
            return stack.scale(this.x, this.y, this.z);
        }

        @Override
        @NotNull
        public @NotNull StreamCodec<ByteBuf, @NotNull Scale> streamCodec() {
            return STREAM_CODEC;
        }

        @Override
        @NotNull
        public @NotNull Codec<@NotNull Scale> codec() {
            return CODEC;
        }
    }

    public static class Translation
    extends Transform<Translation> {
        public static final Codec<Translation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(t -> Float.valueOf(t.x)), (App)Codec.FLOAT.fieldOf("y").forGetter(t -> Float.valueOf(t.y)), (App)Codec.FLOAT.fieldOf("z").forGetter(t -> Float.valueOf(t.z))).apply((Applicative)instance, Translation::new));
        public static final StreamCodec<ByteBuf, Translation> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, t -> Float.valueOf(t.x), (StreamCodec)ByteBufCodecs.FLOAT, t -> Float.valueOf(t.y), (StreamCodec)ByteBufCodecs.FLOAT, t -> Float.valueOf(t.z), Translation::new);
        protected final float x;
        protected final float y;
        protected final float z;
        protected final Vector3f vector3f;

        public Translation(float x, float y, float z) {
            super(TransformType.TRANSLATION);
            this.x = x;
            this.y = y;
            this.z = z;
            this.vector3f = new Vector3f(this.x, this.y, this.z);
        }

        public Translation(Vector3f vector) {
            super(TransformType.ROTATION);
            this.x = vector.x;
            this.y = vector.y;
            this.z = vector.z;
            this.vector3f = new Vector3f(this.x, this.y, this.z);
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        @NotNull
        public Vector3f vector() {
            return this.vector3f;
        }

        @Override
        public Matrix4f apply(Matrix4f stack) {
            return stack.translate((Vector3fc)this.vector3f);
        }

        @Override
        @NotNull
        public @NotNull StreamCodec<ByteBuf, @NotNull Translation> streamCodec() {
            return STREAM_CODEC;
        }

        @Override
        @NotNull
        public @NotNull Codec<@NotNull Translation> codec() {
            return CODEC;
        }
    }

    public static class Rotation
    extends Transform<Rotation> {
        public static final Codec<Rotation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(r -> Float.valueOf(r.x)), (App)Codec.FLOAT.fieldOf("y").forGetter(r -> Float.valueOf(r.y)), (App)Codec.FLOAT.fieldOf("z").forGetter(r -> Float.valueOf(r.z)), (App)Codec.FLOAT.fieldOf("w").forGetter(r -> Float.valueOf(r.w))).apply((Applicative)instance, Rotation::new));
        public static final StreamCodec<ByteBuf, Rotation> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.x), (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.y), (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.z), (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(r.w), Rotation::new);
        protected final float x;
        protected final float y;
        protected final float z;
        protected final float w;
        protected final Quaternionf quaternionf;

        public Rotation(float x, float y, float z, float w) {
            super(TransformType.ROTATION);
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
            this.quaternionf = new Quaternionf(this.x, this.y, this.z, this.w);
        }

        public Rotation(Quaternionf quaternion) {
            super(TransformType.ROTATION);
            this.x = quaternion.x;
            this.y = quaternion.y;
            this.z = quaternion.z;
            this.w = quaternion.w;
            this.quaternionf = new Quaternionf(this.x, this.y, this.z, this.w);
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float getW() {
            return this.w;
        }

        @NotNull
        public Quaternionf quaternion() {
            return this.quaternionf;
        }

        @Override
        public Matrix4f apply(Matrix4f stack) {
            return stack.rotate((Quaternionfc)this.quaternionf);
        }

        @Override
        @NotNull
        public @NotNull StreamCodec<ByteBuf, @NotNull Rotation> streamCodec() {
            return STREAM_CODEC;
        }

        @Override
        @NotNull
        public @NotNull Codec<@NotNull Rotation> codec() {
            return CODEC;
        }
    }

    public static class TransformTypeCodecRegistry {
        public static final Map<TransformType, Codec<? extends Transform<?>>> CODECS = new HashMap();
        public static final Map<TransformType, StreamCodec<ByteBuf, ? extends Transform<?>>> STREAM_CODECS = new HashMap();

        public static void init() {
            TransformTypeCodecRegistry.initCodecs();
            TransformTypeCodecRegistry.initStreamCodecs();
        }

        public static void initCodecs() {
            CODECS.put(TransformType.ROTATION, Rotation.CODEC);
            CODECS.put(TransformType.TRANSLATION, Translation.CODEC);
            CODECS.put(TransformType.SCALE, Scale.CODEC);
        }

        public static void initStreamCodecs() {
            STREAM_CODECS.put(TransformType.ROTATION, Rotation.STREAM_CODEC);
            STREAM_CODECS.put(TransformType.TRANSLATION, Translation.STREAM_CODEC);
            STREAM_CODECS.put(TransformType.SCALE, Scale.STREAM_CODEC);
        }
    }

    public static enum TransformType implements StringRepresentable
    {
        ROTATION("rotation"),
        TRANSLATION("translation"),
        SCALE("scale");

        public static final Codec<TransformType> CODEC;
        public static final Function<String, @Nullable TransformType> NAME_LOOKUP;
        public static final Function<TransformType, String> TYPE_LOOKUP;
        public static final StreamCodec<ByteBuf, TransformType> STREAM_CODEC;
        final String type;

        private TransformType(String type) {
            this.type = type;
        }

        @NotNull
        public Codec<? extends Transform<?>> codec() {
            return TransformTypeCodecRegistry.CODECS.get((Object)this);
        }

        @NotNull
        public @NotNull StreamCodec<ByteBuf, ? extends @NotNull Transform<?>> streamCodec() {
            return TransformTypeCodecRegistry.STREAM_CODECS.get((Object)this);
        }

        @NotNull
        public String getSerializedName() {
            return this.type;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TransformType::values);
            NAME_LOOKUP = StringRepresentable.createNameLookup((StringRepresentable[])TransformType.values());
            TYPE_LOOKUP = TransformType::getSerializedName;
            STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(NAME_LOOKUP, TYPE_LOOKUP);
        }
    }
}

