/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.startraveler.celebratoryspruce.block.entity.ItemRenderingBlockEntity;
import com.startraveler.celebratoryspruce.client.ItemRenderingBlockEntityRenderState;
import java.util.List;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public class ItemRenderingBlockEntityRenderer<T extends ItemRenderingBlockEntity>
implements BlockEntityRenderer<T, ItemRenderingBlockEntityRenderState> {
    private final ItemModelResolver itemModelResolver;

    public ItemRenderingBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public static void applyAllTransforms(PoseStack stack, List<ItemRenderingBlockEntity.Transform<?>> transforms) {
        for (ItemRenderingBlockEntity.Transform<?> transform : transforms) {
            transform.apply(stack.last().pose());
        }
    }

    @NotNull
    public ItemRenderingBlockEntityRenderState createRenderState() {
        return new ItemRenderingBlockEntityRenderState();
    }

    public void extractRenderState(T blockEntity, ItemRenderingBlockEntityRenderState renderState, float partialTick, @NotNull Vec3 cameraPosition, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        ItemStack stack = ((ItemRenderingBlockEntity)((Object)blockEntity)).getStackForDisplay();
        Boolean isNormallyFoil = (Boolean)stack.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)false);
        renderState.item = new ItemStackRenderState();
        this.itemModelResolver.updateForTopItem(renderState.item, ((ItemRenderingBlockEntity)((Object)blockEntity)).getStackForDisplay(), ItemDisplayContext.FIXED, blockEntity.getLevel(), blockEntity, (int)blockEntity.getBlockPos().asLong());
        if (isNormallyFoil != null) {
            stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)isNormallyFoil);
        }
        renderState.transforms = ((ItemRenderingBlockEntity)((Object)blockEntity)).getTransforms();
    }

    public void submit(ItemRenderingBlockEntityRenderState itemRenderingBlockEntityRenderState, @NotNull PoseStack poseStack, @NotNull SubmitNodeCollector submitNodeCollector, @NotNull CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        ItemRenderingBlockEntityRenderer.applyAllTransforms(poseStack, itemRenderingBlockEntityRenderState.transforms);
        itemRenderingBlockEntityRenderState.item.submit(poseStack, submitNodeCollector, itemRenderingBlockEntityRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }
}

