/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.datagen;

import com.startraveler.celebratoryspruce.ModBlocks;
import com.startraveler.celebratoryspruce.ModItems;
import com.startraveler.celebratoryspruce.block.BoxPileBlock;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class CelebratorySpruceBlockLootTableProvider
extends BlockLootSubProvider {
    protected static final float[] EXTRA_LEAVES_SAPLING_CHANCES = new float[]{0.1f, 0.125f, 0.16666667f, 0.2f};
    protected final Set<Block> knownBlocks = new HashSet<Block>();

    public CelebratorySpruceBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected LootTable.Builder createChanceDrops(Block block, Item item, float chance) {
        return this.createShearsDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)item).when(LootItemRandomChanceCondition.randomChance((float)chance))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)((HolderLookup.RegistryLookup)this.registries.lookup(Registries.ENCHANTMENT).orElseThrow()).getOrThrow(Enchantments.FORTUNE), (int)2))));
    }

    public LootTable.Builder createSingleItemTable(ItemLike item, List<Integer> range) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition(item, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)range.get(0).intValue(), (float)range.get(1).intValue()))))));
    }

    protected void generate() {
        this.knownBlocks.addAll(ModBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toSet()));
        this.add((Block)ModBlocks.DECORATED_SPRUCE_LEAVES.get(), this.createItemLeavesDrops((Block)ModBlocks.DECORATED_SPRUCE_LEAVES.get(), (Block)ModBlocks.CELEBRATORY_SPRUCE_SAPLING.get(), (ItemLike)ModItems.ORNAMENT.get()));
        this.add((Block)ModBlocks.FESTIVE_SPRUCE_LEAVES.get(), this.createItemLeavesDrops((Block)ModBlocks.FESTIVE_SPRUCE_LEAVES.get(), (Block)ModBlocks.CELEBRATORY_SPRUCE_SAPLING.get(), (ItemLike)ModItems.FESTIVE_LIGHT.get()));
        this.dropSelf((Block)ModBlocks.CELEBRATORY_SPRUCE_SAPLING.get());
        this.add((Block)ModBlocks.POTTED_CELEBRATORY_SPRUCE_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.CELEBRATORY_SPRUCE_SAPLING.get()));
        this.dropOther((Block)ModBlocks.GOLD_STAR.get(), (ItemLike)ModItems.GOLD_STAR.get());
        this.dropOther((Block)ModBlocks.WALL_GOLD_STAR.get(), (ItemLike)ModItems.GOLD_STAR.get());
        this.add((Block)ModBlocks.LIGHT_NET.get(), this.createMultifaceBlockDrops((Block)ModBlocks.LIGHT_NET.get()));
        this.dropOther((Block)ModBlocks.WREATH.get(), (ItemLike)ModItems.WREATH.get());
        this.dropOther((Block)ModBlocks.WALL_WREATH.get(), (ItemLike)ModItems.WREATH.get());
        this.dropOther((Block)ModBlocks.DECORATED_WREATH.get(), (ItemLike)ModItems.DECORATED_WREATH.get());
        this.dropOther((Block)ModBlocks.DECORATED_WALL_WREATH.get(), (ItemLike)ModItems.DECORATED_WREATH.get());
        this.dropOther((Block)ModBlocks.ITEM_DISPLAY.get(), (ItemLike)ModItems.ITEM_DISPLAY.get());
        this.dropOther((Block)ModBlocks.WALL_ITEM_DISPLAY.get(), (ItemLike)ModItems.ITEM_DISPLAY.get());
        BiFunction<Block, ItemLike, LootTable.Builder> bombPileTableMaker = (block, itemLike) -> LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)itemLike, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BoxPileBlock.BOXES, 1)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BoxPileBlock.BOXES, 2)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BoxPileBlock.BOXES, 3)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)3.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BoxPileBlock.BOXES, 4)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BoxPileBlock.BOXES, 5)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)5.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BoxPileBlock.BOXES, 6)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)6.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BoxPileBlock.BOXES, 7)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)7.0f)))).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BoxPileBlock.BOXES, 8)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)8.0f))))));
        this.add((Block)ModBlocks.PRESENT_PILE.get(), bombPileTableMaker.apply((Block)ModBlocks.PRESENT_PILE.get(), (ItemLike)ModItems.PRESENT.get()));
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    @NotNull
    protected LootTable.Builder createItemLeavesDrops(@NotNull Block leavesBlock, @NotNull Block saplingBlock, @NotNull ItemLike bonusItem) {
        return this.createItemLeavesDrops(leavesBlock, saplingBlock, bonusItem, EXTRA_LEAVES_SAPLING_CHANCES);
    }

    @NotNull
    protected LootTable.Builder createItemLeavesDrops(@NotNull Block leavesBlock, @NotNull Block saplingBlock, @NotNull ItemLike bonusItem, float ... chances) {
        return this.createLeavesDrops(leavesBlock, saplingBlock, chances).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)leavesBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)bonusItem))));
    }

    protected LootTable.Builder createOreDrops(Block block, ItemLike item, List<Integer> range) {
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)range.get(0).intValue(), (float)range.get(1).intValue()))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)((HolderLookup.RegistryLookup)this.registries.lookup(Registries.ENCHANTMENT).orElseThrow()).getOrThrow(Enchantments.FORTUNE)))));
    }

    protected void dropOther(Block block, ItemLike item, List<Integer> range) {
        this.add(block, this.createSingleItemTable(item, range));
    }

    protected LootTable.Builder createSilkTouchDrop(Block pBlock, Item item) {
        return this.createSilkTouchDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item)));
    }

    protected LootTable.Builder createSilkTouchOrShearsOreDrops(Block block, Item item, List<Integer> range) {
        return this.createSilkTouchOrShearsDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)range.get(0).intValue(), (float)range.get(1).intValue()))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)((HolderLookup.RegistryLookup)this.registries.lookup(Registries.ENCHANTMENT).orElseThrow()).getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createSilkTouchOrShearsDrop(Block pBlock, Item item) {
        return this.createSilkTouchOrShearsDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item)));
    }

    protected LootTable.Builder createSilkTouchOrShearsDrop(Block pBlock, Item item, List<Integer> range) {
        return this.createSilkTouchOrShearsOreDrops(pBlock, item, range);
    }

    protected void requireSilkTouch(Block base, ItemLike withoutSilk) {
        this.add(base, block -> this.createSilkTouchDrop(base, withoutSilk.asItem()));
    }

    protected void requireSilkTouchOrShears(Block base, ItemLike withoutSilk) {
        this.add(base, block -> this.createSilkTouchOrShearsDrop(base, withoutSilk.asItem()));
    }

    protected void requireSilkTouchOrShears(Block base, ItemLike withoutSilk, List<Integer> range) {
        this.add(base, block -> this.createSilkTouchOrShearsDrop(base, withoutSilk.asItem(), range));
    }

    protected void requireSilkTouch(Block base, ItemLike withoutSilk, List<Integer> range) {
        this.add(base, block -> this.createOreDrops(base, (ItemLike)withoutSilk.asItem(), range));
    }

    protected void requireSilkTouchDropsOther(Block base, Block source) {
        Identifier sourceLoc = BuiltInRegistries.BLOCK.getKey((Object)source).withPrefix("blocks/");
        this.add(base, block -> this.createSilkTouchOrOtherDrop((Block)block, sourceLoc));
    }

    protected void oreDrop(Block base, ItemLike drop, List<Integer> range) {
        this.add(base, block -> this.createOreDrops(base, drop, range));
    }

    protected LootTable.Builder createSilkTouchOrOtherDrop(Block block, Identifier source) {
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)NestedLootTable.lootTableReference((ResourceKey)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)source))));
    }
}

