/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.datagen;

import com.google.common.base.Suppliers;
import com.startraveler.celebratoryspruce.CelebratorySpruce;
import com.startraveler.celebratoryspruce.Config;
import com.startraveler.celebratoryspruce.HasDescriptionId;
import com.startraveler.celebratoryspruce.ModBlocks;
import com.startraveler.celebratoryspruce.ModItems;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.apache.commons.lang3.text.WordUtils;

public class CelebratorySpruceEnglishUSLanguageProvider
extends LanguageProvider {
    private final Set<Block> excludedBlocks = new HashSet<Block>();
    private final Set<Item> excludedItems = new HashSet<Item>();
    private final Set<TagKey<?>> excludedTags = new HashSet();
    private final Set<MobEffect> excludedEffects = new HashSet<MobEffect>();
    private final Set<EntityType<?>> excludedEntityTypes = new HashSet();
    private final Set<Potion> excludedPotions = new HashSet<Potion>();

    public CelebratorySpruceEnglishUSLanguageProvider(PackOutput output) {
        super(output, "celebratoryspruce", "en_us");
    }

    protected void addTranslations() {
        this.exclude((Item)ModItems.MUSIC_DISC_SILENT_NIGHT.get(), "Carol Disc", this.excludedItems);
        this.exclude((Item)ModItems.MUSIC_DISC_WHAT_CHILD.get(), "Carol Disc", this.excludedItems);
        this.exclude((Item)ModItems.MUSIC_DISC_CHRISTMAS_DAY_BELLS.get(), "Carol Disc", this.excludedItems);
        this.exclude((Item)ModItems.MUSIC_DISC_CAROL_OF_THE_BELLS.get(), "Carol Disc", this.excludedItems);
        this.add("jukebox_song.celebratoryspruce.silent_night", "Franz Gruber - Silent Night");
        this.add("jukebox_song.celebratoryspruce.what_child", "William Chatterton Dix - What Child Is This?");
        this.add("jukebox_song.celebratoryspruce.christmas_day_bells", "Henry Wadsworth Longfellow / John Baptiste Calkin - I Heard the Bells on Christmas Day");
        this.add("jukebox_song.celebratoryspruce.carol_of_the_bells", "Mykola Leontovych / Jason Shaw - Shchedryk (Carol of the Bells)");
        this.add((ModConfigSpec.ConfigValue)Config.ICE_MELTS_IN_LIGHT);
        this.add((ModConfigSpec.ConfigValue)Config.ICE_MELTING_THRESHOLD);
        this.add((ModConfigSpec.ConfigValue)Config.ICE_FREEZING_THRESHOLD);
        this.add((ModConfigSpec.ConfigValue)Config.SNOW_MELTS_IN_LIGHT);
        this.add((ModConfigSpec.ConfigValue)Config.SNOW_MELTING_THRESHOLD);
        this.add((ModConfigSpec.ConfigValue)Config.SNOW_ACCUMULATION_THRESHOLD);
        this.add((ModConfigSpec.ConfigValue)Config.SNOW_TEMPERATURE_THRESHOLD);
        this.add("celebratoryspruce.configuration.section.celebratoryspruce.common.toml.title", "Celebratory Spruce Common Configuration");
        this.add("celebratoryspruce.configuration.snowBuildupLightThreshold.tooltip", "The light level below which snow accumulates. Typically one less than the level at which snow melts.");
        this.add("celebratoryspruce.configuration.title", "Celebratory Spruce Configuration");
        this.add("celebratoryspruce.configuration.iceMeltsInLight.tooltip", "Whether or not ice melts in light.");
        this.add("celebratoryspruce.configuration.snowMeltsInLight.tooltip", "Whether or not snow melts in light.");
        this.add("celebratoryspruce.configuration.iceMeltingLightThreshold.tooltip", "The light level above which ice melts, if ice melting in light is enabled. Typically one more than the level at which ice freezes.");
        this.add("celebratoryspruce.configuration.snowMeltingLightThreshold.tooltip", "The light level above which snow melts, if snow melting in light is enabled. Typically one more than the level at which snow lands.");
        this.add("celebratoryspruce.configuration.section.celebratoryspruce.common.toml", "Celebratory Spruce Common");
        this.add("celebratoryspruce.configuration.snowTemperatureThreshold.tooltip", "The temperature threshold required for rain to turn to snow. Higher values will make warm biomes have snow; lower values will make cold biomes have rain.");
        this.add("celebratoryspruce.configuration.iceFreezingLightThreshold.tooltip", "The light level below which ice freezes. Typically one less than the level at which ice melts.");
        this.add("item.celebratoryspruce.goodie_bag.for", "For: ");
        this.add("item.celebratoryspruce.goodie_bag.contains_one", "Contains a gift! Use to open.");
        this.add("item.celebratoryspruce.goodie_bag.contains_n", "Contains %s gifts! Use to open.");
        this.add("item.celebratoryspruce.goodie_bag.empty", "Add a stack of items!");
        this.add("itemGroup.celebratory_spruce_items", "Celebratory Spruce Items");
        this.addTranslations(ModBlocks.BLOCKS.getEntries(), this.excludedBlocks);
        this.addTranslations(ModItems.ITEMS.getEntries(), this.excludedItems);
        this.addTranslations(Set.of(), this.excludedEffects);
        this.addTranslations(Set.of(), this.excludedEntityTypes);
        this.addPotionTranslations(Set.of(), this.excludedPotions);
    }

    public <T> void add(ModConfigSpec.ConfigValue<T> configValue) {
        List rawName = configValue.getPath();
        List<String> splitRawName = List.of(((String)rawName.getLast()).split("(?=\\p{Lu})"));
        String name = splitRawName.stream().map(WordUtils::capitalize).flatMap(string -> Stream.of(string, " ")).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        String rawNameJoinedByDots = String.join((CharSequence)".", rawName);
        String generatedTranslationKey = "celebratoryspruce.configuration." + rawNameJoinedByDots;
        this.add(generatedTranslationKey, name);
    }

    public <T extends HasDescriptionId> void exclude(T key, String name, Set<T> values) {
        values.add(key);
        super.add(key.getDescriptionId(), name);
    }

    public void excludeTag(TagKey<?> tagKey, String name) {
        this.excludedTags.add(tagKey);
        super.add(tagKey, name);
    }

    protected void addTagTranslations(Iterable<TagKey<?>> tags) {
        tags.forEach(tag -> {
            if (!this.excludedTags.contains(tag)) {
                this.addTag((Supplier)Suppliers.ofInstance((Object)tag), WordUtils.capitalize((String)tag.location().getPath().replace('/', ' ').replace('_', ' ')));
            }
        });
    }

    protected <T extends HasDescriptionId> void addTranslations(Iterable<? extends Holder<T>> toTranslate, Set<T> addTo) {
        toTranslate.forEach(holder -> {
            String id = ((HasDescriptionId)holder.value()).getDescriptionId();
            if (!addTo.contains(holder.value())) {
                try {
                    this.add(id, WordUtils.capitalize((String)Objects.requireNonNull(holder.getKey()).identifier().getPath().replace('/', ' ').replace('_', ' ')));
                }
                catch (IllegalStateException e) {
                    CelebratorySpruce.LOGGER.warn("Skipping duplicate translation key {}", (Object)id);
                }
            } else {
                CelebratorySpruce.LOGGER.warn("Skipping manually entered translation key {}", (Object)id);
            }
        });
    }

    protected void addPotionTranslations(Iterable<Holder<Potion>> potions, Set<Potion> excludedPotions) {
        potions.forEach(holder -> {
            if (!excludedPotions.contains(holder.value())) {
                String rawId = Objects.requireNonNull(holder.getKey()).identifier().getPath();
                String id = rawId.replace("long_", "").replace("strong_", "").replace("_", " ");
                String name = WordUtils.capitalize((String)id);
                this.add("item.minecraft.potion.effect." + rawId, "Potion of " + name);
                this.add("item.minecraft.splash_potion.effect." + rawId, "Splash Potion of " + name);
                this.add("item.minecraft.lingering_potion.effect." + rawId, "Lingering Potion of " + name);
                this.add("item.minecraft.tipped_arrow.effect." + rawId, "Arrow of " + name);
            }
        });
    }
}

