/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.datagen;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quadrant;
import com.startraveler.celebratoryspruce.ModBlocks;
import com.startraveler.celebratoryspruce.ModItems;
import com.startraveler.celebratoryspruce.Util;
import com.startraveler.celebratoryspruce.block.BoxPileBlock;
import com.startraveler.celebratoryspruce.block.DecoratedLeavesBlock;
import com.startraveler.celebratoryspruce.block.DecoratedWreathBlock;
import com.startraveler.celebratoryspruce.block.ItemHoldingBoxPileBlock;
import com.startraveler.celebratoryspruce.block.LightNetBlock;
import com.startraveler.celebratoryspruce.block.WallWreathBlock;
import com.startraveler.celebratoryspruce.datagen.model.CelebratorySpruceModelTemplates;
import com.startraveler.celebratoryspruce.datagen.model.CelebratorySpruceTextureMapping;
import com.startraveler.celebratoryspruce.datagen.model.CelebratorySpruceTexturedModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.ConditionBuilder;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.PropertyValueList;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CelebratorySpruceModelProvider
extends ModelProvider {
    private BlockModelGenerators blockModels;
    private ItemModelGenerators itemModels;

    public CelebratorySpruceModelProvider(PackOutput output) {
        super(output, "celebratoryspruce");
    }

    public static MultiPartGenerator createDoubleSidedLogBlock(Block block, Identifier model) {
        return MultiPartGenerator.multiPart((Block)block).with(new ConditionBuilder().term((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)})).with(new ConditionBuilder().term((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}).with(VariantMutator.X_ROT.withValue((Object)Quadrant.R90)).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R90))).with(new ConditionBuilder().term((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}).with(VariantMutator.X_ROT.withValue((Object)Quadrant.R90)));
    }

    public static MultiVariantGenerator createMirroredColumnGenerator(Block columnBlock, BiConsumer<Identifier, ModelInstance> modelOutput, TextureMapping[] mappings, String[] suffixes) {
        Stream<Identifier> mirrored = Util.zip(Arrays.stream(mappings), Arrays.stream(suffixes), (mapping, suffix) -> ModelTemplates.CUBE_COLUMN_MIRRORED.createWithSuffix(columnBlock, suffix, mapping, modelOutput));
        Stream<Identifier> normal = Util.zip(Arrays.stream(mappings), Arrays.stream(suffixes), (mapping, suffix) -> ModelTemplates.CUBE_COLUMN.createWithSuffix(columnBlock, suffix, mapping, modelOutput));
        Stream merged = Streams.concat((Stream[])new Stream[]{mirrored, normal});
        return CelebratorySpruceModelProvider.createRotatedVariant(columnBlock, (Identifier[])merged.toArray(Identifier[]::new)).with(BlockModelGenerators.createRotatedPillar());
    }

    public static MultiVariantGenerator createRotatedVariant(Block block, Identifier ... models) {
        return MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.variants((Variant[])((Variant[])Stream.concat(Arrays.stream(models).map(Variant::new), Arrays.stream(models).map(model -> new Variant(model).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R180)))).toArray(Variant[]::new))));
    }

    public static MultiVariantGenerator createTumbledBlock(Block block, Identifier model) {
        int numDirections = Direction.values().length;
        Variant[] variants = new Variant[numDirections * numDirections];
        for (int i = 0; i < numDirections; ++i) {
            for (int j = 0; j < numDirections; ++j) {
                variants[i + numDirections * j] = (Variant)VariantMutator.X_ROT.withValue((Object)Quadrant.values()[i]).then(VariantMutator.Y_ROT.withValue((Object)Quadrant.values()[i])).apply((Object)new Variant(model));
            }
        }
        return MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.variants((Variant[])variants));
    }

    public static MultiPartGenerator createBoxPile(Block block, Function<Integer, Identifier> modelFunction) {
        MultiPartGenerator generator = MultiPartGenerator.multiPart((Block)block);
        Iterator iterator = BoxPileBlock.BOXES.getPossibleValues().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Identifier model = modelFunction.apply(i);
            generator = generator.with(new ConditionBuilder().term(BoxPileBlock.FACING, (Comparable)Direction.EAST).term((Property)BoxPileBlock.BOXES, (Comparable)Integer.valueOf(i)), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R90))).with(new ConditionBuilder().term(BoxPileBlock.FACING, (Comparable)Direction.SOUTH).term((Property)BoxPileBlock.BOXES, (Comparable)Integer.valueOf(i)), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R180))).with(new ConditionBuilder().term(BoxPileBlock.FACING, (Comparable)Direction.WEST).term((Property)BoxPileBlock.BOXES, (Comparable)Integer.valueOf(i)), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R270))).with(new ConditionBuilder().term(BoxPileBlock.FACING, (Comparable)Direction.NORTH).term((Property)BoxPileBlock.BOXES, (Comparable)Integer.valueOf(i)), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}));
        }
        return generator;
    }

    public static MultiPartGenerator createBooleanPropertyBoxPile(Block block, BiFunction<Integer, Boolean, Identifier> modelFunction, BooleanProperty property) {
        MultiPartGenerator generator = MultiPartGenerator.multiPart((Block)block);
        Iterator iterator = BoxPileBlock.BOXES.getPossibleValues().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Iterator iterator2 = property.getPossibleValues().iterator();
            while (iterator2.hasNext()) {
                boolean b = (Boolean)iterator2.next();
                Identifier model = modelFunction.apply(i, b);
                generator = generator.with(new ConditionBuilder().term(BoxPileBlock.FACING, (Comparable)Direction.EAST).term((Property)BoxPileBlock.BOXES, (Comparable)Integer.valueOf(i)).term((Property)ItemHoldingBoxPileBlock.CLOSED, (Comparable)Boolean.valueOf(b)), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R90))).with(new ConditionBuilder().term(BoxPileBlock.FACING, (Comparable)Direction.SOUTH).term((Property)BoxPileBlock.BOXES, (Comparable)Integer.valueOf(i)).term((Property)ItemHoldingBoxPileBlock.CLOSED, (Comparable)Boolean.valueOf(b)), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R180))).with(new ConditionBuilder().term(BoxPileBlock.FACING, (Comparable)Direction.WEST).term((Property)BoxPileBlock.BOXES, (Comparable)Integer.valueOf(i)).term((Property)ItemHoldingBoxPileBlock.CLOSED, (Comparable)Boolean.valueOf(b)), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R270))).with(new ConditionBuilder().term(BoxPileBlock.FACING, (Comparable)Direction.NORTH).term((Property)BoxPileBlock.BOXES, (Comparable)Integer.valueOf(i)).term((Property)ItemHoldingBoxPileBlock.CLOSED, (Comparable)Boolean.valueOf(b)), BlockModelGenerators.variants((Variant[])new Variant[]{new Variant(model)}));
            }
        }
        return generator;
    }

    protected void booleanPropertyBoxPile(Block block) {
        this.blockModels.blockStateOutput.accept(CelebratorySpruceModelProvider.createBooleanPropertyBoxPile(block, (i, b) -> CelebratorySpruceTexturedModel.BOX_PILE.apply((Integer)i, (Boolean)b).get(block).updateTemplate(template -> template.extend().renderType("cutout").build()).createWithSuffix(block, "_stack" + i + (b != false ? "_closed" : ""), this.blockModels.modelOutput), ItemHoldingBoxPileBlock.CLOSED));
    }

    protected MultiVariantGenerator createRotatedTopOverlaidBlock(Block block, Function<String, TexturedModel.Provider> model, String[] overlays) {
        Variant[] variants = new Variant[4 * overlays.length];
        for (int o = 0; o < overlays.length; ++o) {
            String overlay = overlays[o];
            Identifier modelidentifier = model.apply(overlay).createWithSuffix(block, (String)(overlays.length == 1 || overlay.equals("default") || overlay.equals("overlay_default") ? "" : "_" + overlay), this.blockModels.modelOutput);
            for (int j = 0; j < 4; ++j) {
                variants[o * 4 + j] = new Variant(modelidentifier).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.values()[j]));
            }
        }
        return MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.variants((Variant[])variants));
    }

    protected MultiVariantGenerator createOverlaidBlock(Block block, Function<String, TexturedModel.Provider> model, String[] overlays) {
        Variant[] variants = new Variant[overlays.length];
        for (int o = 0; o < overlays.length; ++o) {
            String overlay = overlays[o];
            String trimmedOverlay = overlay.substring(overlay.lastIndexOf(47) + 1);
            Identifier modelidentifier = model.apply(overlay).createWithSuffix(block, (String)(overlays.length == 1 || trimmedOverlay.equals("default") || trimmedOverlay.equals("overlay_default") ? "" : "_" + trimmedOverlay), this.blockModels.modelOutput);
            variants[o] = new Variant(modelidentifier);
        }
        return MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.variants((Variant[])variants));
    }

    protected MultiVariantGenerator createTumbledOverlaidBlock(Block block, Function<String, TexturedModel.Provider> model, String[] overlays) {
        Variant[] variants = new Variant[16 * overlays.length];
        for (int o = 0; o < overlays.length; ++o) {
            String overlay = overlays[o];
            String trimmedOverlay = overlay.substring(overlay.lastIndexOf(47) + 1);
            Identifier modelidentifier = model.apply(overlay).createWithSuffix(block, (String)(overlays.length == 1 || trimmedOverlay.equals("default") || trimmedOverlay.equals("overlay_default") ? "" : "_" + trimmedOverlay), this.blockModels.modelOutput);
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    variants[o * 16 + i * 4 + j] = new Variant(modelidentifier).with(VariantMutator.X_ROT.withValue((Object)Quadrant.values()[i])).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.values()[j]));
                }
            }
        }
        return MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.variants((Variant[])variants));
    }

    protected void boxPile(Block block) {
        this.blockModels.blockStateOutput.accept(CelebratorySpruceModelProvider.createBoxPile(block, i -> CelebratorySpruceTexturedModel.BOX_PILE.apply((Integer)i, false).get(block).updateTemplate(template -> template.extend().renderType("cutout").build()).createWithSuffix(block, "_stack" + i, this.blockModels.modelOutput)));
    }

    public void candleCake(Block candleBlock, Block cakeBlock, Block candleCakeBlock) {
        this.blockModels.registerSimpleFlatItemModel(candleBlock.asItem());
        Identifier candleCakeBase = ModelTemplates.CANDLE_CAKE.create(candleCakeBlock, CelebratorySpruceTextureMapping.candleCake(cakeBlock, candleBlock, false), this.blockModels.modelOutput);
        Identifier candleCakeLit = ModelTemplates.CANDLE_CAKE.createWithSuffix(candleCakeBlock, "_lit", CelebratorySpruceTextureMapping.candleCake(cakeBlock, candleBlock, true), this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)candleCakeBlock).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (MultiVariant)BlockModelGenerators.variant((Variant)new Variant(candleCakeLit)), (MultiVariant)BlockModelGenerators.variant((Variant)new Variant(candleCakeBase)))));
    }

    public void cakeBlock(Block cake, Item cakeItem) {
        this.blockModels.registerSimpleFlatItemModel(cakeItem);
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)cake).with(PropertyDispatch.initial((Property)BlockStateProperties.BITES).generate(n -> BlockModelGenerators.variant((Variant)new Variant(ModelLocationUtils.getModelLocation((Block)cake, (String)("_slice" + n)))))));
    }

    protected void registerModels(@NotNull BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
        this.blockModels = blockModels;
        this.itemModels = itemModels;
        this.basicItem((Item)ModItems.ORNAMENT.get());
        this.basicItem((Item)ModItems.FESTIVE_LIGHT.get());
        this.createOverlaidTintedLowEmissiveLeaves((Block)ModBlocks.DECORATED_SPRUCE_LEAVES.get(), -10380959, DecoratedLeavesBlock.VARIANT);
        this.createOverlaidTintedEmissiveLeaves((Block)ModBlocks.FESTIVE_SPRUCE_LEAVES.get(), -10380959, DecoratedLeavesBlock.VARIANT);
        blockModels.createPlantWithDefaultItem((Block)ModBlocks.CELEBRATORY_SPRUCE_SAPLING.get(), (Block)ModBlocks.POTTED_CELEBRATORY_SPRUCE_SAPLING.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        blockModels.registerSimpleFlatItemModel(ModItems.GOLD_STAR.asItem());
        blockModels.createParticleOnlyBlock((Block)ModBlocks.GOLD_STAR.get());
        blockModels.createParticleOnlyBlock((Block)ModBlocks.WALL_GOLD_STAR.get());
        blockModels.registerSimpleFlatItemModel(ModItems.ITEM_DISPLAY.asItem());
        blockModels.createParticleOnlyBlock((Block)ModBlocks.ITEM_DISPLAY.get());
        blockModels.createParticleOnlyBlock((Block)ModBlocks.WALL_ITEM_DISPLAY.get());
        this.createDecoratedMultifaceBlock((Block)ModBlocks.LIGHT_NET.get(), CelebratorySpruceTexturedModel.MULTIFACE_FACE_EMISSIVE, LightNetBlock.VARIANT);
        this.createWreath((Block)ModBlocks.WREATH.get(), (Block)ModBlocks.WALL_WREATH.get());
        this.createOverlaidWreath((Block)ModBlocks.DECORATED_WREATH.get(), (Block)ModBlocks.DECORATED_WALL_WREATH.get(), DecoratedWreathBlock.VARIANT);
        this.basicItem((Item)ModItems.BLANK_CAROL_DISC.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_SILENT_NIGHT.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_WHAT_CHILD.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_CHRISTMAS_DAY_BELLS.get());
        this.basicItem((Item)ModItems.MUSIC_DISC_CAROL_OF_THE_BELLS.get());
        this.booleanPropertyBoxPile((Block)ModBlocks.PRESENT_PILE.get());
        this.basicItem((Item)ModItems.PRESENT.get());
        this.basicItem((Item)ModItems.STOCKING.get());
    }

    @NotNull
    protected Stream<? extends Holder<Block>> getKnownBlocks() {
        ArrayList excluded = new ArrayList();
        return super.getKnownBlocks().filter(entry -> !excluded.contains(entry.value()));
    }

    @NotNull
    protected Stream<? extends Holder<Item>> getKnownItems() {
        ArrayList excluded = new ArrayList();
        return super.getKnownItems().filter(entry -> !excluded.contains(entry.value()));
    }

    public void createOverlaidWreath(Block wreathBlock, Block wallWreathBlock, IntegerProperty intProperty) {
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)wreathBlock).with(PropertyDispatch.initial((Property)intProperty).generate(property -> {
            Identifier modelidentifier = this.blockModels.createSuffixedVariant(wreathBlock, "_" + intProperty.getName() + property, (ModelTemplate)CelebratorySpruceTexturedModel.OVERLAID_WREATH.get(wreathBlock).getTemplate().extend().renderType(ChunkSectionLayer.CUTOUT.label()).build(), CelebratorySpruceTextureMapping::overlaidWreath);
            return BlockModelGenerators.plainVariant((Identifier)modelidentifier);
        })));
        Int2ObjectOpenHashMap alreadyCreated = new Int2ObjectOpenHashMap();
        Map<Direction, VariantMutator> propertyMap = BlockModelGenerators.ROTATION_TORCH.getEntries().entrySet().stream().map(entry -> Pair.of((Object)((PropertyValueList)entry.getKey()).values().stream().map(Property.Value::value).map(value -> {
            Direction direction;
            return value instanceof Direction ? (direction = (Direction)value) : null;
        }).filter(Objects::nonNull).findFirst().orElse(null), (Object)((VariantMutator)entry.getValue()))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)wallWreathBlock).with(PropertyDispatch.initial((Property)intProperty, WallWreathBlock.FACING).generate((arg_0, arg_1) -> this.lambda$createOverlaidWreath$16((Int2ObjectMap)alreadyCreated, wallWreathBlock, intProperty, wreathBlock, propertyMap, arg_0, arg_1))));
        Identifier identifier = this.blockModels.createFlatItemModelWithBlockTextureAndOverlay(wreathBlock.asItem(), wreathBlock, "_overlay");
        this.blockModels.registerSimpleTintedItemModel(wreathBlock, identifier, ItemModelUtils.constantTint((int)-10380959));
    }

    public void createWreath(Block wreathBlock, Block wallWreathBlock) {
        TextureMapping textureMapping = CelebratorySpruceTextureMapping.wreath(wreathBlock);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)wreathBlock, (MultiVariant)BlockModelGenerators.plainVariant((Identifier)CelebratorySpruceModelTemplates.WREATH.create(wreathBlock, textureMapping, this.blockModels.modelOutput))));
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)wallWreathBlock, (MultiVariant)BlockModelGenerators.plainVariant((Identifier)CelebratorySpruceModelTemplates.WALL_WREATH.create(wallWreathBlock, textureMapping, this.blockModels.modelOutput))).with(BlockModelGenerators.ROTATION_TORCH));
        Identifier identifier = this.blockModels.createFlatItemModelWithBlockTexture(wreathBlock.asItem(), wreathBlock);
        this.blockModels.registerSimpleTintedItemModel(wreathBlock, identifier, ItemModelUtils.constantTint((int)-10380959));
    }

    public void createOverlaidTintedLeaves(Block block, int tint, IntegerProperty intProperty) {
        this.createOverlaidTintedLeaves(block, CelebratorySpruceTexturedModel.OVERLAID_LEAVES, tint, intProperty);
    }

    public void createOverlaidTintedLowEmissiveLeaves(Block block, int tint, IntegerProperty intProperty) {
        this.createOverlaidTintedLeaves(block, CelebratorySpruceTexturedModel.OVERLAID_LEAVES_LOW_EMISSIVE, tint, intProperty);
    }

    public void createOverlaidTintedEmissiveLeaves(Block block, int tint, IntegerProperty intProperty) {
        this.createOverlaidTintedLeaves(block, CelebratorySpruceTexturedModel.OVERLAID_LEAVES_EMISSIVE, tint, intProperty);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createDecoratedMultifaceBlock(Block block, Function<Integer, TexturedModel.Provider> provider, IntegerProperty intProperty) {
        String intPropertyName = intProperty.getName();
        int firstIntValue = (Integer)intProperty.getPossibleValues().getFirst();
        @NotNull Map map = BlockModelGenerators.selectMultifaceProperties((StateHolder)block.defaultBlockState(), MultifaceBlock::getFaceProperty);
        ConditionBuilder conditionBuilder = BlockModelGenerators.condition();
        Map decorationToSidesMap = intProperty.getPossibleValues().stream().collect(Collectors.toMap(Function.identity(), i -> BlockModelGenerators.selectMultifaceProperties((StateHolder)block.defaultBlockState(), MultifaceBlock::getFaceProperty)));
        map.forEach((booleanProperty, variantMutator) -> conditionBuilder.term(booleanProperty, (Comparable)Boolean.valueOf(false)));
        conditionBuilder.term((Property)intProperty, (Comparable)Integer.valueOf(firstIntValue));
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.multiPart((Block)block);
        decorationToSidesMap.forEach((decorationValue, sidesMap) -> {
            Identifier modelIdentifier = this.blockModels.createSuffixedVariant(block, "_" + intPropertyName + decorationValue, (ModelTemplate)((TexturedModel.Provider)provider.apply((Integer)decorationValue)).get(block).getTemplate().extend().renderType(ChunkSectionLayer.CUTOUT.label()).build(), CelebratorySpruceTextureMapping::multifaceFace);
            MultiVariant multiVariant = BlockModelGenerators.plainVariant((Identifier)modelIdentifier);
            sidesMap.forEach((booleanProperty, variantMutator) -> {
                MultiVariant withVariantMutator = multiVariant.with(variantMutator);
                multiPartGenerator.with(BlockModelGenerators.condition().term((Property)booleanProperty, (Comparable)Boolean.valueOf(true)).term((Property)intProperty, (Comparable)decorationValue), withVariantMutator);
            });
        });
        this.blockModels.blockStateOutput.accept(multiPartGenerator);
        this.basicItem(block.asItem());
    }

    public void createOverlaidTintedLeaves(Block block, Function<Integer, TexturedModel.Provider> provider, int tint, IntegerProperty intProperty) {
        int minPropertyValue = intProperty.getPossibleValues().stream().mapToInt(i -> i).min().orElse(0);
        MutableObject itemModelIdentifier = new MutableObject();
        Int2ObjectOpenHashMap intToObjectMap = new Int2ObjectOpenHashMap();
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(PropertyDispatch.initial((Property)intProperty).generate(arg_0 -> this.lambda$createOverlaidTintedLeaves$23((Int2ObjectMap)intToObjectMap, block, intProperty, provider, minPropertyValue, (Mutable)itemModelIdentifier, arg_0))));
        this.blockModels.registerSimpleTintedItemModel(block, (Identifier)itemModelIdentifier.get(), ItemModelUtils.constantTint((int)tint));
    }

    private void basicItem(Item item) {
        this.itemModels.generateFlatItem(item, item, ModelTemplates.FLAT_ITEM);
    }

    private void handheldItem(Item item) {
        this.itemModels.generateFlatItem(item, item, ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    public void tippedArrow(Item arrowItem) {
        Identifier Identifier2 = this.itemModels.generateLayeredItem(arrowItem, ModelLocationUtils.getModelLocation((Item)arrowItem, (String)"_head"), ModelLocationUtils.getModelLocation((Item)arrowItem, (String)"_base"));
        this.itemModels.addPotionTint(arrowItem, Identifier2);
    }

    protected void simpleBlockWithItem(Block block) {
        this.blockModels.createTrivialBlock(block, TexturedModel.CUBE);
    }

    protected void simpleBlockWithItem(Block block, String renderType) {
        this.blockModels.createTrivialBlock(block, TexturedModel.CUBE.updateTemplate(template -> template.extend().renderType(renderType).build()));
    }

    protected void nonrotatablePillarBlock(Block block) {
        TexturedModel model = TexturedModel.COLUMN.get(block).updateTextures(p_387400_ -> p_387400_.put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block)));
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)BlockModelGenerators.variant((Variant)new Variant(model.create(block, this.blockModels.modelOutput)))));
    }

    protected void tumbledBlockWithItem(Block block) {
        this.tumbledBlockWithItem(block, null);
    }

    protected void mirroredColumnBlock(Block block) {
        TextureMapping mapping = TextureMapping.column((Block)block);
        TextureMapping altMapping = CelebratorySpruceTextureMapping.columnAlt(block);
        TextureMapping[] mappings = new TextureMapping[]{mapping, altMapping};
        String[] suffixes = new String[]{"", "_alt"};
        this.blockModels.blockStateOutput.accept(CelebratorySpruceModelProvider.createMirroredColumnGenerator(block, this.blockModels.modelOutput, mappings, suffixes));
    }

    protected void tumbledBlockWithItem(Block block, @Nullable String renderType) {
        TexturedModel.Provider model = TexturedModel.CUBE;
        if (renderType != null) {
            model = model.updateTemplate(template -> template.extend().renderType(renderType).build());
        }
        this.blockModels.blockStateOutput.accept(CelebratorySpruceModelProvider.createTumbledBlock(block, model.create(block, this.blockModels.modelOutput)));
    }

    protected void tumbledOverlaidBlockWithItem(Block block, Block base, String ... overlays) {
        BiFunction<String, Block, TexturedModel.Provider> baseModel = CelebratorySpruceTexturedModel.OVERLAID_CUBE;
        Function<String, TexturedModel.Provider> model = lambdaOverlay -> ((TexturedModel.Provider)baseModel.apply((String)lambdaOverlay, base)).updateTemplate(template -> template.extend().renderType("cutout").build());
        this.blockModels.blockStateOutput.accept(this.createTumbledOverlaidBlock(block, model, overlays));
    }

    protected void overlaidBlockWithItem(Block block, Block base, String ... overlays) {
        BiFunction<String, Block, TexturedModel.Provider> baseModel = CelebratorySpruceTexturedModel.OVERLAID_CUBE;
        Function<String, TexturedModel.Provider> model = lambdaOverlay -> ((TexturedModel.Provider)baseModel.apply((String)lambdaOverlay, base)).updateTemplate(template -> template.extend().renderType("cutout").build());
        this.blockModels.blockStateOutput.accept(this.createOverlaidBlock(block, model, overlays));
    }

    protected void doubleSidedLogBlockWithItem(Block block) {
        this.blockModels.blockStateOutput.accept(CelebratorySpruceModelProvider.createDoubleSidedLogBlock(block, CelebratorySpruceTexturedModel.DOUBLE_SIDED_LOG.create(block, this.blockModels.modelOutput)));
    }

    protected void rotatedTopOverlaidBlockWithItem(Block block, Block base, String topOverlay, @NotNull String[] overlays) {
        TriFunction<String, String, Block, TexturedModel.Provider> baseModel = CelebratorySpruceTexturedModel.TOP_OVERLAID_CUBE;
        Function<String, TexturedModel.Provider> model = lambdaOverlay -> ((TexturedModel.Provider)baseModel.apply(lambdaOverlay, (Object)topOverlay, (Object)base)).updateTemplate(template -> template.extend().renderType("cutout").build());
        this.blockModels.blockStateOutput.accept(this.createRotatedTopOverlaidBlock(block, model, overlays));
    }

    public void createPlantWithDefaultItem(Block block, Block pottedBlock, BlockModelGenerators.PlantType plantType, String renderType) {
        this.blockModels.registerSimpleItemModel(block.asItem(), plantType.createItemModel(this.blockModels, block));
        this.createPlant(block, pottedBlock, plantType, renderType);
    }

    public void createPlantWithDefaultItemWithCustomPottedTexture(Block block, Block pottedBlock, Identifier customTexture, BlockModelGenerators.PlantType plantType, String renderType) {
        this.blockModels.registerSimpleItemModel(block.asItem(), plantType.createItemModel(this.blockModels, block));
        this.createPlantWithCustomPottedTexture(block, pottedBlock, customTexture, plantType, renderType);
    }

    public void createPlant(Block block, Block pottedBlock, BlockModelGenerators.PlantType plantType, String renderType) {
        this.createCrossBlock(block, plantType, renderType);
        TextureMapping texturemapping = plantType.getPlantTextureMapping(block);
        Identifier Identifier2 = plantType.getCrossPot().extend().renderType(renderType).build().create(pottedBlock, texturemapping, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)pottedBlock, (MultiVariant)BlockModelGenerators.plainVariant((Identifier)Identifier2)));
    }

    public void createPlantWithCustomPottedTexture(Block block, Block pottedBlock, Identifier customPottedTexture, BlockModelGenerators.PlantType plantType, String renderType) {
        this.createCrossBlock(block, plantType, renderType);
        TextureMapping texturemapping = TextureMapping.singleSlot((TextureSlot)TextureSlot.PLANT, (Identifier)customPottedTexture);
        Identifier Identifier2 = plantType.getCrossPot().extend().renderType(renderType).build().create(pottedBlock, texturemapping, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)pottedBlock, (MultiVariant)BlockModelGenerators.plainVariant((Identifier)Identifier2)));
    }

    public void createPottedOnly(Block block, Block pottedBlock, BlockModelGenerators.PlantType plantType, String renderType) {
        TextureMapping texturemapping = plantType.getPlantTextureMapping(block);
        Identifier Identifier2 = plantType.getCrossPot().extend().renderType(renderType).build().create(pottedBlock, texturemapping, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)pottedBlock, (MultiVariant)BlockModelGenerators.plainVariant((Identifier)Identifier2)));
    }

    public void createCrossBlock(Block block, BlockModelGenerators.PlantType plantType, String renderType) {
        TextureMapping texturemapping = plantType.getTextureMapping(block);
        this.createCrossBlock(block, plantType, texturemapping, renderType);
    }

    public void createCrossBlock(Block block, BlockModelGenerators.PlantType plantType, TextureMapping textureMapping, String renderType) {
        Identifier Identifier2 = plantType.getCross().extend().renderType(renderType).build().create(block, textureMapping, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((Identifier)Identifier2)));
    }

    public void createCrossBlockWithoutItem(Block block, BlockModelGenerators.PlantType plantType, String renderType, Property<@NotNull Integer> ageProperty, int ... possibleValues) {
        if (ageProperty.getPossibleValues().size() != possibleValues.length) {
            throw new IllegalArgumentException("missing values for property: " + String.valueOf(ageProperty));
        }
        PropertyDispatch propertydispatch = PropertyDispatch.initial(ageProperty).generate(p_388685_ -> {
            String s = "_stage" + possibleValues[p_388685_];
            TextureMapping texturemapping = TextureMapping.cross((Identifier)TextureMapping.getBlockTexture((Block)block, (String)s));
            Identifier Identifier2 = plantType.getCross().extend().renderType(renderType).build().createWithSuffix(block, s, texturemapping, this.blockModels.modelOutput);
            return BlockModelGenerators.plainVariant((Identifier)Identifier2);
        });
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(propertydispatch));
    }

    public void createCropBlock(Block cropBlock, String renderType, Property<@NotNull Integer> ageProperty, int ... ageToVisualStageMapping) {
        this.blockModels.registerSimpleFlatItemModel(cropBlock.asItem());
        this.createCropBlockWithoutItem(cropBlock, renderType, ageProperty, ageToVisualStageMapping);
    }

    public void createCropBlockWithoutItem(Block cropBlock, String renderType, Property<@NotNull Integer> ageProperty, int ... ageToVisualStageMapping) {
        if (ageProperty.getPossibleValues().size() != ageToVisualStageMapping.length) {
            throw new IllegalArgumentException();
        }
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)cropBlock).with(PropertyDispatch.initial(ageProperty).generate(arg_0 -> this.lambda$createCropBlockWithoutItem$35(ageToVisualStageMapping, (Int2ObjectMap)int2objectmap, cropBlock, renderType, arg_0))));
    }

    public void createCrossBlock(Block block, BlockModelGenerators.PlantType plantType, String renderType, Property<@NotNull Integer> ageProperty, int ... possibleValues) {
        this.createCrossBlockWithoutItem(block, plantType, renderType, ageProperty, possibleValues);
        this.blockModels.registerSimpleFlatItemModel(block.asItem());
    }

    public void createAsteriskBlockWithoutItem(Block block, BlockModelGenerators.PlantType plantType, String renderType, Property<@NotNull Integer> ageProperty, int ... possibleValues) {
        if (ageProperty.getPossibleValues().size() != possibleValues.length) {
            throw new IllegalArgumentException("missing values for property: " + String.valueOf(ageProperty));
        }
        PropertyDispatch propertydispatch = PropertyDispatch.initial(ageProperty).generate(index -> {
            String s = "_stage" + possibleValues[index];
            TextureMapping texture = CelebratorySpruceTextureMapping.asterisk(TextureMapping.getBlockTexture((Block)block), TextureMapping.getBlockTexture((Block)block, (String)s));
            Identifier Identifier2 = CelebratorySpruceModelTemplates.ASTERISK.extend().renderType(renderType).build().createWithSuffix(block, s, texture, this.blockModels.modelOutput);
            return BlockModelGenerators.plainVariant((Identifier)Identifier2);
        });
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(propertydispatch));
    }

    public void generateSimpleSpecialItemModel(Block block, SpecialModelRenderer.Unbaked specialModel) {
        Item item = block.asItem();
        Identifier Identifier2 = ModelLocationUtils.getModelLocation((Item)item);
        this.itemModels.itemModelOutput.accept(item, ItemModelUtils.specialModel((Identifier)Identifier2, (SpecialModelRenderer.Unbaked)specialModel));
    }

    private /* synthetic */ MultiVariant lambda$createCropBlockWithoutItem$35(int[] ageToVisualStageMapping, Int2ObjectMap int2objectmap, Block cropBlock, String renderType, Integer p_408977_) {
        int i = ageToVisualStageMapping[p_408977_];
        return BlockModelGenerators.plainVariant((Identifier)((Identifier)int2objectmap.computeIfAbsent(i, stage -> this.blockModels.createSuffixedVariant(cropBlock, "_stage" + stage, (ModelTemplate)ModelTemplates.CROP.extend().renderType(renderType).build(), TextureMapping::crop))));
    }

    private /* synthetic */ MultiVariant lambda$createOverlaidTintedLeaves$23(Int2ObjectMap intToObjectMap, Block block, IntegerProperty intProperty, Function provider, int minPropertyValue, Mutable itemModelIdentifier, Integer property) {
        return BlockModelGenerators.plainVariant((Identifier)((Identifier)intToObjectMap.computeIfAbsent((Object)property, stage -> {
            Identifier modelidentifier = this.blockModels.createSuffixedVariant(block, "_" + intProperty.getName() + stage, (ModelTemplate)((TexturedModel.Provider)provider.apply(stage)).get(block).getTemplate().extend().renderType(ChunkSectionLayer.CUTOUT.label()).build(), CelebratorySpruceTextureMapping::overlaidLeaves);
            if (stage == minPropertyValue) {
                itemModelIdentifier.setValue((Object)modelidentifier);
            }
            return modelidentifier;
        })));
    }

    private /* synthetic */ MultiVariant lambda$createOverlaidWreath$16(Int2ObjectMap alreadyCreated, Block wallWreathBlock, IntegerProperty intProperty, Block wreathBlock, Map propertyMap, Integer property, Direction rotation) {
        Identifier modelIdentifier = (Identifier)alreadyCreated.computeIfAbsent((Object)property, i -> this.blockModels.createSuffixedVariant(wallWreathBlock, "_" + intProperty.getName() + i, (ModelTemplate)CelebratorySpruceTexturedModel.OVERLAID_WREATH_WALL.get(wreathBlock).getTemplate().extend().renderType(ChunkSectionLayer.CUTOUT.label()).build(), CelebratorySpruceTextureMapping::overlaidWreath));
        return BlockModelGenerators.plainVariant((Identifier)modelIdentifier).with((VariantMutator)propertyMap.get(rotation));
    }
}

