/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.datagen;

import com.startraveler.celebratoryspruce.ModBlocks;
import com.startraveler.celebratoryspruce.ModItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class CelebratorySpruceRecipeProvider
extends RecipeProvider {
    protected final String modid;

    public CelebratorySpruceRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
        this.modid = "celebratoryspruce";
    }

    protected void buildRecipes() {
        this.shapeless(List.of(Blocks.SPRUCE_LEAVES, ModItems.ORNAMENT.get()), List.of(Integer.valueOf(1), Integer.valueOf(1)), RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.DECORATED_SPRUCE_LEAVES.get(), 1, "celebratory_spruce_leaves");
        this.shapeless(List.of(Blocks.SPRUCE_LEAVES, ModItems.FESTIVE_LIGHT.get()), List.of(Integer.valueOf(1), Integer.valueOf(1)), RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.FESTIVE_SPRUCE_LEAVES.get(), 1, "celebratory_spruce_leaves");
        this.shaped(List.of("oio", "isi", "oio"), List.of(Character.valueOf('i'), Character.valueOf('s'), Character.valueOf('o')), List.of(Items.GOLD_INGOT, Blocks.GLOWSTONE, ModItems.FESTIVE_LIGHT.get()), RecipeCategory.DECORATIONS, (ItemLike)ModItems.GOLD_STAR.get(), 1);
        this.shaped(List.of("oio", "isi", "oio"), List.of(Character.valueOf('i'), Character.valueOf('s'), Character.valueOf('o')), List.of(Items.COPPER_INGOT, Blocks.GLASS, ModItems.FESTIVE_LIGHT.get()), RecipeCategory.DECORATIONS, (ItemLike)ModItems.ITEM_DISPLAY.get(), 4);
        this.shaped(List.of("oso", "oio", "oso"), List.of(Character.valueOf('i'), Character.valueOf('s'), Character.valueOf('o')), List.of(Items.COPPER_INGOT, Items.STRING, ModItems.FESTIVE_LIGHT.get()), RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.LIGHT_NET.get(), 6);
        this.shaped(List.of(" l ", "l l", " l "), List.of(Character.valueOf('l')), List.of(Items.SPRUCE_LEAVES), RecipeCategory.DECORATIONS, (ItemLike)ModItems.WREATH.get(), 8);
        this.shapeless(List.of(ModItems.FESTIVE_LIGHT, ModItems.ORNAMENT, ModItems.WREATH), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), RecipeCategory.DECORATIONS, (ItemLike)ModItems.DECORATED_WREATH.get(), 1);
        this.shapeless(List.of(ItemTags.CREEPER_DROP_MUSIC_DISCS, ModItems.ORNAMENT, Items.PAPER, Items.SLIME_BALL), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), RecipeCategory.MISC, (ItemLike)ModItems.BLANK_CAROL_DISC.get(), 1);
        this.shaped(List.of(" r ", "ror", " r "), List.of(Character.valueOf('r'), Character.valueOf('o')), List.of(Items.RESIN_CLUMP, ModItems.ORNAMENT.get()), RecipeCategory.MISC, (ItemLike)ModItems.BLANK_CAROL_DISC.get(), 2);
        this.shapeless(List.of(ModItems.BLANK_CAROL_DISC.get(), ItemTags.WOOL, Tags.Items.DYES_BLUE), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), RecipeCategory.MISC, (ItemLike)ModItems.MUSIC_DISC_SILENT_NIGHT.get(), 1);
        this.shapeless(List.of(ModItems.BLANK_CAROL_DISC.get(), ItemTags.PLANKS, Tags.Items.DYES_GREEN), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), RecipeCategory.MISC, (ItemLike)ModItems.MUSIC_DISC_WHAT_CHILD.get(), 1);
        this.shapeless(List.of(ModItems.BLANK_CAROL_DISC.get(), Items.COPPER_INGOT, Tags.Items.DYES_RED), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), RecipeCategory.MISC, (ItemLike)ModItems.MUSIC_DISC_CHRISTMAS_DAY_BELLS.get(), 1);
        this.shapeless(List.of(ModItems.BLANK_CAROL_DISC.get(), Items.IRON_INGOT, Tags.Items.DYES_PURPLE), List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), RecipeCategory.MISC, (ItemLike)ModItems.MUSIC_DISC_CAROL_OF_THE_BELLS.get(), 1);
        this.shaped(List.of(" i ", "ioi", " i "), List.of(Character.valueOf('i'), Character.valueOf('o')), List.of(Items.PAPER, ModItems.ORNAMENT.get()), RecipeCategory.DECORATIONS, (ItemLike)ModItems.PRESENT.get(), 2);
        this.shaped(List.of("ioi", "i i"), List.of(Character.valueOf('i'), Character.valueOf('o')), List.of(ItemTags.WOOL, ModItems.ORNAMENT.get()), RecipeCategory.MISC, (ItemLike)ModItems.STOCKING.get(), 2);
    }

    protected void shaped(List<String> pattern, List<Character> tokens, List<Object> ingredients, RecipeCategory recipeCategory, ItemLike result, int count) {
        this.shaped(pattern, tokens, ingredients, recipeCategory, result, count, null);
    }

    protected void shaped(List<String> pattern, List<Character> tokens, List<Object> ingredients, RecipeCategory recipeCategory, ItemLike result, int count, String group) {
        ShapedRecipeBuilder recipe = this.shaped(recipeCategory, result, count);
        StringBuilder recipeName = new StringBuilder(this.modid + ":" + CelebratorySpruceRecipeProvider.getItemName((ItemLike)result) + "_from");
        for (String row : pattern) {
            recipe = recipe.pattern(row);
        }
        if (tokens.size() != ingredients.size()) {
            throw new IllegalArgumentException("Token count does not match ingredient count.");
        }
        for (int i = 0; i < tokens.size(); ++i) {
            if (ingredients.get(i) instanceof ItemLike) {
                recipeName.append("_").append(CelebratorySpruceRecipeProvider.getItemName((ItemLike)((ItemLike)ingredients.get(i))));
                recipe = recipe.define(tokens.get(i), (ItemLike)ingredients.get(i));
                continue;
            }
            Object object = ingredients.get(i);
            if (object instanceof TagKey) {
                TagKey tag = (TagKey)object;
                Ingredient ingredient = Ingredient.of((HolderSet)this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(tag));
                recipeName.append("_tag_").append(tag.location().toDebugFileName());
                recipe = recipe.define(tokens.get(i), ingredient);
                continue;
            }
            throw new IllegalArgumentException("Unrecognized item or tag type: " + String.valueOf(ingredients.get(i)));
        }
        for (Object ingredient : ingredients) {
            Object name;
            if (ingredient instanceof ItemLike) {
                name = CelebratorySpruceRecipeProvider.getHasName((ItemLike)((ItemLike)ingredient));
                recipe = recipe.unlockedBy((String)name, this.has((ItemLike)ingredient));
                continue;
            }
            if (ingredient instanceof TagKey) {
                name = "has_" + ((TagKey)ingredient).registry().registry().toDebugFileName();
                recipe = recipe.unlockedBy((String)name, this.has((TagKey)ingredient));
                continue;
            }
            throw new IllegalArgumentException("Unrecognized item or tag type: " + String.valueOf(ingredient));
        }
        recipe = recipe.unlockedBy(CelebratorySpruceRecipeProvider.getHasName((ItemLike)result), this.has(result));
        recipe.group(group == null ? this.group(result) : group);
        recipe.save(this.output, recipeName.toString());
    }

    protected void stonecutting(Object ingredient, RecipeCategory recipeCategory, ItemLike result, int count) {
        Ingredient toAdd;
        String recipeName = this.modid + ":" + CelebratorySpruceRecipeProvider.getItemName((ItemLike)result) + "_from_stonecutting_";
        if (ingredient instanceof ItemLike) {
            ItemLike item = (ItemLike)ingredient;
            toAdd = Ingredient.of((ItemLike)item);
            recipeName = recipeName + CelebratorySpruceRecipeProvider.getItemName((ItemLike)item);
        } else if (ingredient instanceof TagKey) {
            TagKey tag = (TagKey)ingredient;
            toAdd = Ingredient.of((HolderSet)this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(tag));
            recipeName = recipeName + tag.location().toDebugFileName();
        } else {
            throw new IllegalArgumentException("Cannot create a stonecutting recipe with a non-Item, non-Tag object.");
        }
        SingleItemRecipeBuilder recipe = SingleItemRecipeBuilder.stonecutting((Ingredient)toAdd, (RecipeCategory)recipeCategory, (ItemLike)result, (int)count);
        if (ingredient instanceof ItemLike) {
            recipe = recipe.unlockedBy(CelebratorySpruceRecipeProvider.getHasName((ItemLike)((ItemLike)ingredient)), this.has((ItemLike)ingredient));
        } else if (ingredient instanceof TagKey) {
            String name = "has" + ((TagKey)ingredient).registry().registry().toDebugFileName();
            recipe = recipe.unlockedBy(name, this.has((TagKey)ingredient));
        } else {
            throw new IllegalArgumentException("Unrecognized item or tag type: " + String.valueOf(ingredient));
        }
        recipe = recipe.unlockedBy(CelebratorySpruceRecipeProvider.getHasName((ItemLike)result), this.has(result));
        recipe.group(this.group(result));
        recipe.save(this.output, recipeName);
    }

    protected void shapeless(List<Object> ingredients, List<Integer> counts, RecipeCategory recipeCategory, ItemLike result, int count) {
        this.shapeless(ingredients, counts, recipeCategory, result, count, null);
    }

    protected void shapeless(List<Object> ingredients, List<Integer> counts, RecipeCategory recipeCategory, ItemLike result, int count, String group) {
        ShapelessRecipeBuilder recipe = this.shapeless(recipeCategory, result, count);
        StringBuilder recipeName = new StringBuilder(this.group(result) + "_from");
        if (counts.size() != ingredients.size()) {
            throw new IllegalArgumentException("Token count does not match ingredient count.");
        }
        for (int i = 0; i < counts.size(); ++i) {
            if (ingredients.get(i) instanceof ItemLike) {
                recipeName.append("_").append(CelebratorySpruceRecipeProvider.getItemName((ItemLike)((ItemLike)ingredients.get(i))));
                recipe = recipe.requires((ItemLike)ingredients.get(i), counts.get(i).intValue());
                continue;
            }
            Object object = ingredients.get(i);
            if (object instanceof TagKey) {
                TagKey tag = (TagKey)object;
                recipeName.append("_tag_").append(tag.location().toDebugFileName());
                Ingredient ingredient = Ingredient.of((HolderSet)this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(tag));
                recipe = recipe.requires(ingredient, counts.get(i).intValue());
                continue;
            }
            throw new IllegalArgumentException("Unrecognized item or tag type: " + String.valueOf(ingredients.get(i)));
        }
        for (Object ingredient : ingredients) {
            if (ingredient instanceof ItemLike) {
                recipe = recipe.unlockedBy(CelebratorySpruceRecipeProvider.getHasName((ItemLike)((ItemLike)ingredient)), this.has((ItemLike)ingredient));
                continue;
            }
            if (ingredient instanceof TagKey) {
                String name = "has" + ((TagKey)ingredient).registry().registry().toDebugFileName();
                recipe = recipe.unlockedBy(name, this.has((TagKey)ingredient));
                continue;
            }
            throw new IllegalArgumentException("Unrecognized item or tag type: " + String.valueOf(ingredient));
        }
        recipe = recipe.unlockedBy(CelebratorySpruceRecipeProvider.getHasName((ItemLike)result), this.has(result));
        recipe.group(group == null ? this.group(result) : group);
        recipe.save(this.output, recipeName.toString());
    }

    protected void foodCooking(List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime) {
        String group = this.namespace(result) + ":" + CelebratorySpruceRecipeProvider.getItemName((ItemLike)result);
        this.campfire(ingredients, category, result, experience, 2 * cookingTime, group);
        this.smelting(ingredients, category, result, experience, cookingTime, group);
        this.smoking(ingredients, category, result, experience, cookingTime / 2, group);
    }

    protected String hasName(ItemLike item) {
        return "has_" + this.name(item);
    }

    protected void shapeless(RecipeCategory recipeCategory, ItemLike input, int inCount, ItemLike output, int count) {
        this.shapeless(recipeCategory, input, inCount, output, count, null);
    }

    protected void shapeless(RecipeCategory recipeCategory, ItemLike input, int inCount, ItemLike output, int count, String group) {
        this.shapeless(List.of(input), List.of(Integer.valueOf(inCount)), recipeCategory, output, count, group);
    }

    protected String group(ItemLike item) {
        return this.identifier(item).toString();
    }

    protected String name(ItemLike item) {
        return this.identifier(item).getPath();
    }

    protected String namespace(ItemLike item) {
        return this.identifier(item).getNamespace();
    }

    protected Identifier identifier(ItemLike item) {
        return item.asItem().builtInRegistryHolder().key().identifier();
    }

    protected void campfire(List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        this.cooking(RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, ingredients, category, result, experience, cookingTime * 3, group, "_from_campfire");
    }

    protected void smoking(List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        this.cooking(RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, ingredients, category, result, experience, cookingTime / 2, group, "_from_smoking");
    }

    protected void smelting(List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        this.cooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_smelting");
    }

    protected void blasting(List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        this.cooking(RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, ingredients, category, result, experience, cookingTime / 2, group, "_from_blasting");
    }

    protected <T extends AbstractCookingRecipe> void cooking(RecipeSerializer<T> cookingSerializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group, String recipeName) {
        for (ItemLike itemlike : ingredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike)itemlike), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, cookingSerializer, factory).group(group).unlockedBy(CelebratorySpruceRecipeProvider.getHasName((ItemLike)itemlike), this.has(itemlike)).save(this.output, this.modid + ":" + CelebratorySpruceRecipeProvider.getItemName((ItemLike)result) + recipeName + "_" + CelebratorySpruceRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        @NotNull
        protected RecipeProvider createRecipeProvider(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull RecipeOutput output) {
            return new CelebratorySpruceRecipeProvider(provider, output);
        }

        @NotNull
        public String getName() {
            return "Verdant Recipe Provider";
        }
    }
}

