/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.celebratoryspruce.item;

import com.startraveler.celebratoryspruce.ModDataComponentTypes;
import com.startraveler.celebratoryspruce.item.component.GoodieBagContents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GoodieBagItem
extends Item {
    public GoodieBagItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Object object;
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide() && (object = stack.get((DataComponentType)ModDataComponentTypes.GOODIE_BAG_CONTENTS.get())) instanceof GoodieBagContents) {
            Iterator<ItemStack> customNameString;
            Component customName;
            boolean hasNameAndNameDoesNotMatchPlayer;
            GoodieBagContents goodieBagContents = (GoodieBagContents)object;
            Iterator<ItemStack> iterator = stack.get(DataComponents.CUSTOM_NAME);
            boolean bl = hasNameAndNameDoesNotMatchPlayer = iterator instanceof Component && (iterator = (customName = (Component)iterator).tryCollapseToString()) instanceof String && !((String)((Object)(customNameString = iterator))).equals(player.getPlainTextName());
            if (!hasNameAndNameDoesNotMatchPlayer) {
                boolean anySucceeded = false;
                ArrayList<ItemStack> remainders = new ArrayList<ItemStack>();
                for (ItemStack gift : goodieBagContents.copyStacks()) {
                    boolean itemSuccessfullyAdded = player.addItem(gift);
                    anySucceeded |= itemSuccessfullyAdded;
                    if (itemSuccessfullyAdded) continue;
                    remainders.add(gift);
                }
                if (anySucceeded) {
                    GoodieBagContents newGoodieBagContents = remainders.isEmpty() ? null : new GoodieBagContents(remainders, goodieBagContents.maxSize());
                    stack.set((DataComponentType)ModDataComponentTypes.GOODIE_BAG_CONTENTS.get(), (Object)newGoodieBagContents);
                    level.playSound(null, player.blockPosition(), SoundEvents.BUNDLE_DROP_CONTENTS, SoundSource.PLAYERS, 0.8f, 0.8f + level.getRandom().nextFloat() * 0.4f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.use(level, player, hand);
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        ItemStack inSlot = slot.getItem();
        if (stack.getCount() != 1 || inSlot.isEmpty()) {
            return false;
        }
        int size = (Integer)stack.getOrDefault(ModDataComponentTypes.DEFAULT_GOODIE_BAG_SIZE, (Object)1);
        GoodieBagContents contents = (GoodieBagContents)stack.getOrDefault((DataComponentType)ModDataComponentTypes.GOODIE_BAG_CONTENTS.get(), (Object)new GoodieBagContents(size));
        GoodieBagContents newContents = contents.withAdditionalOrNull(inSlot.copy());
        Level level = player.level();
        if (newContents != null) {
            stack.set((DataComponentType)ModDataComponentTypes.GOODIE_BAG_CONTENTS.get(), (Object)newContents);
            inSlot.setCount(0);
            level.playSound(null, player.blockPosition(), SoundEvents.BUNDLE_INSERT, SoundSource.PLAYERS, 0.8f, 0.8f + level.getRandom().nextFloat() * 0.4f);
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        level.playSound(null, player.blockPosition(), SoundEvents.BUNDLE_INSERT_FAIL, SoundSource.PLAYERS, 0.8f, 0.8f + level.getRandom().nextFloat() * 0.4f);
        return super.overrideStackedOnOther(stack, slot, clickAction, player);
    }

    @Deprecated
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay tooltipDisplay, @NotNull Consumer<Component> tooltipAdder, @NotNull TooltipFlag flag) {
        Object object = stack.getCustomName();
        if (object instanceof Component) {
            Component customName = object;
            tooltipAdder.accept((Component)Component.translatable((String)"item.celebratoryspruce.goodie_bag.for").append(customName));
        }
        if ((object = stack.get((DataComponentType)ModDataComponentTypes.GOODIE_BAG_CONTENTS.get())) instanceof GoodieBagContents) {
            GoodieBagContents contents = (GoodieBagContents)object;
            int n = contents.stacks().size();
            if (n == 1) {
                tooltipAdder.accept((Component)Component.translatable((String)"item.celebratoryspruce.goodie_bag.contains_one"));
            } else {
                tooltipAdder.accept((Component)Component.translatable((String)"item.celebratoryspruce.goodie_bag.contains_n", (Object[])new Object[]{n}));
            }
        } else {
            tooltipAdder.accept((Component)Component.translatable((String)"item.celebratoryspruce.goodie_bag.empty"));
        }
    }

    private void broadcastChangesOnContainerMenu(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof AbstractContainerMenu) {
            AbstractContainerMenu abstractContainerMenu2 = abstractContainerMenu;
            abstractContainerMenu2.slotsChanged((Container)player.getInventory());
        }
    }
}

