/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WhiteCherryParticle
extends SingleQuadParticle {
    private static final float ACCELERATION_SCALE = 0.0025f;
    private static final int INITIAL_LIFETIME = 300;
    private static final int CURVE_ENDPOINT_TIME = 300;
    private float rotSpeed;
    private final float spinAcceleration;
    private final float windBig;
    private final boolean swirl;
    private final boolean flowAway;
    private final double xaFlowScale;
    private final double zaFlowScale;
    private final double swirlPeriod;

    protected WhiteCherryParticle(ClientLevel p_377646_, double p_377442_, double p_376050_, double p_377918_, TextureAtlasSprite p_426530_, float p_378651_, float p_376838_, boolean p_378490_, boolean p_376930_, float p_376718_, float p_378174_) {
        super(p_377646_, p_377442_, p_376050_, p_377918_, p_426530_);
        float $$11;
        this.rotSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -30.0 : 30.0);
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        this.windBig = p_376838_;
        this.swirl = p_378490_;
        this.flowAway = p_376930_;
        this.lifetime = 300;
        this.gravity = p_378651_ * 1.2f * 0.0025f;
        this.quadSize = $$11 = p_376718_ * (this.random.nextBoolean() ? 0.05f : 0.075f);
        this.setSize($$11, $$11);
        this.friction = 1.0f;
        this.yd = -p_378174_;
        float $$12 = this.random.nextFloat();
        this.xaFlowScale = Math.cos(Math.toRadians($$12 * 60.0f)) * (double)this.windBig;
        this.zaFlowScale = Math.sin(Math.toRadians($$12 * 60.0f)) * (double)this.windBig;
        this.swirlPeriod = Math.toRadians(1000.0f + $$12 * 3000.0f);
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (!this.removed) {
            float $$0 = 300 - this.lifetime;
            float $$1 = Math.min($$0 / 300.0f, 1.0f);
            double $$2 = 0.0;
            double $$3 = 0.0;
            if (this.flowAway) {
                $$2 += this.xaFlowScale * Math.pow($$1, 1.25);
                $$3 += this.zaFlowScale * Math.pow($$1, 1.25);
            }
            if (this.swirl) {
                $$2 += (double)$$1 * Math.cos((double)$$1 * this.swirlPeriod) * (double)this.windBig;
                $$3 += (double)$$1 * Math.sin((double)$$1 * this.swirlPeriod) * (double)this.windBig;
            }
            this.xd += $$2 * (double)0.0025f;
            this.zd += $$3 * (double)0.0025f;
            this.yd -= (double)this.gravity;
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.rotSpeed / 20.0f;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround || this.lifetime < 299 && (this.xd == 0.0 || this.zd == 0.0)) {
                this.remove();
            }
            if (!this.removed) {
                this.xd *= (double)this.friction;
                this.yd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
        }
    }

    public static class CherryProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public CherryProvider(SpriteSet p_376778_) {
            this.sprites = p_376778_;
        }

        public Particle createParticle(SimpleParticleType p_429629_, ClientLevel p_375913_, double p_375714_, double p_376515_, double p_376801_, double p_378662_, double p_376463_, double p_377178_, RandomSource p_428467_) {
            return new WhiteCherryParticle(p_375913_, p_375714_, p_376515_, p_376801_, this.sprites.get(p_428467_), 0.25f, 2.0f, false, true, 1.0f, 0.0f);
        }
    }
}

