/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.world.spawners;

import com.belgieyt.trailsandtalesplus.Objects.world.spawners.WanderingCamelTrader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trailsandtalesplus")
public class WorldSpawnersRegistry {
    private static Map<Identifier, WanderingCamelTrader> worldSpawners = new HashMap<Identifier, WanderingCamelTrader>();

    @SubscribeEvent
    public static void onWorldLoad(ServerStartingEvent event) {
        ServerLevelData server = event.getServer().getWorldData().overworldData();
        worldSpawners.put(BuiltinDimensionTypes.OVERWORLD.identifier(), new WanderingCamelTrader(server));
    }

    @SubscribeEvent
    public static void onServerStart(ServerStoppedEvent event) {
        worldSpawners.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent.Post event) {
        if (event.side() != LogicalSide.SERVER) {
            return;
        }
        WanderingCamelTrader spawner = worldSpawners.get(event.level().dimension().identifier());
        if (spawner != null) {
            spawner.tick(event.level().getServer().overworld(), true);
        }
    }
}

