/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.blocks;

import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.entity.SkeletonSnifferEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SusSnifferEggBlock
extends Block {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final EnumProperty<DyeColor> COLOUR_BASE = EnumProperty.create((String)"colour_base", DyeColor.class);
    public static final EnumProperty<DyeColor> COLOUR_SPOTS = EnumProperty.create((String)"colour_spots", DyeColor.class);
    private static final int REGULAR_HATCH_TIME_TICKS = 24000;
    private static final int BOOSTED_HATCH_TIME_TICKS = 12000;
    private static final int RANDOM_HATCH_OFFSET_TICKS = 300;
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0);

    public SusSnifferEggBlock(BlockBehaviour.Properties p_277906_) {
        super(p_277906_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(COLOUR_SPOTS, (Comparable)DyeColor.RED)).setValue(COLOUR_BASE, (Comparable)DyeColor.CYAN)).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_277441_) {
        p_277441_.add(new Property[]{HATCH, COLOUR_BASE, COLOUR_SPOTS});
    }

    public VoxelShape getShape(BlockState p_277872_, BlockGetter p_278090_, BlockPos p_277364_, CollisionContext p_278016_) {
        return SHAPE;
    }

    public int getHatchLevel(BlockState p_279125_) {
        return (Integer)p_279125_.getValue((Property)HATCH);
    }

    private boolean isReadyToHatch(BlockState p_278021_) {
        return this.getHatchLevel(p_278021_) == 2;
    }

    public void tick(BlockState p_277841_, ServerLevel p_277739_, BlockPos p_277692_, RandomSource p_277973_) {
        if (!this.isReadyToHatch(p_277841_)) {
            p_277739_.playSound((Entity)((Player)null), p_277692_, SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + p_277973_.nextFloat() * 0.2f);
            p_277739_.setBlock(p_277692_, (BlockState)p_277841_.setValue((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(p_277841_) + 1)), 2);
        } else {
            p_277739_.playSound((Entity)((Player)null), p_277692_, SoundEvents.SNIFFER_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + p_277973_.nextFloat() * 0.2f);
            p_277739_.destroyBlock(p_277692_, false);
            SkeletonSnifferEntity sniffer = (SkeletonSnifferEntity)((EntityType)TTEntityRegistry.SKELETON_SNIFFER.get()).create((Level)p_277739_, EntitySpawnReason.BREEDING);
            if (sniffer != null) {
                Vec3 vec3 = p_277692_.getCenter();
                sniffer.setBaby(true);
                sniffer.setColor((DyeColor)p_277841_.getValue(COLOUR_SPOTS));
                sniffer.setSecondColor((DyeColor)p_277841_.getValue(COLOUR_BASE));
                sniffer.snapTo(vec3.x(), vec3.y(), vec3.z(), Mth.wrapDegrees((float)(p_277739_.random.nextFloat() * 360.0f)), 0.0f);
                p_277739_.addFreshEntity((Entity)sniffer);
            }
        }
    }

    public void onPlace(BlockState p_277964_, Level p_277827_, BlockPos p_277526_, BlockState p_277618_, boolean p_277819_) {
        boolean flag = SusSnifferEggBlock.hatchBoost((BlockGetter)p_277827_, p_277526_);
        if (!p_277827_.isClientSide() && flag) {
            p_277827_.levelEvent(3009, p_277526_, 0);
        }
        int i = flag ? 12000 : 24000;
        int j = i / 3;
        p_277827_.gameEvent((Holder)GameEvent.BLOCK_PLACE, p_277526_, GameEvent.Context.of((BlockState)p_277964_));
        p_277827_.scheduleTick(p_277526_, (Block)this, j + p_277827_.random.nextInt(300));
    }

    public static boolean hatchBoost(BlockGetter p_277485_, BlockPos p_278065_) {
        return p_277485_.getBlockState(p_278065_.below()).is(BlockTags.SNIFFER_EGG_HATCH_BOOST);
    }
}

