/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.trailsandtalesplus.Objects.entity.ai;

import com.belgie.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgie.trailsandtalesplus.Objects.entity.SkeletonSnifferEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class SkeletonSnifferEntityAi {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_LOOK_DISTANCE = 6;
    public static final List<SensorType<? extends Sensor<? super SkeletonSnifferEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.SNIFFER_TEMPTATIONS);
    public static final List<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.SNIFFER_SNIFFING_TARGET, (Object)MemoryModuleType.SNIFFER_DIGGING, (Object)MemoryModuleType.SNIFFER_HAPPY, (Object)MemoryModuleType.SNIFF_COOLDOWN, (Object)MemoryModuleType.SNIFFER_EXPLORED_POSITIONS, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.BREED_TARGET, (Object[])new MemoryModuleType[]{MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED});
    private static final int SNIFFING_COOLDOWN_TICKS = 9600;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_SNIFFING = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.25f;

    public static Predicate<ItemStack> getTemptations() {
        return p_327001_ -> p_327001_.is(ItemTags.SNIFFER_FOOD);
    }

    public static Brain<?> makeBrain(Brain<SkeletonSnifferEntity> p_273175_) {
        SkeletonSnifferEntityAi.initCoreActivity(p_273175_);
        SkeletonSnifferEntityAi.initIdleActivity(p_273175_);
        SkeletonSnifferEntityAi.initSniffingActivity(p_273175_);
        SkeletonSnifferEntityAi.initDigActivity(p_273175_);
        p_273175_.setCoreActivities(Set.of(Activity.CORE));
        p_273175_.setDefaultActivity(Activity.IDLE);
        p_273175_.useDefaultActivity();
        return p_273175_;
    }

    static SkeletonSnifferEntity resetSniffing(SkeletonSnifferEntity p_279301_) {
        p_279301_.getBrain().eraseMemory(MemoryModuleType.SNIFFER_DIGGING);
        p_279301_.getBrain().eraseMemory(MemoryModuleType.SNIFFER_SNIFFING_TARGET);
        return p_279301_.transitionTo(SkeletonSnifferEntity.State.IDLING);
    }

    private static void initCoreActivity(Brain<SkeletonSnifferEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic<SkeletonSnifferEntity>(2.0f){

            protected void start(ServerLevel p_326360_, SkeletonSnifferEntity p_326298_, long p_326169_) {
                SkeletonSnifferEntityAi.resetSniffing(p_326298_);
                super.start(p_326360_, (PathfinderMob)p_326298_, p_326169_);
            }
        }, (Object)new MoveToTargetSink(500, 700), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initSniffingActivity(Brain<SkeletonSnifferEntity> p_273183_) {
        p_273183_.addActivityWithConditions(Activity.SNIFF, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Searching()))), Set.of(Pair.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.SNIFFER_SNIFFING_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initDigActivity(Brain<SkeletonSnifferEntity> p_273677_) {
        p_273677_.addActivityWithConditions(Activity.DIG, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Digging(160, 180))), (Object)Pair.of((Object)0, (Object)((Object)new FinishedDigging(40)))), Set.of(Pair.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.SNIFFER_DIGGING, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initIdleActivity(Brain<SkeletonSnifferEntity> p_273750_) {
        p_273750_.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove(TTEntityRegistry.SKELETON_SNIFFER.get()){

            protected void start(ServerLevel p_279149_, Animal p_279090_, long p_279482_) {
                SkeletonSnifferEntityAi.resetSniffing((SkeletonSnifferEntity)p_279090_);
                super.start(p_279149_, p_279090_, p_279482_);
            }
        }), (Object)Pair.of((Object)1, (Object)new FollowTemptation(p_279492_ -> Float.valueOf(1.25f), p_288909_ -> p_288909_.isBaby() ? 2.5 : 3.5){

            protected void start(ServerLevel p_279230_, PathfinderMob p_279386_, long p_279139_) {
                SkeletonSnifferEntityAi.resetSniffing((SkeletonSnifferEntity)p_279386_);
                super.start(p_279230_, p_279386_, p_279139_);
            }
        }), (Object)Pair.of((Object)2, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)3, (Object)((Object)new FeelingHappy(40, 100))), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)((Object)new Scenting(40, 80)), (Object)1), (Object)Pair.of((Object)((Object)new Sniffing(40, 80)), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)6.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(5, 20), (Object)2))))), Set.of(Pair.of((Object)MemoryModuleType.SNIFFER_DIGGING, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(SkeletonSnifferEntity p_273301_) {
        p_273301_.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.DIG, (Object)Activity.SNIFF, (Object)Activity.IDLE));
    }

    static class Searching
    extends Behavior<SkeletonSnifferEntity> {
        Searching() {
            super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_SNIFFING_TARGET, MemoryStatus.VALUE_PRESENT), 600);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_273493_, SkeletonSnifferEntity p_272857_) {
            return p_272857_.canSniff();
        }

        protected boolean canStillUse(ServerLevel p_273196_, SkeletonSnifferEntity p_273769_, long p_273602_) {
            if (!p_273769_.canSniff()) {
                p_273769_.transitionTo(SkeletonSnifferEntity.State.IDLING);
                return false;
            }
            Optional<BlockPos> $$3 = p_273769_.getBrain().getMemory(MemoryModuleType.WALK_TARGET).map(WalkTarget::getTarget).map(PositionTracker::currentBlockPosition);
            Optional $$4 = p_273769_.getBrain().getMemory(MemoryModuleType.SNIFFER_SNIFFING_TARGET);
            return !$$3.isEmpty() && !$$4.isEmpty() ? ((BlockPos)$$4.get()).equals((Object)$$3.get()) : false;
        }

        protected void start(ServerLevel p_273563_, SkeletonSnifferEntity p_273394_, long p_273358_) {
            p_273394_.transitionTo(SkeletonSnifferEntity.State.SEARCHING);
        }

        protected void stop(ServerLevel p_273705_, SkeletonSnifferEntity p_273135_, long p_272667_) {
            if (p_273135_.canDig() && p_273135_.canSniff()) {
                p_273135_.getBrain().setMemory(MemoryModuleType.SNIFFER_DIGGING, (Object)true);
            }
            p_273135_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            p_273135_.getBrain().eraseMemory(MemoryModuleType.SNIFFER_SNIFFING_TARGET);
        }
    }

    private static class Digging
    extends Behavior<SkeletonSnifferEntity> {
        Digging(int p_272666_, int p_273420_) {
            super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_DIGGING, MemoryStatus.VALUE_PRESENT, MemoryModuleType.SNIFF_COOLDOWN, MemoryStatus.VALUE_ABSENT), p_272666_, p_273420_);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_273442_, SkeletonSnifferEntity p_273370_) {
            return p_273370_.canSniff();
        }

        protected boolean canStillUse(ServerLevel p_272686_, SkeletonSnifferEntity p_273617_, long p_273124_) {
            return p_273617_.getBrain().getMemory(MemoryModuleType.SNIFFER_DIGGING).isPresent() && p_273617_.canDig() && !p_273617_.isInLove();
        }

        protected void start(ServerLevel p_272951_, SkeletonSnifferEntity p_272688_, long p_272979_) {
            p_272688_.transitionTo(SkeletonSnifferEntity.State.DIGGING);
        }

        protected void stop(ServerLevel p_273656_, SkeletonSnifferEntity p_273063_, long p_272844_) {
            boolean $$3 = this.timedOut(p_272844_);
            if ($$3) {
                p_273063_.getBrain().setMemoryWithExpiry(MemoryModuleType.SNIFF_COOLDOWN, (Object)Unit.INSTANCE, 9600L);
            } else {
                SkeletonSnifferEntityAi.resetSniffing(p_273063_);
            }
        }
    }

    private static class FinishedDigging
    extends Behavior<SkeletonSnifferEntity> {
        FinishedDigging(int p_272941_) {
            super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_DIGGING, MemoryStatus.VALUE_PRESENT, MemoryModuleType.SNIFF_COOLDOWN, MemoryStatus.VALUE_PRESENT), p_272941_, p_272941_);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_273692_, SkeletonSnifferEntity p_272856_) {
            return true;
        }

        protected boolean canStillUse(ServerLevel p_273775_, SkeletonSnifferEntity p_273131_, long p_273569_) {
            return p_273131_.getBrain().getMemory(MemoryModuleType.SNIFFER_DIGGING).isPresent();
        }

        protected void start(ServerLevel p_272708_, SkeletonSnifferEntity p_273502_, long p_272739_) {
            p_273502_.transitionTo(SkeletonSnifferEntity.State.RISING);
        }

        protected void stop(ServerLevel p_273210_, SkeletonSnifferEntity p_273648_, long p_272804_) {
            boolean $$3 = this.timedOut(p_272804_);
            p_273648_.transitionTo(SkeletonSnifferEntity.State.IDLING).onDiggingComplete($$3);
            p_273648_.getBrain().eraseMemory(MemoryModuleType.SNIFFER_DIGGING);
            p_273648_.getBrain().setMemory(MemoryModuleType.SNIFFER_HAPPY, (Object)true);
        }
    }

    static class FeelingHappy
    extends Behavior<SkeletonSnifferEntity> {
        FeelingHappy(int p_273286_, int p_272777_) {
            super(Map.of(MemoryModuleType.SNIFFER_HAPPY, MemoryStatus.VALUE_PRESENT), p_273286_, p_272777_);
        }

        protected boolean canStillUse(ServerLevel p_272660_, SkeletonSnifferEntity p_273250_, long p_273180_) {
            return true;
        }

        protected void start(ServerLevel p_273624_, SkeletonSnifferEntity p_273470_, long p_273501_) {
            p_273470_.transitionTo(SkeletonSnifferEntity.State.FEELING_HAPPY);
        }

        protected void stop(ServerLevel p_273216_, SkeletonSnifferEntity p_273271_, long p_273738_) {
            p_273271_.transitionTo(SkeletonSnifferEntity.State.IDLING);
            p_273271_.getBrain().eraseMemory(MemoryModuleType.SNIFFER_HAPPY);
        }
    }

    private static class Scenting
    extends Behavior<SkeletonSnifferEntity> {
        Scenting(int p_272680_, int p_273445_) {
            super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_DIGGING, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_SNIFFING_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_HAPPY, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREED_TARGET, MemoryStatus.VALUE_ABSENT), p_272680_, p_273445_);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_279176_, SkeletonSnifferEntity p_279496_) {
            return !p_279496_.isTempted();
        }

        protected boolean canStillUse(ServerLevel p_273482_, SkeletonSnifferEntity p_273724_, long p_273191_) {
            return true;
        }

        protected void start(ServerLevel p_272795_, SkeletonSnifferEntity p_272788_, long p_273611_) {
            p_272788_.transitionTo(SkeletonSnifferEntity.State.SCENTING);
        }

        protected void stop(ServerLevel p_272816_, SkeletonSnifferEntity p_273426_, long p_272832_) {
            p_273426_.transitionTo(SkeletonSnifferEntity.State.IDLING);
        }
    }

    private static class Sniffing
    extends Behavior<SkeletonSnifferEntity> {
        Sniffing(int p_272703_, int p_272735_) {
            super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_SNIFFING_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFF_COOLDOWN, MemoryStatus.VALUE_ABSENT), p_272703_, p_272735_);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_272972_, SkeletonSnifferEntity p_273676_) {
            return !p_273676_.isBaby() && p_273676_.canSniff();
        }

        protected boolean canStillUse(ServerLevel p_273156_, SkeletonSnifferEntity p_273448_, long p_272841_) {
            return p_273448_.canSniff();
        }

        protected void start(ServerLevel p_272950_, SkeletonSnifferEntity p_272614_, long p_273573_) {
            p_272614_.transitionTo(SkeletonSnifferEntity.State.SNIFFING);
        }

        protected void stop(ServerLevel p_272617_, SkeletonSnifferEntity p_273181_, long p_272635_) {
            boolean $$3 = this.timedOut(p_272635_);
            p_273181_.transitionTo(SkeletonSnifferEntity.State.IDLING);
            if ($$3) {
                p_273181_.calculateDigPosition().ifPresent(p_273341_ -> {
                    p_273181_.getBrain().setMemory(MemoryModuleType.SNIFFER_SNIFFING_TARGET, p_273341_);
                    p_273181_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(p_273341_, 1.25f, 0));
                });
            }
        }
    }
}

