/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.trailsandtalesplus.Objects.entity.model;

import com.belgie.trailsandtalesplus.Objects.entity.renderer.SniffleRenderState;
import net.minecraft.client.animation.definitions.SnifferAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkeletonSnifferModel
extends EntityModel<SniffleRenderState> {
    private static final float WALK_ANIMATION_SPEED_MAX = 9.0f;
    private static final float WALK_ANIMATION_SCALE_FACTOR = 100.0f;
    private final ModelPart root;
    private final ModelPart head;

    public SkeletonSnifferModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.head = this.root.getChild("bone").getChild("body").getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot().addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition $$2 = $$1.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(95, 76).addBox(-12.5f, 12.0f, -16.0f, 25.0f, 0.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 80).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 25.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 8).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 20.0f, 32.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 4).addBox(-6.5f, 7.5f, -11.5f, 13.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(8, 15).addBox(-6.5f, -7.5f, -11.5f, 13.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)-16.0f));
        PartDefinition lower_beak = head.addOrReplaceChild("lower_beak", CubeListBuilder.create().texOffs(15, 62).addBox(-6.5f, -7.0f, 1.0f, 13.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.5f, (float)-16.5f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(15, 50).addBox(-6.5f, -2.0f, 0.0f, 13.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-15.5f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(2, 0).addBox(0.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition front_left_leg = $$2.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition front_right_leg = $$2.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(32, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition back_left_leg = $$2.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)15.0f));
        PartDefinition back_right_leg = $$2.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(32, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)15.0f));
        return LayerDefinition.create((MeshDefinition)$$0, (int)192, (int)192);
    }

    public static LayerDefinition createFur() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot().addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition $$2 = $$1.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(95, 76).addBox(-12.5f, 12.0f, -16.0f, 25.0f, 0.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 80).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 25.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 8).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 20.0f, 32.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 4).addBox(-6.5f, 7.5f, -11.5f, 13.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(8, 15).addBox(-6.5f, -7.5f, -11.5f, 13.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)-16.0f));
        PartDefinition lower_beak = head.addOrReplaceChild("lower_beak", CubeListBuilder.create().texOffs(15, 62).addBox(-6.5f, -7.0f, 1.0f, 13.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.5f, (float)-16.5f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(15, 50).addBox(-6.5f, -2.0f, 0.0f, 13.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-15.5f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(2, 0).addBox(0.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition front_left_leg = $$2.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition front_right_leg = $$2.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(32, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition back_left_leg = $$2.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)15.0f));
        PartDefinition back_right_leg = $$2.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(32, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)15.0f));
        return LayerDefinition.create((MeshDefinition)$$0, (int)192, (int)192);
    }

    public static LayerDefinition createSkimLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot().addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition $$2 = $$1.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(95, 76).addBox(-12.5f, 12.0f, -16.0f, 25.0f, 0.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 80).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 25.0f, 32.0f, new CubeDeformation(0.0f)).texOffs(70, 8).addBox(-12.5f, -10.0f, -16.0f, 25.0f, 20.0f, 32.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 4).addBox(-6.5f, 7.5f, -11.5f, 13.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(8, 15).addBox(-6.5f, -7.5f, -11.5f, 13.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)-16.0f));
        PartDefinition lower_beak = head.addOrReplaceChild("lower_beak", CubeListBuilder.create().texOffs(15, 62).addBox(-6.5f, -7.0f, 1.0f, 13.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.5f, (float)-16.5f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(15, 50).addBox(-6.5f, -2.0f, 0.0f, 13.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-15.5f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(2, 0).addBox(0.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, 1.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.51f, (float)-7.5f, (float)-6.51f));
        PartDefinition front_left_leg = $$2.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition front_right_leg = $$2.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(32, 87).addBox(-3.5f, -1.0f, 1.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition back_left_leg = $$2.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)15.0f));
        PartDefinition back_right_leg = $$2.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(32, 123).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)15.0f));
        return LayerDefinition.create((MeshDefinition)$$0, (int)192, (int)192);
    }

    public void setupAnim(SniffleRenderState p_363751_) {
        super.setupAnim((EntityRenderState)p_363751_);
        this.head.xRot = p_363751_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_363751_.yRot * ((float)Math.PI / 180);
        if (p_363751_.isSearching) {
            this.animateWalk(SnifferAnimation.SNIFFER_SNIFF_SEARCH, p_363751_.walkAnimationPos, p_363751_.walkAnimationSpeed, 9.0f, 100.0f);
        } else {
            this.animateWalk(SnifferAnimation.SNIFFER_WALK, p_363751_.walkAnimationPos, p_363751_.walkAnimationSpeed, 9.0f, 100.0f);
        }
        this.animate(p_363751_.diggingAnimationState, SnifferAnimation.SNIFFER_DIG, p_363751_.ageInTicks);
        this.animate(p_363751_.sniffingAnimationState, SnifferAnimation.SNIFFER_LONGSNIFF, p_363751_.ageInTicks);
        this.animate(p_363751_.risingAnimationState, SnifferAnimation.SNIFFER_STAND_UP, p_363751_.ageInTicks);
        this.animate(p_363751_.feelingHappyAnimationState, SnifferAnimation.SNIFFER_HAPPY, p_363751_.ageInTicks);
        this.animate(p_363751_.scentingAnimationState, SnifferAnimation.SNIFFER_SNIFFSNIFF, p_363751_.ageInTicks);
        if (p_363751_.isBaby) {
            this.applyStatic(SnifferAnimation.BABY_TRANSFORM);
        }
    }
}

