/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.blocks;

import com.belgieyt.trailsandtalesplus.Objects.TTTagsRegistry;
import com.belgieyt.trailsandtalesplus.Objects.blocks.FloweredPitcherPodBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PitcherPodBlock
extends Block {
    protected static final float AABB_OFFSET = 1.0f;
    protected static final float AABB_SIZE_PER_BITE = 2.0f;
    private static final VoxelShape FULL_LOWER_SHAPE = Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);

    public PitcherPodBlock(BlockBehaviour.Properties p_51184_) {
        super(p_51184_);
    }

    protected VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return FULL_LOWER_SHAPE;
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState p_51202_, Level p_51203_, BlockPos p_51204_, Player p_51205_, InteractionHand p_51206_, BlockHitResult p_51207_) {
        Item item = itemstack.getItem();
        if (itemstack.is(TTTagsRegistry.CAN_PLACE_ON_PITCHERS)) {
            Block block = Block.byItem((Item)itemstack.getItem());
            if (!p_51205_.isCreative()) {
                itemstack.shrink(1);
            }
            p_51203_.playSound((Player)null, p_51204_, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_51203_.setBlock(p_51204_, FloweredPitcherPodBlock.byCandle(block), 3);
            p_51203_.gameEvent((Entity)p_51205_, (Holder)GameEvent.BLOCK_CHANGE, p_51204_);
            p_51205_.awardStat(Stats.ITEM_USED.get((Object)item));
            return InteractionResult.SUCCESS;
        }
        return itemstack.isEmpty() ? InteractionResult.CONSUME : super.useItemOn(itemstack, p_51202_, p_51203_, p_51204_, p_51205_, p_51206_, p_51207_);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return direction == Direction.DOWN && !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected boolean isPathfindable(BlockState p_152870_, PathComputationType p_152873_) {
        return false;
    }
}

