/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTBlockRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTEntityDataRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.entity.ai.SkeletonSnifferEntityAi;
import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class SkeletonSnifferEntity
extends Animal {
    private static final int DIGGING_PARTICLES_DELAY_TICKS = 1700;
    private static final int DIGGING_PARTICLES_DURATION_TICKS = 6000;
    private static final int DIGGING_PARTICLES_AMOUNT = 30;
    private static final int DIGGING_DROP_SEED_OFFSET_TICKS = 120;
    private static final int SNIFFER_BABY_AGE_TICKS = 48000;
    private static final float DIGGING_BB_HEIGHT_OFFSET = 0.4f;
    private static final EntityDimensions DIGGING_DIMENSIONS = EntityDimensions.scalable((float)((EntityType)TTEntityRegistry.SKELETON_SNIFFER.get()).getWidth(), (float)(((EntityType)TTEntityRegistry.SKELETON_SNIFFER.get()).getHeight() - 0.4f)).withEyeHeight(0.41f);
    private static final EntityDataAccessor<State> DATA_STATE = SynchedEntityData.defineId(SkeletonSnifferEntity.class, TTEntityDataRegistry.SNIFFER_STATE);
    private static final EntityDataAccessor<Integer> DATA_DROP_SEED_AT_TICK = SynchedEntityData.defineId(SkeletonSnifferEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState feelingHappyAnimationState = new AnimationState();
    public final AnimationState scentingAnimationState = new AnimationState();
    public final AnimationState sniffingAnimationState = new AnimationState();
    public final AnimationState diggingAnimationState = new AnimationState();
    public final AnimationState risingAnimationState = new AnimationState();
    private static final EntityDataAccessor<Byte> DATA_WOOL_ID = SynchedEntityData.defineId(SkeletonSnifferEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> DATA_WOOL_SECOND_ID = SynchedEntityData.defineId(SkeletonSnifferEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final Map<DyeColor, Integer> COLOR_BY_DYE = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(p_29868_ -> p_29868_, SkeletonSnifferEntity::createSheepColor)));

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.MAX_HEALTH, 14.0);
    }

    public SkeletonSnifferEntity(EntityType<? extends Animal> p_273717_, Level p_273562_) {
        super(p_273717_, p_273562_);
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_CAUTIOUS, -1.0f);
    }

    public void onPathfindingStart() {
        super.onPathfindingStart();
        if (this.isOnFire() || this.isInWater()) {
            this.setPathfindingMalus(PathType.WATER, 0.0f);
        }
    }

    public void onPathfindingDone() {
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    public EntityDimensions getDefaultDimensions(Pose p_331665_) {
        return this.getState() == State.DIGGING ? DIGGING_DIMENSIONS.scale(this.getAgeScale()) : super.getDefaultDimensions(p_331665_);
    }

    public boolean isSearching() {
        return this.getState() == State.SEARCHING;
    }

    public boolean isTempted() {
        return this.brain.getMemory(MemoryModuleType.IS_TEMPTED).orElse(false);
    }

    public boolean canSniff() {
        return !this.isTempted() && !this.isPanicking() && !this.isInWater() && !this.isInLove() && this.onGround() && !this.isPassenger() && !this.isLeashed();
    }

    public boolean canPlayDiggingSound() {
        return this.getState() == State.DIGGING || this.getState() == State.SEARCHING;
    }

    private BlockPos getHeadBlock() {
        Vec3 vec3 = this.getHeadPosition();
        return BlockPos.containing((double)vec3.x(), (double)(this.getY() + (double)0.2f), (double)vec3.z());
    }

    public boolean isPushable() {
        return this.getState() != State.DIGGING;
    }

    private Vec3 getHeadPosition() {
        return this.position().add(this.getForward().scale(1.25));
    }

    private State getState() {
        return (State)((Object)this.entityData.get(DATA_STATE));
    }

    private SkeletonSnifferEntity setState(State p_273359_) {
        this.entityData.set(DATA_STATE, (Object)p_273359_);
        return this;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_272936_) {
        if (DATA_STATE.equals(p_272936_)) {
            State sniffer$state = this.getState();
            this.resetAnimations();
            switch (sniffer$state.ordinal()) {
                case 1: {
                    this.feelingHappyAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 2: {
                    this.scentingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 3: {
                    this.sniffingAnimationState.startIfStopped(this.tickCount);
                }
                default: {
                    break;
                }
                case 5: {
                    this.diggingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 6: {
                    this.risingAnimationState.startIfStopped(this.tickCount);
                }
            }
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(p_272936_);
    }

    private void resetAnimations() {
        this.diggingAnimationState.stop();
        this.sniffingAnimationState.stop();
        this.risingAnimationState.stop();
        this.feelingHappyAnimationState.stop();
        this.scentingAnimationState.stop();
    }

    public SkeletonSnifferEntity transitionTo(State p_273096_) {
        switch (p_273096_.ordinal()) {
            case 0: {
                this.setState(State.IDLING);
                break;
            }
            case 1: {
                this.playSound(SoundEvents.SNIFFER_HAPPY, 1.0f, 1.0f);
                this.setState(State.FEELING_HAPPY);
                break;
            }
            case 2: {
                this.setState(State.SCENTING).onScentingStart();
                break;
            }
            case 3: {
                this.playSound(SoundEvents.SNIFFER_SNIFFING, 1.0f, 1.0f);
                this.setState(State.SNIFFING);
                break;
            }
            case 4: {
                this.setState(State.SEARCHING);
                break;
            }
            case 5: {
                this.setState(State.DIGGING).onDiggingStart();
                break;
            }
            case 6: {
                this.playSound(SoundEvents.SNIFFER_DIGGING_STOP, 1.0f, 1.0f);
                this.setState(State.RISING);
            }
        }
        return this;
    }

    private SkeletonSnifferEntity onScentingStart() {
        this.playSound(SoundEvents.SNIFFER_SCENTING, 1.0f, this.isBaby() ? 1.3f : 1.0f);
        return this;
    }

    private SkeletonSnifferEntity onDiggingStart() {
        this.entityData.set(DATA_DROP_SEED_AT_TICK, (Object)(this.tickCount + 120));
        return this;
    }

    public SkeletonSnifferEntity onDiggingComplete(boolean p_272677_) {
        if (p_272677_) {
            this.storeExploredPosition(this.getOnPos());
        }
        return this;
    }

    public Optional<BlockPos> calculateDigPosition() {
        return IntStream.range(0, 5).mapToObj(p_273771_ -> LandRandomPos.getPos((PathfinderMob)this, (int)(10 + 2 * p_273771_), (int)3)).filter(Objects::nonNull).map(BlockPos::containing).filter(p_341433_ -> this.level().getWorldBorder().isWithinBounds(p_341433_)).map(BlockPos::below).filter(this::canDig).findFirst();
    }

    public boolean canDig() {
        return !this.isPanicking() && !this.isTempted() && !this.isBaby() && !this.isInWater() && this.onGround() && !this.isPassenger() && this.canDig(this.getHeadBlock().below());
    }

    private boolean canDig(BlockPos p_272757_) {
        return this.level().getBlockState(p_272757_).is(BlockTags.SNIFFER_DIGGABLE_BLOCK) && this.getExploredPositions().noneMatch(p_341432_ -> GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)p_272757_).equals(p_341432_)) && Optional.ofNullable(this.getNavigation().createPath(p_272757_, 1)).map(Path::canReach).orElse(false) != false;
    }

    private SkeletonSnifferEntity emitDiggingParticles(AnimationState p_273528_) {
        boolean flag;
        boolean bl = flag = p_273528_.getTimeInMillis((float)this.tickCount) > 1700L && p_273528_.getTimeInMillis((float)this.tickCount) < 6000L;
        if (flag) {
            BlockPos blockpos = this.getHeadBlock();
            BlockState blockstate = this.level().getBlockState(blockpos.below());
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockpos).add(0.0, (double)-0.65f, 0.0);
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
                }
                if (this.tickCount % 10 == 0) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), blockstate.getSoundType((LevelReader)this.level(), blockpos.below(), (Entity)this).getHitSound(), this.getSoundSource(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.tickCount % 10 == 0) {
            this.level().gameEvent((Holder)GameEvent.ENTITY_ACTION, this.getHeadBlock(), GameEvent.Context.of((Entity)this));
        }
        return this;
    }

    private SkeletonSnifferEntity storeExploredPosition(BlockPos p_273015_) {
        List list = this.getExploredPositions().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)p_273015_));
        this.getBrain().setMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS, list);
        return this;
    }

    private Stream<GlobalPos> getExploredPositions() {
        return this.getBrain().getMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS).stream().flatMap(Collection::stream);
    }

    public void jumpFromGround() {
        double d1;
        super.jumpFromGround();
        double d0 = this.moveControl.getSpeedModifier();
        if (d0 > 0.0 && (d1 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
    }

    public void spawnChildFromBreeding(ServerLevel p_277923_, Animal p_277857_) {
        ItemStack itemstack = new ItemStack((ItemLike)TTBlockRegistry.SUS_SNIFFER_EGG.get());
        ItemEntity itementity = new ItemEntity((Level)p_277923_, this.position().x(), this.position().y(), this.position().z(), itemstack);
        itementity.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(p_277923_, p_277857_, null);
        this.playSound(SoundEvents.SNIFFER_EGG_PLOP, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        p_277923_.addFreshEntity((Entity)itementity);
    }

    public void die(DamageSource p_277689_) {
        this.transitionTo(State.IDLING);
        super.die(p_277689_);
    }

    public void tick() {
        switch (this.getState().ordinal()) {
            case 4: {
                this.playSearchingSound();
                break;
            }
            case 5: {
                this.emitDiggingParticles(this.diggingAnimationState).dropSeed();
            }
        }
        super.tick();
    }

    private void playSearchingSound() {
        if (this.level().isClientSide() && this.tickCount % 20 == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.SNIFFER_SEARCHING, this.getSoundSource(), 1.0f, 1.0f, false);
        }
    }

    protected void playStepSound(BlockPos p_272953_, BlockState p_273729_) {
        this.playSound(SoundEvents.SNIFFER_STEP, 0.15f, 1.0f);
    }

    public SoundEvent getEatingSound(ItemStack p_272747_) {
        return SoundEvents.SNIFFER_EAT;
    }

    protected SoundEvent getAmbientSound() {
        return Set.of(State.DIGGING, State.SEARCHING).contains((Object)this.getState()) ? null : SoundEvents.SNIFFER_IDLE;
    }

    protected SoundEvent getHurtSound(DamageSource p_273718_) {
        return SoundEvents.SNIFFER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SNIFFER_DEATH;
    }

    public int getMaxHeadYRot() {
        return 50;
    }

    public void setBaby(boolean p_272995_) {
        this.setAge(p_272995_ ? -48000 : 0);
    }

    public AgeableMob getBreedOffspring(ServerLevel p_273401_, AgeableMob p_273310_) {
        return (AgeableMob)((EntityType)TTEntityRegistry.SKELETON_SNIFFER.get()).create((Level)p_273401_, EntitySpawnReason.BREEDING);
    }

    public boolean canMate(Animal p_272966_) {
        if (!(p_272966_ instanceof SkeletonSnifferEntity)) {
            return false;
        }
        SkeletonSnifferEntity sniffer = (SkeletonSnifferEntity)p_272966_;
        Set<State> set = Set.of(State.IDLING, State.SCENTING, State.FEELING_HAPPY);
        return set.contains((Object)this.getState()) && set.contains((Object)sniffer.getState()) && super.canMate(p_272966_);
    }

    public boolean isFood(ItemStack p_273659_) {
        return p_273659_.is(ItemTags.SNIFFER_FOOD);
    }

    protected Brain<?> makeBrain(Dynamic<?> p_273174_) {
        return SkeletonSnifferEntityAi.makeBrain((Brain<SkeletonSnifferEntity>)this.brainProvider().makeBrain(p_273174_));
    }

    public Brain<SkeletonSnifferEntity> getBrain() {
        return super.getBrain();
    }

    protected Brain.Provider<SkeletonSnifferEntity> brainProvider() {
        return Brain.provider(SkeletonSnifferEntityAi.MEMORY_TYPES, SkeletonSnifferEntityAi.SENSOR_TYPES);
    }

    protected void customServerAiStep(ServerLevel p_376484_) {
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("sussnifferBrain");
        this.getBrain().tick(p_376484_, (LivingEntity)this);
        profilerfiller.popPush("sussnifferActivityUpdate");
        SkeletonSnifferEntityAi.updateActivity(this);
        profilerfiller.pop();
        super.customServerAiStep(p_376484_);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    private static int createSheepColor(DyeColor p_29866_) {
        if (p_29866_ == DyeColor.WHITE) {
            return -1644826;
        }
        int i = p_29866_.getTextureDiffuseColor();
        float f = 0.75f;
        return ARGB.color((int)255, (int)Mth.floor((float)((float)ARGB.red((int)i) * 0.75f)), (int)Mth.floor((float)((float)ARGB.green((int)i) * 0.75f)), (int)Mth.floor((float)((float)ARGB.blue((int)i) * 0.75f)));
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335721_) {
        super.defineSynchedData(p_335721_);
        p_335721_.define(DATA_STATE, (Object)State.IDLING);
        p_335721_.define(DATA_DROP_SEED_AT_TICK, (Object)0);
        p_335721_.define(DATA_WOOL_ID, (Object)14);
        p_335721_.define(DATA_WOOL_SECOND_ID, (Object)9);
    }

    private void dropSeed() {
        if (!this.level().isClientSide() && (Integer)this.entityData.get(DATA_DROP_SEED_AT_TICK) == this.tickCount) {
            ServerLevel serverlevel = (ServerLevel)this.level();
            Holder biome = serverlevel.getBiome(this.getHeadBlock());
            LootTable loottable = biome.is(BiomeTags.HAS_ANCIENT_CITY) ? serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.ANCIENT_CITY) : (biome.is(BiomeTags.HAS_MINESHAFT_MESA) ? serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.ABANDONED_MINESHAFT) : (biome.is(BiomeTags.HAS_STRONGHOLD) ? serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.STRONGHOLD_CORRIDOR) : (biome.is(BiomeTags.HAS_TRAIL_RUINS) ? serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON) : (biome.is(BiomeTags.HAS_DESERT_PYRAMID) ? serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.DESERT_PYRAMID) : (biome.is(BiomeTags.HAS_IGLOO) ? serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.IGLOO_CHEST) : (biome.is(Biomes.DARK_FOREST) ? serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.WOODLAND_MANSION) : (biome.is(BiomeTags.HAS_BASTION_REMNANT) ? serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.BASTION_TREASURE) : (biome.is(BiomeTags.HAS_NETHER_FORTRESS) ? serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.NETHER_BRIDGE) : serverlevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.ABANDONED_MINESHAFT)))))))));
            LootParams lootparams = new LootParams.Builder(serverlevel).withParameter(LootContextParams.ORIGIN, (Object)this.getHeadPosition()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.GIFT);
            ObjectArrayList list = loottable.getRandomItems(lootparams);
            BlockPos blockpos = this.getHeadBlock();
            Iterator var6 = list.iterator();
            for (int i = 0; i < 2; ++i) {
                ItemStack itemstack = (ItemStack)var6.next();
                ItemEntity itementity = new ItemEntity((Level)serverlevel, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), itemstack);
                itementity.setDefaultPickUpDelay();
                serverlevel.addFreshEntity((Entity)itementity);
            }
            this.playSound(SoundEvents.SNIFFER_DROP_SEED, 1.0f, 1.0f);
        }
    }

    public InteractionResult mobInteract(Player p_273046_, InteractionHand p_272687_) {
        ItemStack itemstack = p_273046_.getItemInHand(p_272687_);
        boolean flag = this.isFood(itemstack);
        InteractionResult interactionresult = super.mobInteract(p_273046_, p_272687_);
        Item item = itemstack.getItem();
        if (item instanceof DyeItem) {
            DyeItem item2 = (DyeItem)item;
            if (p_273046_.isCrouching()) {
                if (this.isAlive() && this.getSecondColor() != item2.getDyeColor()) {
                    p_273046_.level().playSound(p_273046_, this.blockPosition(), SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!p_273046_.level().isClientSide) {
                        this.setSecondColor(item2.getDyeColor());
                        itemstack.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (this.isAlive() && this.getColor() != item2.getDyeColor()) {
                p_273046_.level().playSound(p_273046_, this.blockPosition(), SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!p_273046_.level().isClientSide) {
                    this.setColor(item2.getDyeColor());
                    itemstack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (interactionresult.consumesAction() && flag) {
            this.level().playSound((Player)null, (Entity)this, this.getEatingSound(itemstack), SoundSource.NEUTRAL, 1.0f, Mth.randomBetween((RandomSource)this.level().random, (float)0.8f, (float)1.2f));
        }
        return interactionresult;
    }

    public static int getColor(DyeColor p_342171_) {
        return COLOR_BY_DYE.get(p_342171_);
    }

    public DyeColor getColor() {
        return DyeColor.byId((int)((Byte)this.entityData.get(DATA_WOOL_ID) & 0xF));
    }

    public DyeColor getSecondColor() {
        return DyeColor.byId((int)((Byte)this.entityData.get(DATA_WOOL_SECOND_ID) & 0xF));
    }

    public void addAdditionalSaveData(CompoundTag p_29864_) {
        super.addAdditionalSaveData(p_29864_);
        p_29864_.putByte("Color", (byte)this.getColor().getId());
        p_29864_.putByte("ColorSecond", (byte)this.getSecondColor().getId());
    }

    public void readAdditionalSaveData(CompoundTag p_29845_) {
        super.readAdditionalSaveData(p_29845_);
        this.setColor(DyeColor.byId((int)p_29845_.getByte("Color")));
        this.setSecondColor(DyeColor.byId((int)p_29845_.getByte("ColorSecond")));
    }

    public void setColor(DyeColor p_29856_) {
        byte b0 = (Byte)this.entityData.get(DATA_WOOL_ID);
        this.entityData.set(DATA_WOOL_ID, (Object)((byte)(b0 & 0xF0 | p_29856_.getId() & 0xF)));
    }

    public void setSecondColor(DyeColor p_29856_) {
        byte b0 = (Byte)this.entityData.get(DATA_WOOL_SECOND_ID);
        this.entityData.set(DATA_WOOL_SECOND_ID, (Object)((byte)(b0 & 0xF0 | p_29856_.getId() & 0xF)));
    }

    public static enum State {
        IDLING(0),
        FEELING_HAPPY(1),
        SCENTING(2),
        SNIFFING(3),
        SEARCHING(4),
        DIGGING(5),
        RISING(6);

        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;
        private final int id;

        private State(int p_328116_) {
            this.id = p_328116_;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = ByIdMap.continuous(State::id, (Object[])State.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, State::id);
        }
    }
}

