/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.trailsandtalesplus.Objects.blocks;

import com.belgie.trailsandtalesplus.Objects.blocks.TTBlockProperties;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PileBlock
extends Block {
    public static final int MAX_HEIGHT = 4;
    public static final IntegerProperty LAYERS = TTBlockProperties.SMALL_LAYERS;
    public static final int HEIGHT_IMPASSABLE = 2;

    public PileBlock(BlockBehaviour.Properties p_56585_) {
        super(p_56585_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public boolean isPathfindable(BlockState p_56592_, BlockGetter p_56593_, BlockPos p_56594_, PathComputationType p_56595_) {
        switch (p_56595_) {
            case LAND: {
                return (Integer)p_56592_.getValue((Property)LAYERS) < 2;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape getShape(BlockState p_56620_, BlockGetter p_56621_, BlockPos p_56622_, CollisionContext p_56623_) {
        if ((Integer)p_56620_.getValue((Property)LAYERS) == 1) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        }
        if ((Integer)p_56620_.getValue((Property)LAYERS) == 2) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        }
        if ((Integer)p_56620_.getValue((Property)LAYERS) == 3) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        }
        if ((Integer)p_56620_.getValue((Property)LAYERS) == 4) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return Shapes.empty();
    }

    public VoxelShape getCollisionShape(BlockState p_56625_, BlockGetter p_56626_, BlockPos p_56627_, CollisionContext p_56628_) {
        if ((Integer)p_56625_.getValue((Property)LAYERS) == 1) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        }
        if ((Integer)p_56625_.getValue((Property)LAYERS) == 2) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        }
        if ((Integer)p_56625_.getValue((Property)LAYERS) == 3) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        }
        if ((Integer)p_56625_.getValue((Property)LAYERS) == 4) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return Shapes.empty();
    }

    public VoxelShape getBlockSupportShape(BlockState p_56632_, BlockGetter p_56633_, BlockPos p_56634_) {
        if ((Integer)p_56632_.getValue((Property)LAYERS) == 1) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        }
        if ((Integer)p_56632_.getValue((Property)LAYERS) == 2) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        }
        if ((Integer)p_56632_.getValue((Property)LAYERS) == 3) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        }
        if ((Integer)p_56632_.getValue((Property)LAYERS) == 4) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState p_56597_, BlockGetter p_56598_, BlockPos p_56599_, CollisionContext p_56600_) {
        if ((Integer)p_56597_.getValue((Property)LAYERS) == 1) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        }
        if ((Integer)p_56597_.getValue((Property)LAYERS) == 2) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        }
        if ((Integer)p_56597_.getValue((Property)LAYERS) == 3) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        }
        if ((Integer)p_56597_.getValue((Property)LAYERS) == 4) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return Shapes.empty();
    }

    public boolean useShapeForLightOcclusion(BlockState p_56630_) {
        return true;
    }

    public float getShadeBrightness(BlockState p_222453_, BlockGetter p_222454_, BlockPos p_222455_) {
        return (Integer)p_222453_.getValue((Property)LAYERS) == 4 ? 0.2f : 1.0f;
    }

    public boolean canSurvive(BlockState p_56602_, LevelReader p_56603_, BlockPos p_56604_) {
        BlockState blockstate = p_56603_.getBlockState(p_56604_.below());
        if (blockstate.is(BlockTags.SNOW_LAYER_CANNOT_SURVIVE_ON)) {
            return false;
        }
        if (blockstate.is(BlockTags.SNOW_LAYER_CAN_SURVIVE_ON)) {
            return true;
        }
        return Block.isFaceFull((VoxelShape)blockstate.getCollisionShape((BlockGetter)p_56603_, p_56604_.below()), (Direction)Direction.UP) || blockstate.is((Block)this) && (Integer)blockstate.getValue((Property)LAYERS) == 4;
    }

    public BlockState updateShape(BlockState p_56606_, Direction p_56607_, BlockState p_56608_, LevelAccessor p_56609_, BlockPos p_56610_, BlockPos p_56611_) {
        return !p_56606_.canSurvive((LevelReader)p_56609_, p_56610_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_56606_, p_56607_, p_56608_, p_56609_, p_56610_, p_56611_);
    }

    public void randomTick(BlockState p_222448_, ServerLevel p_222449_, BlockPos p_222450_, RandomSource p_222451_) {
        if (p_222449_.getBrightness(LightLayer.BLOCK, p_222450_) > 11) {
            PileBlock.dropResources((BlockState)p_222448_, (Level)p_222449_, (BlockPos)p_222450_);
            p_222449_.removeBlock(p_222450_, false);
        }
    }

    public boolean canBeReplaced(BlockState p_56589_, BlockPlaceContext p_56590_) {
        int i = (Integer)p_56589_.getValue((Property)LAYERS);
        if (p_56590_.getItemInHand().is(this.asItem()) && i < 4) {
            if (p_56590_.replacingClickedOnBlock()) {
                return p_56590_.getClickedFace() == Direction.UP;
            }
            return true;
        }
        return i == 1;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_56587_) {
        BlockState blockstate = p_56587_.getLevel().getBlockState(p_56587_.getClickedPos());
        if (blockstate.is((Block)this)) {
            int i = (Integer)blockstate.getValue((Property)LAYERS);
            return (BlockState)blockstate.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(4, i + 1)));
        }
        return super.getStateForPlacement(p_56587_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_56613_) {
        p_56613_.add(new Property[]{LAYERS});
    }
}

