/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WaxBlock
extends Block {
    public static final int MAX_HEIGHT = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public static final int HEIGHT_IMPASSABLE = 5;

    public WaxBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(8)));
    }

    public boolean m_7357_(BlockState p_56592_, BlockGetter p_56593_, BlockPos p_56594_, PathComputationType p_56595_) {
        switch (p_56595_) {
            case LAND: {
                return (Integer)p_56592_.m_61143_((Property)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState p_56620_, BlockGetter p_56621_, BlockPos p_56622_, CollisionContext p_56623_) {
        return SHAPE_BY_LAYER[(Integer)p_56620_.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState p_56625_, BlockGetter p_56626_, BlockPos p_56627_, CollisionContext p_56628_) {
        return SHAPE_BY_LAYER[(Integer)p_56625_.m_61143_((Property)LAYERS) - 1];
    }

    public VoxelShape m_7947_(BlockState p_56632_, BlockGetter p_56633_, BlockPos p_56634_) {
        return SHAPE_BY_LAYER[(Integer)p_56632_.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState p_56597_, BlockGetter p_56598_, BlockPos p_56599_, CollisionContext p_56600_) {
        return SHAPE_BY_LAYER[(Integer)p_56597_.m_61143_((Property)LAYERS)];
    }

    public void m_214162_(BlockState p_220773_, Level p_220774_, BlockPos p_220775_, RandomSource p_220776_) {
        if (WaxBlock.isNearFire((LevelReader)p_220774_, p_220775_)) {
            int i = p_220775_.m_123341_();
            int j = p_220775_.m_123342_();
            int k = p_220775_.m_123343_();
            double d0 = (double)i + p_220776_.m_188500_();
            double d1 = (double)j + 0.7;
            double d2 = (double)k + p_220776_.m_188500_();
            p_220774_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, p_220773_), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void m_213898_(BlockState p_222448_, ServerLevel p_222449_, BlockPos p_222450_, RandomSource p_222451_) {
        int i;
        if (WaxBlock.isNearFire((LevelReader)p_222449_, p_222450_) && (i = ((Integer)p_222448_.m_61143_((Property)LAYERS)).intValue()) > 1) {
            p_222449_.m_7731_(p_222450_, (BlockState)p_222448_.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(i - 1)), 3);
        }
    }

    private static boolean isNearFire(LevelReader p_53259_, BlockPos p_53260_) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_53260_.m_7918_(-4, 0, -4), (BlockPos)p_53260_.m_7918_(4, 1, 4))) {
            if (!p_53259_.m_8055_(blockpos).m_204336_(BlockTags.f_13076_)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_56587_) {
        BlockState blockstate = p_56587_.m_43725_().m_8055_(p_56587_.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(p_56587_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_56613_) {
        p_56613_.m_61104_(new Property[]{LAYERS});
    }

    public boolean m_7923_(BlockState p_56630_) {
        return true;
    }

    public float m_7749_(BlockState p_222453_, BlockGetter p_222454_, BlockPos p_222455_) {
        return (Integer)p_222453_.m_61143_((Property)LAYERS) == 8 ? 0.2f : 1.0f;
    }
}

