/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTDamageTypes;
import com.belgieyt.trailsandtalesplus.Objects.TTEnchantmentRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTItemRegistry;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class BambooSpear
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(BambooSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(BambooSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ItemStack tridentItem = new ItemStack((ItemLike)TTItemRegistry.TIPPED_BAMBOO_SPEAR.get());
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;
    private static final int EXPOSED_POTION_DECAY_TIME = 600;
    private static final int NO_EFFECT_COLOR = -1;
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(BambooSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final byte EVENT_POTION_PUFF = 0;
    public Potion potion = Potions.f_43598_;
    public final Set<MobEffectInstance> effects = Sets.newHashSet();
    private boolean fixedColor;

    public BambooSpear(EntityType<? extends BambooSpear> p_37561_, Level p_37562_) {
        super(p_37561_, p_37562_);
    }

    public BambooSpear(Level p_36861_, double p_36862_, double p_36863_, double p_36864_) {
        super((EntityType)TTEntityRegistry.BAMBOO_SPEAR.get(), p_36862_, p_36863_, p_36864_, p_36861_);
    }

    public BambooSpear(Level p_37569_, LivingEntity p_37570_, ItemStack p_37571_) {
        super((EntityType)TTEntityRegistry.BAMBOO_SPEAR.get(), p_37570_, p_37569_);
        this.tridentItem = p_37571_.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)BambooSpear.getLoyalty(p_37571_)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)p_37571_.m_41790_());
    }

    public static int getLoyalty(ItemStack p_44929_) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)TTEnchantmentRegistry.RETURNING.get()), (ItemStack)p_44929_);
    }

    public void setEffectsFromItem(ItemStack p_36879_) {
        if (p_36879_.m_150930_((Item)TTItemRegistry.TIPPED_BAMBOO_SPEAR.get())) {
            int i;
            this.potion = PotionUtils.m_43579_((ItemStack)p_36879_);
            List collection = PotionUtils.m_43571_((ItemStack)p_36879_);
            if (!collection.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : collection) {
                    this.effects.add(new MobEffectInstance(mobeffectinstance));
                }
            }
            if ((i = BambooSpear.getCustomColor(p_36879_)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (p_36879_.m_150930_((Item)TTItemRegistry.TIPPED_BAMBOO_SPEAR.get())) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack p_36885_) {
        CompoundTag compoundtag = p_36885_.m_41783_();
        return compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99) ? compoundtag.m_128451_("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance p_36871_) {
        this.effects.add(p_36871_);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    private void makeParticle(int p_36877_) {
        int i = this.getColor();
        if (i != -1 && p_36877_ > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < p_36877_; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    private void setFixedColor(int p_36883_) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)p_36883_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (this.m_9236_().f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && !this.effects.isEmpty() && this.f_36704_ >= 600) {
            this.m_9236_().m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
        Entity entity = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.tridentItem.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.m_6351_(p_37575_, p_37576_);
    }

    protected boolean m_142470_(Player p_150196_) {
        return super.m_142470_(p_150196_) || this.m_36797_() && this.m_150171_((Entity)p_150196_) && p_150196_.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player p_37580_) {
        if (this.m_150171_((Entity)p_37580_) || this.m_19749_() == null) {
            super.m_6123_(p_37580_);
        }
    }

    public void m_7378_(CompoundTag p_37578_) {
        super.m_7378_(p_37578_);
        if (p_37578_.m_128425_("Spear", 10)) {
            this.tridentItem = ItemStack.m_41712_((CompoundTag)p_37578_.m_128469_("Spear"));
        }
        this.dealtDamage = p_37578_.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.tridentItem)));
        if (p_37578_.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)p_37578_);
        }
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)p_37578_)) {
            this.addEffect(mobeffectinstance);
        }
        if (p_37578_.m_128425_("Color", 99)) {
            this.setFixedColor(p_37578_.m_128451_("Color"));
        } else {
            this.updateColor();
        }
    }

    public void m_7380_(CompoundTag p_37582_) {
        super.m_7380_(p_37582_);
        p_37582_.m_128365_("Spear", (Tag)this.tridentItem.m_41739_(new CompoundTag()));
        p_37582_.m_128379_("DealtDamage", this.dealtDamage);
        if (this.potion != Potions.f_43598_) {
            p_37582_.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            p_37582_.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            p_37582_.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    public void m_7822_(byte p_36869_) {
        if (p_36869_ == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(p_36869_);
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    protected void m_5790_(EntityHitResult p_36757_) {
        Entity entity = p_36757_.m_82443_();
        Player player = (Player)this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (MobEffectInstance mobeffectinstance : this.potion.m_43488_()) {
                livingEntity.m_147207_(new MobEffectInstance(mobeffectinstance.m_19544_(), Math.max(mobeffectinstance.m_267696_(p_268168_ -> p_268168_ / 8), 1), mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), entity);
            }
            if (!this.effects.isEmpty()) {
                for (MobEffectInstance mobeffectinstance1 : this.effects) {
                    livingEntity.m_147207_(mobeffectinstance1, entity);
                    livingEntity.m_6469_(this.m_269291_().m_269075_(player), 8.0f);
                }
            }
        }
        float f = 5.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.tridentItem, (MobType)livingentity.m_6336_());
        }
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269298_(TTDamageTypes.BAMBOO_SPEAR, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        this.m_5496_(soundevent, f1, 1.0f);
    }
}

