/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTBlockRegistry;
import com.belgieyt.trailsandtalesplus.Objects.blocks.CopperButtonBlock;
import com.belgieyt.trailsandtalesplus.TTConfigs;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class CopperGolemEntity
extends AbstractGolem
implements VariantHolder<Type> {
    protected static final EntityDataAccessor<Integer> OXIDIZED_DATA = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> WAXED_DATA = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static int ButtonPressedCooldown;
    public AnimationState PressAnimationState = new AnimationState();
    public AnimationState IdleAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID;

    public CopperGolemEntity(EntityType<? extends CopperGolemEntity> p_28834_, Level p_28835_) {
        super(p_28834_, p_28835_);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerButtonGoal();
    }

    protected void registerButtonGoal() {
        if (this.getVariant() == Type.CELESTINE) {
            this.f_21345_.m_25352_(1, (Goal)new PushingMyCelestineButtonGoal(this));
        } else if (this.getVariant() == Type.COPPER) {
            this.f_21345_.m_25352_(1, (Goal)new PushingMyCopperButtonGoal(this));
        }
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 0.7f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OXIDIZED_DATA, (Object)0);
        this.f_19804_.m_135372_(WAXED_DATA, (Object)false);
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    public void setOxidizationStage(int stage) {
        this.f_19804_.m_135381_(OXIDIZED_DATA, (Object)stage);
    }

    public int getOxidizationStage() {
        return (Integer)this.f_19804_.m_135370_(OXIDIZED_DATA);
    }

    public Type getVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_TYPE_ID));
    }

    public void setVariant(Type p_28465_) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)p_28465_.getId());
    }

    public void setWaxed(boolean iswaxed) {
        this.f_19804_.m_135381_(WAXED_DATA, (Object)iswaxed);
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(WAXED_DATA);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected int m_7302_(int p_28882_) {
        return p_28882_;
    }

    public void m_8119_() {
        if (ButtonPressedCooldown != 0) {
            --ButtonPressedCooldown;
        }
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.getVariant() != Type.CELESTINE && !this.isWaxed() && this.f_19797_ % (int)Math.max(35.0 * Math.sqrt(this.m_9236_().m_46469_().m_46215_(GameRules.f_46143_)) / 3.0, 1.0) == 0 && (double)this.f_19796_.m_188501_() < 0.01) {
                this.IncreaseOxidizedStage();
            }
            if (this.getVariant() == Type.COPPER) {
                if (this.getOxidizationStage() == 3) {
                    this.SetStatue();
                } else {
                    this.SetMobile();
                }
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.IdleAnimationState.m_246184_(this.m_20096_() && this.getOxidizationStage() != 3 && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (!((Boolean)TTConfigs.CAN_COPPER_GOLEM_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
    }

    public void m_8107_() {
        BlockState state;
        if (this.getOxidizationStage() != 3 && ButtonPressedCooldown == 0 && this.getVariant() != Type.CELESTINE) {
            state = this.m_9236_().m_8055_(this.m_20183_());
            if (this.m_9236_().m_8055_(this.m_20183_()).m_60734_() instanceof CopperButtonBlock) {
                ((CopperButtonBlock)state.m_60734_()).press(state, this.m_9236_(), this.m_20183_());
                ButtonPressedCooldown = 2500;
                this.m_9236_().m_7605_((Entity)this, (byte)66);
            }
        }
        if (ButtonPressedCooldown == 0 && this.getVariant() == Type.CELESTINE) {
            state = this.m_9236_().m_8055_(this.m_20183_());
            if (this.m_9236_().m_8055_(this.m_20183_()).m_60713_((Block)TTBlockRegistry.CELESTINE_BUTTON.get())) {
                ((ButtonBlock)state.m_60734_()).m_51116_(state, this.m_9236_(), this.m_20183_());
                ButtonPressedCooldown = 2500;
                this.m_9236_().m_7605_((Entity)this, (byte)66);
            }
        }
        super.m_8107_();
    }

    public boolean m_5843_() {
        return this.getOxidizationStage() != 3 && this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0;
    }

    public void m_7380_(CompoundTag p_28867_) {
        super.m_7380_(p_28867_);
        p_28867_.m_128405_("Oxidized", this.getOxidizationStage());
        p_28867_.m_128379_("Waxed", this.isWaxed());
        p_28867_.m_128359_("Type", this.getVariant().m_7912_());
    }

    public void m_7378_(CompoundTag p_28857_) {
        super.m_7378_(p_28857_);
        this.setOxidizationStage(p_28857_.m_128445_("Oxidized"));
        this.setWaxed(p_28857_.m_128471_("Waxed"));
        this.setVariant(Type.byName(p_28857_.m_128461_("Type")));
    }

    protected SoundEvent m_7975_(DamageSource p_28872_) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    public void m_8038_(ServerLevel p_19927_, LightningBolt p_19928_) {
        this.RemoveOxidizedStage();
        super.m_8038_(p_19927_, p_19928_);
    }

    public void IncreaseOxidizedStage() {
        if (this.getOxidizationStage() < 3) {
            this.setOxidizationStage(this.getOxidizationStage() + 1);
        }
    }

    public void SetStatue() {
        this.m_21557_(true);
        this.m_21573_().m_26517_(0.0);
        this.m_21573_().m_26573_();
        this.m_21566_().m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0);
        this.m_21566_().m_8126_();
    }

    public void SetMobile() {
        this.m_21557_(false);
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ == 66) {
            this.PressAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(p_219360_);
        }
    }

    protected void m_7625_(DamageSource p_21021_, boolean p_21022_) {
        ResourceLocation resourcelocation = new ResourceLocation("trailsandtalesplus", "entities/copper_golem");
        ResourceLocation resourcelocation1 = new ResourceLocation("trailsandtalesplus", "entities/celestine_golem");
        if (this.getVariant() == Type.CELESTINE) {
            LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(resourcelocation1);
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)p_21021_).m_287289_(LootContextParams.f_81458_, (Object)p_21021_.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)p_21021_.m_7640_());
            if (p_21022_ && this.f_20888_ != null) {
                lootparams$builder = lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
            }
            LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
            loottable.m_287276_(lootparams, this.m_287233_(), arg_0 -> ((CopperGolemEntity)this).m_19983_(arg_0));
        } else if (this.getVariant() == Type.COPPER) {
            LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(resourcelocation);
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)p_21021_).m_287289_(LootContextParams.f_81458_, (Object)p_21021_.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)p_21021_.m_7640_());
            if (p_21022_ && this.f_20888_ != null) {
                lootparams$builder = lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
            }
            LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
            loottable.m_287276_(lootparams, this.m_287233_(), arg_0 -> ((CopperGolemEntity)this).m_19983_(arg_0));
        }
    }

    public void RemoveOxidizedStage() {
        this.setOxidizationStage(this.getOxidizationStage() - 1);
    }

    public InteractionResult m_6071_(Player p_28298_, InteractionHand p_28299_) {
        ItemStack itemstack = p_28298_.m_21120_(p_28299_);
        if (itemstack.m_150930_(Items.f_42784_) && !this.m_6162_() && !this.isWaxed() && this.getVariant() != Type.CELESTINE) {
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            this.m_5496_(SoundEvents.f_144178_, 1.0f, f1);
            p_28298_.m_9236_().m_5898_(p_28298_, 3003, this.m_20183_(), 0);
            this.setWaxed(true);
            if (!p_28298_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_204117_(ItemTags.f_271207_) && !this.m_6162_() && this.getOxidizationStage() > 0 && !this.isWaxed() && this.getVariant() != Type.CELESTINE) {
            p_28298_.m_9236_().m_5594_(p_28298_, this.m_20183_(), SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_28298_.m_9236_().m_5898_(p_28298_, 3005, this.m_20183_(), 0);
            this.RemoveOxidizedStage();
            if (!p_28298_.m_150110_().f_35937_) {
                itemstack.m_41622_(1, (LivingEntity)p_28298_, p_150686_ -> p_150686_.m_21190_(p_28299_));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_204117_(ItemTags.f_271207_) && !this.m_6162_() && this.isWaxed() && this.getVariant() != Type.CELESTINE) {
            p_28298_.m_9236_().m_5594_(p_28298_, this.m_20183_(), SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_28298_.m_9236_().m_5898_(p_28298_, 3004, this.m_20183_(), 0);
            this.setWaxed(false);
            if (!p_28298_.m_150110_().f_35937_) {
                itemstack.m_41622_(1, (LivingEntity)p_28298_, p_150686_ -> p_150686_.m_21190_(p_28299_));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_(((Block)TTBlockRegistry.CELESTINE_ALLOY_BLOCK.get()).m_5456_()) && !this.m_6162_() && this.getVariant() != Type.CELESTINE) {
            this.setVariant(Type.CELESTINE);
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            this.m_5496_(SoundEvents.f_144119_, 1.0f, f1);
            if (!p_28298_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_28298_, p_28299_);
    }

    protected void m_7355_(BlockPos p_28864_, BlockState p_28865_) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.875f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    static {
        DATA_TYPE_ID = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    public static enum Type implements StringRepresentable
    {
        COPPER(0, "copper"),
        CELESTINE(1, "celestine");

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final int id;
        private final String name;

        private Type(int p_196658_, String p_196659_) {
            this.id = p_196658_;
            this.name = p_196659_;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Type byName(String p_28817_) {
            return (Type)CODEC.m_262792_(p_28817_, (Enum)COPPER);
        }

        public static Type byId(int p_28813_) {
            return BY_ID.apply(p_28813_);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    static class PushingMyCelestineButtonGoal
    extends MoveToBlockGoal {
        CopperGolemEntity entity;

        public PushingMyCelestineButtonGoal(CopperGolemEntity copper) {
            super((PathfinderMob)copper, 0.5, 64);
            this.entity = copper;
        }

        protected int m_6099_(PathfinderMob mob) {
            return 100 + mob.m_217043_().m_188503_(200);
        }

        public boolean m_8036_() {
            return super.m_8036_() && ((CopperGolemEntity)this.f_25598_).getVariant() == Type.CELESTINE;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.f_25600_ == 0 && ((CopperGolemEntity)this.f_25598_).getVariant() == Type.CELESTINE;
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            BlockState blockState = world.m_8055_(pos);
            return blockState.m_60713_((Block)TTBlockRegistry.CELESTINE_BUTTON.get());
        }
    }

    static class PushingMyCopperButtonGoal
    extends MoveToBlockGoal {
        CopperGolemEntity entity;

        public PushingMyCopperButtonGoal(CopperGolemEntity copper) {
            super((PathfinderMob)copper, 0.5, 64);
            this.entity = copper;
        }

        protected int m_6099_(PathfinderMob mob) {
            return 100 + mob.m_217043_().m_188503_(200);
        }

        public boolean m_8036_() {
            return super.m_8036_() && ((CopperGolemEntity)this.f_25598_).getOxidizationStage() < 3 && ((CopperGolemEntity)this.f_25598_).getVariant() != Type.CELESTINE;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.f_25600_ == 0 && ((CopperGolemEntity)this.f_25598_).getOxidizationStage() < 3 && ((CopperGolemEntity)this.f_25598_).getVariant() != Type.CELESTINE;
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            BlockState blockState = world.m_8055_(pos);
            return blockState.m_60734_() instanceof CopperButtonBlock;
        }
    }
}

