/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.entity.ai.EchoidAI;
import com.belgieyt.trailsandtalesplus.Objects.entity.ai.WitherBoom;
import com.belgieyt.trailsandtalesplus.TTConfigs;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class EchoidEntity
extends Monster
implements VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int VIBRATION_COOLDOWN_TICKS = 40;
    private static final int TIME_TO_USE_MELEE_UNTIL_SONIC_BOOM = 200;
    private static final int MAX_HEALTH = 350;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    private static final float KNOCKBACK_RESISTANCE = 1.0f;
    private static final float ATTACK_KNOCKBACK = 1.5f;
    private static final int ATTACK_DAMAGE = 30;
    private static final EntityDataAccessor<Integer> CLIENT_ANGER_LEVEL = SynchedEntityData.m_135353_(EchoidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int DARKNESS_DISPLAY_LIMIT = 200;
    private static final int DARKNESS_DURATION = 260;
    private static final int DARKNESS_RADIUS = 20;
    private static final int DARKNESS_INTERVAL = 120;
    private static final int ANGERMANAGEMENT_TICK_DELAY = 20;
    private static final int DEFAULT_ANGER = 35;
    private static final int PROJECTILE_ANGER = 10;
    private static final int ON_HURT_ANGER_BOOST = 20;
    private static final int RECENT_PROJECTILE_TICK_THRESHOLD = 100;
    private static final int TOUCH_COOLDOWN_TICKS = 20;
    private static final int DIGGING_PARTICLES_AMOUNT = 30;
    private static final float DIGGING_PARTICLES_DURATION = 4.5f;
    private static final float DIGGING_PARTICLES_OFFSET = 0.7f;
    private static final int PROJECTILE_ANGER_DISTANCE = 30;
    private int tendrilAnimation;
    private int tendrilAnimationO;
    private int heartAnimation;
    private int heartAnimationO;
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState sniffAnimationState = new AnimationState();
    public AnimationState emergeAnimationState = new AnimationState();
    public AnimationState diggingAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState sonicBoomAnimationState = new AnimationState();
    public AnimationState stunAnimationState = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener;
    private final VibrationSystem.User vibrationUser;
    private VibrationSystem.Data vibrationData;
    AngerManagement angerManagement = new AngerManagement(this::canTargetEntity, Collections.emptyList());
    private int stunnedTick;

    public EchoidEntity(EntityType<? extends Monster> p_219350_, Level p_219351_) {
        super(p_219350_, p_219351_);
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new VibrationSystem.Data();
        this.dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
        this.f_21364_ = 5;
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.m_217003_(Pose.EMERGING) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_219420_) {
        super.m_141965_(p_219420_);
        if (p_219420_.m_131509_() == 1) {
            this.m_20124_(Pose.EMERGING);
        }
    }

    public boolean m_6914_(LevelReader p_219398_) {
        return super.m_6914_(p_219398_) && p_219398_.m_45756_((Entity)this, this.m_6095_().m_20680_().m_20393_(this.m_20182_()));
    }

    public float m_5610_(BlockPos p_219410_, LevelReader p_219411_) {
        return 0.0f;
    }

    public boolean m_6673_(DamageSource p_219427_) {
        return this.isDiggingOrEmerging() && !p_219427_.m_269533_(DamageTypeTags.f_268738_) ? true : super.m_6673_(p_219427_);
    }

    boolean isDiggingOrEmerging() {
        return this.m_217003_(Pose.DIGGING) || this.m_217003_(Pose.EMERGING);
    }

    protected boolean m_7341_(Entity p_219462_) {
        return false;
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.55f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 350.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22281_, 20.0);
    }

    public boolean m_213854_() {
        return true;
    }

    public float m_6100_() {
        return -10.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return !this.m_217003_(Pose.ROARING) && !this.isDiggingOrEmerging() ? this.getAngerLevel().m_219234_() : null;
    }

    protected SoundEvent m_7975_(DamageSource p_219440_) {
        return SoundEvents.f_215763_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215779_;
    }

    protected void m_7355_(BlockPos p_219431_, BlockState p_219432_) {
        this.m_5496_(SoundEvents.f_215773_, 10.0f, 1.0f);
    }

    public boolean m_7327_(Entity p_219472_) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_215778_, 10.0f, this.m_6100_());
        WitherBoom.setCooldown((LivingEntity)this, 40);
        return super.m_7327_(p_219472_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIENT_ANGER_LEVEL, (Object)0);
    }

    public int getClientAngerLevel() {
        return (Integer)this.f_19804_.m_135370_(CLIENT_ANGER_LEVEL);
    }

    private void syncClientAngerLevel() {
        this.f_19804_.m_135381_(CLIENT_ANGER_LEVEL, (Object)this.getActiveAnger());
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            VibrationSystem.Ticker.m_280259_((Level)serverlevel, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
            if (this.m_21532_() || this.m_8023_()) {
                EchoidAI.setDigCooldown((LivingEntity)this);
            }
        }
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.f_19797_ % this.getHeartBeatDelay() == 0) {
                this.heartAnimation = 10;
                if (!this.m_20067_()) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215762_, this.m_5720_(), 5.0f, this.m_6100_(), false);
                }
            }
            this.tendrilAnimationO = this.tendrilAnimation;
            if (this.tendrilAnimation > 0) {
                --this.tendrilAnimation;
            }
            this.heartAnimationO = this.heartAnimation;
            if (this.heartAnimation > 0) {
                --this.heartAnimation;
            }
            switch (this.m_20089_()) {
                case EMERGING: {
                    this.clientDiggingParticles(this.emergeAnimationState);
                    break;
                }
                case DIGGING: {
                    this.clientDiggingParticles(this.diggingAnimationState);
                }
            }
        }
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
            this.stunEffect();
            this.stunAnimationState.m_216982_(this.f_19797_);
            if (this.stunnedTick == 0) {
                this.m_5496_(SoundEvents.f_12363_, 1.0f, 1.0f);
                this.stunAnimationState.m_216973_();
            }
        }
        if (!((Boolean)TTConfigs.CAN_ECHOID_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d0 = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double d1 = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double d2 = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    protected void m_6731_(LivingEntity p_33361_) {
        if (this.f_19796_.m_188500_() < 0.5) {
            this.stunnedTick = 40;
            this.m_5496_(SoundEvents.f_12362_, 1.0f, 1.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)39);
            p_33361_.m_7334_((Entity)this);
        }
        p_33361_.f_19864_ = true;
    }

    public int getStunnedTick() {
        return this.stunnedTick;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.stunnedTick > 0;
    }

    protected void m_8024_() {
        ServerLevel serverlevel = (ServerLevel)this.m_9236_();
        serverlevel.m_46473_().m_6180_("echoidBrain");
        this.m_6274_().m_21865_(serverlevel, (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
        if ((this.f_19797_ + this.m_19879_()) % 120 == 0) {
            EchoidEntity.applyDarknessAround(serverlevel, this.m_20182_(), (Entity)this, 20);
        }
        if (this.f_19797_ % 20 == 0) {
            this.angerManagement.m_219263_(serverlevel, this::canTargetEntity);
            this.syncClientAngerLevel();
        }
        EchoidAI.updateActivity(this);
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ == 4) {
            this.roarAnimationState.m_216973_();
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (p_219360_ == 61) {
            this.tendrilAnimation = 10;
        } else if (p_219360_ == 62) {
            this.sonicBoomAnimationState.m_216977_(this.f_19797_);
        } else if (p_219360_ == 39) {
            this.stunnedTick = 40;
        } else {
            super.m_7822_(p_219360_);
        }
    }

    private int getHeartBeatDelay() {
        float f = (float)this.getClientAngerLevel() / (float)AngerLevel.ANGRY.m_219226_();
        return 40 - Mth.m_14143_((float)(Mth.m_14036_((float)f, (float)0.0f, (float)1.0f) * 30.0f));
    }

    public float getTendrilAnimation(float p_219468_) {
        return Mth.m_14179_((float)p_219468_, (float)this.tendrilAnimationO, (float)this.tendrilAnimation) / 10.0f;
    }

    public float getHeartAnimation(float p_219470_) {
        return Mth.m_14179_((float)p_219470_, (float)this.heartAnimationO, (float)this.heartAnimation) / 10.0f;
    }

    private void clientDiggingParticles(AnimationState p_219384_) {
        if ((float)p_219384_.m_216981_() < 4500.0f) {
            RandomSource randomsource = this.m_217043_();
            BlockState blockstate = this.m_20075_();
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    double d0 = this.m_20185_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    double d1 = this.m_20186_();
                    double d2 = this.m_20189_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (f_19806_.equals(p_219422_)) {
            switch (this.m_20089_()) {
                case EMERGING: {
                    this.emergeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case DIGGING: {
                    this.diggingAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case ROARING: {
                    this.roarAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case SNIFFING: {
                    this.sniffAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public boolean m_6128_() {
        return this.isDiggingOrEmerging();
    }

    protected Brain<?> m_8075_(Dynamic<?> p_219406_) {
        return EchoidAI.makeBrain(this, p_219406_);
    }

    public Brain<EchoidEntity> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> p_219413_) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            p_219413_.accept(this.dynamicGameEventListener, serverlevel);
        }
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity p_219386_) {
        if (p_219386_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_219386_;
            if (this.m_9236_() == p_219386_.m_9236_() && EntitySelector.f_20406_.test(p_219386_) && !this.m_7307_(p_219386_) && livingentity.m_6095_() != EntityType.f_20529_ && livingentity.m_6095_() != EntityType.f_217015_ && livingentity.m_6095_() != TTEntityRegistry.ECHOID.get() && !livingentity.m_20147_() && !livingentity.m_21224_() && this.m_9236_().m_6857_().m_61935_(livingentity.m_20191_())) {
                return true;
            }
        }
        return false;
    }

    public static void applyDarknessAround(ServerLevel p_219376_, Vec3 p_219377_, @Nullable Entity p_219378_, int p_219379_) {
        MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_216964_, 260, 0, false, false);
        MobEffectUtil.m_216946_((ServerLevel)p_219376_, (Entity)p_219378_, (Vec3)p_219377_, (double)p_219379_, (MobEffectInstance)mobeffectinstance, (int)200);
    }

    public void m_7380_(CompoundTag p_219434_) {
        super.m_7380_(p_219434_);
        AngerManagement.m_219277_(this::canTargetEntity).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.angerManagement).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219437_ -> p_219434_.m_128365_("anger", p_219437_));
        VibrationSystem.Data.f_279637_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219418_ -> p_219434_.m_128365_("listener", p_219418_));
        p_219434_.m_128405_("StunTick", this.stunnedTick);
    }

    public void m_7378_(CompoundTag p_219415_) {
        super.m_7378_(p_219415_);
        if (p_219415_.m_128441_("anger")) {
            AngerManagement.m_219277_(this::canTargetEntity).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_219415_.m_128423_("anger"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219394_ -> {
                this.angerManagement = p_219394_;
            });
            this.syncClientAngerLevel();
        }
        if (p_219415_.m_128425_("listener", 10)) {
            VibrationSystem.Data.f_279637_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_219415_.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_281093_ -> {
                this.vibrationData = p_281093_;
            });
        }
        this.stunnedTick = p_219415_.m_128451_("StunTick");
    }

    private void playListeningSound() {
        if (!this.m_217003_(Pose.ROARING)) {
            this.m_5496_(this.getAngerLevel().m_219235_(), 10.0f, this.m_6100_());
        }
    }

    public AngerLevel getAngerLevel() {
        return AngerLevel.m_219227_((int)this.getActiveAnger());
    }

    private int getActiveAnger() {
        return this.angerManagement.m_219286_((Entity)this.m_5448_());
    }

    public void clearAnger(Entity p_219429_) {
        this.angerManagement.m_219266_(p_219429_);
    }

    public void increaseAngerAt(@Nullable Entity p_219442_) {
        this.increaseAngerAt(p_219442_, 200, true);
    }

    @VisibleForTesting
    public void increaseAngerAt(@Nullable Entity p_219388_, int p_219389_, boolean p_219390_) {
        if (!this.m_21525_() && this.canTargetEntity(p_219388_)) {
            EchoidAI.setDigCooldown((LivingEntity)this);
            boolean flag = !(this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null) instanceof Player);
            int i = this.angerManagement.m_219268_(p_219388_, p_219389_);
            if (p_219388_ instanceof Player && flag && AngerLevel.m_219227_((int)i).m_219236_()) {
                this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
            }
            if (p_219390_) {
                this.playListeningSound();
            }
        }
    }

    public Optional<LivingEntity> getEntityAngryAt() {
        return this.getAngerLevel().m_219236_() ? this.angerManagement.m_219256_() : Optional.empty();
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public boolean m_6785_(double p_219457_) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_219400_, DifficultyInstance p_219401_, MobSpawnType p_219402_, @Nullable SpawnGroupData p_219403_, @Nullable CompoundTag p_219404_) {
        this.m_6274_().m_21882_(MemoryModuleType.f_217770_, (Object)Unit.INSTANCE, 1200L);
        if (p_219402_ == MobSpawnType.TRIGGERED) {
            this.m_20124_(Pose.EMERGING);
            this.m_6274_().m_21882_(MemoryModuleType.f_217786_, (Object)Unit.INSTANCE, (long)EchoidAI.EMERGE_DURATION);
            this.m_5496_(SoundEvents.f_215775_, 5.0f, 1.0f);
        }
        return super.m_6518_(p_219400_, p_219401_, p_219402_, p_219403_, p_219404_);
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 1.9f;
    }

    public boolean m_6469_(DamageSource p_219381_, float p_219382_) {
        boolean flag = super.m_6469_(p_219381_, p_219382_);
        if (!(this.m_9236_().f_46443_ || this.m_21525_() || this.isDiggingOrEmerging())) {
            Entity entity = p_219381_.m_7639_();
            this.increaseAngerAt(entity, AngerLevel.ANGRY.m_219226_() + 80, false);
            if (this.f_20939_.m_21952_(MemoryModuleType.f_26372_).isEmpty() && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!p_219381_.m_269014_() || this.m_19950_((Entity)livingentity, 5.0)) {
                    this.setAttackTarget(livingentity);
                }
            }
        }
        return flag;
    }

    public void setAttackTarget(LivingEntity p_219460_) {
        this.m_6274_().m_21936_(MemoryModuleType.f_217782_);
        this.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)p_219460_);
        this.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        WitherBoom.setCooldown((LivingEntity)this, 200);
    }

    public EntityDimensions m_6972_(Pose p_219392_) {
        EntityDimensions entitydimensions = super.m_6972_(p_219392_);
        return this.isDiggingOrEmerging() ? EntityDimensions.m_20398_((float)entitydimensions.f_20377_, (float)1.0f) : entitydimensions;
    }

    public boolean m_6094_() {
        return !this.isDiggingOrEmerging() && super.m_6094_();
    }

    protected void m_7324_(Entity p_219353_) {
        if (!this.m_21525_() && !this.m_6274_().m_21874_(MemoryModuleType.f_217773_)) {
            this.m_6274_().m_21882_(MemoryModuleType.f_217773_, (Object)Unit.INSTANCE, 20L);
            this.increaseAngerAt(p_219353_);
            EchoidAI.setDisturbanceLocation(this, p_219353_.m_20183_());
        }
        super.m_7324_(p_219353_);
    }

    @VisibleForTesting
    public AngerManagement getAngerManagement() {
        return this.angerManagement;
    }

    protected PathNavigation m_6037_(Level p_219396_) {
        return new GroundPathNavigation((Mob)this, p_219396_){

            protected PathFinder m_5532_(int p_219479_) {
                this.f_26508_ = new WalkNodeEvaluator();
                this.f_26508_.m_77351_(true);
                return new PathFinder(this.f_26508_, p_219479_){

                    protected float m_214208_(Node p_219486_, Node p_219487_) {
                        return p_219486_.m_230613_(p_219487_);
                    }
                };
            }
        };
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    class VibrationUser
    implements VibrationSystem.User {
        private static final int GAME_EVENT_LISTENER_RANGE = 16;
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)EchoidEntity.this, EchoidEntity.this.m_20192_());
        }

        public int m_280351_() {
            return 16;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215853_;
        }

        public boolean m_280076_() {
            return true;
        }

        public boolean m_280080_(ServerLevel p_282574_, BlockPos p_282323_, GameEvent p_283003_, GameEvent.Context p_282515_) {
            if (!(EchoidEntity.this.m_21525_() || EchoidEntity.this.m_21224_() || EchoidEntity.this.m_6274_().m_21874_(MemoryModuleType.f_217774_) || EchoidEntity.this.isDiggingOrEmerging() || !p_282574_.m_6857_().m_61937_(p_282323_))) {
                LivingEntity livingentity;
                Entity entity = p_282515_.f_223711_();
                return !(entity instanceof LivingEntity) || EchoidEntity.this.canTargetEntity((Entity)(livingentity = (LivingEntity)entity));
            }
            return false;
        }

        public void m_280271_(ServerLevel p_281325_, BlockPos p_282386_, GameEvent p_282261_, @Nullable Entity p_281438_, @Nullable Entity p_282582_, float p_283699_) {
            if (!EchoidEntity.this.m_21224_()) {
                EchoidEntity.this.f_20939_.m_21882_(MemoryModuleType.f_217774_, (Object)Unit.INSTANCE, 40L);
                p_281325_.m_7605_((Entity)EchoidEntity.this, (byte)61);
                EchoidEntity.this.m_5496_(SoundEvents.f_215774_, 5.0f, EchoidEntity.this.m_6100_());
                BlockPos blockpos = p_282386_;
                if (p_282582_ != null) {
                    if (EchoidEntity.this.m_19950_(p_282582_, 30.0)) {
                        if (EchoidEntity.this.m_6274_().m_21874_(MemoryModuleType.f_217784_)) {
                            if (EchoidEntity.this.canTargetEntity(p_282582_)) {
                                blockpos = p_282582_.m_20183_();
                            }
                            EchoidEntity.this.increaseAngerAt(p_282582_);
                        } else {
                            EchoidEntity.this.increaseAngerAt(p_282582_, 80, true);
                        }
                    }
                    EchoidEntity.this.m_6274_().m_21882_(MemoryModuleType.f_217784_, (Object)Unit.INSTANCE, 100L);
                } else {
                    EchoidEntity.this.increaseAngerAt(p_281438_);
                }
                if (!EchoidEntity.this.getAngerLevel().m_219236_()) {
                    Optional optional = EchoidEntity.this.angerManagement.m_219256_();
                    if (p_282582_ != null || optional.isEmpty() || optional.get() == p_281438_) {
                        EchoidAI.setDisturbanceLocation(EchoidEntity.this, blockpos);
                    }
                }
            }
        }
    }
}

