/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTSoundsRegistry;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class FloatingIceBlockEntity
extends Entity {
    private static final String OWNER_UUID = "Iceologer";
    private static final String TARGET_UUID = "Target";
    private static final String TICKS_UNTIL_FALL_NBT_NAME = "FallTicks";
    private static final String IDLE_TICKS_NBT_NAME = "StillTicks";
    private static final int MIN_FLYING_TICKS = 25;
    private static final int MAX_FLYING_TICKS = 50;
    private static final int MIN_IDLE_TICKS = 10;
    private static final int MAX_IDLE_TICKS = 20;
    private static final int SUMMON_TICKS = 30;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID_DATA = SynchedEntityData.m_135353_(FloatingIceBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> TARGET_UUID_DATA = SynchedEntityData.m_135353_(FloatingIceBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_FALL = SynchedEntityData.m_135353_(FloatingIceBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> IDLE_TICKS = SynchedEntityData.m_135353_(FloatingIceBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private LivingEntity target;
    private int lifetimeTicks;
    private float summonAnimationProgress;
    private float lastSummonAnimationProgress;

    public FloatingIceBlockEntity(LivingEntity player, Level level) {
        this((EntityType<? extends FloatingIceBlockEntity>)((EntityType)TTEntityRegistry.FLOATING_ICE.get()), level);
        this.owner = player;
    }

    public FloatingIceBlockEntity(EntityType<? extends FloatingIceBlockEntity> entityType, Level level) {
        super(entityType, level);
        this.m_20331_(true);
        this.m_20242_(true);
        this.lifetimeTicks = 0;
        this.summonAnimationProgress = 0.0f;
        this.lastSummonAnimationProgress = 0.0f;
    }

    public boolean isFoil() {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID_DATA, Optional.empty());
        this.f_19804_.m_135372_(TARGET_UUID_DATA, Optional.empty());
        this.f_19804_.m_135372_(TICKS_UNTIL_FALL, (Object)RandomSource.m_216327_().m_216339_(25, 50));
        this.f_19804_.m_135372_(IDLE_TICKS, (Object)RandomSource.m_216327_().m_216339_(10, 20));
    }

    protected void m_7378_(CompoundTag p_20052_) {
        if (p_20052_.m_128403_(OWNER_UUID)) {
            this.setOwnerUuid(p_20052_.m_128342_(OWNER_UUID));
        }
        if (p_20052_.m_128403_(TARGET_UUID)) {
            this.setTargetUuid(p_20052_.m_128342_(TARGET_UUID));
        }
        if (p_20052_.m_128441_(TICKS_UNTIL_FALL_NBT_NAME)) {
            this.setTicksUntilFall(p_20052_.m_128451_(TICKS_UNTIL_FALL_NBT_NAME));
        }
        if (p_20052_.m_128441_(IDLE_TICKS_NBT_NAME)) {
            this.setIdleTicks(p_20052_.m_128451_(IDLE_TICKS_NBT_NAME));
        }
    }

    protected void m_7380_(CompoundTag p_20139_) {
        if (this.getOwnerUuid() != null) {
            p_20139_.m_128362_(OWNER_UUID, this.getOwnerUuid());
        }
        if (this.getTargetUuid() != null) {
            p_20139_.m_128362_(TARGET_UUID, this.getTargetUuid());
        }
        p_20139_.m_128405_(TICKS_UNTIL_FALL_NBT_NAME, this.getTicksUntilFall());
        p_20139_.m_128405_(IDLE_TICKS_NBT_NAME, this.getIdleTicks());
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID_DATA)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID_DATA, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.getOwnerUuid() != null && !this.m_9236_().m_5776_() && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.getOwnerUuid())) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    @Nullable
    public UUID getTargetUuid() {
        return ((Optional)this.f_19804_.m_135370_(TARGET_UUID_DATA)).orElse(null);
    }

    public void setTargetUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(TARGET_UUID_DATA, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getTarget() {
        Entity entity;
        if (this.target == null && this.getTargetUuid() != null && !this.m_9236_().m_5776_() && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.getTargetUuid())) instanceof LivingEntity) {
            this.target = (LivingEntity)entity;
        }
        return this.target;
    }

    public void m_8119_() {
        if (this.lifetimeTicks == 10 || this.lifetimeTicks == 40) {
            // empty if block
        }
        ++this.lifetimeTicks;
        this.setSummonAnimationProgress();
        if (this.getTarget() != null && !this.m_9236_().m_5776_()) {
            Player player;
            LivingEntity livingEntity = this.getTarget();
            if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_5833_() || player.m_7500_())) {
                this.customDiscard();
                return;
            }
            if (this.getTicksUntilFall() > 0) {
                this.moveTowardsTarget();
            }
        }
        if (this.getTicksUntilFall() > 0) {
            this.setTicksUntilFall(this.getTicksUntilFall() - 1);
            return;
        }
        this.m_20334_(0.0, -0.1f, 0.0);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.f_19863_) {
            this.damageHitEntities();
            this.m_5496_((SoundEvent)TTSoundsRegistry.FLOATING_ICE_BREAK.get(), 1.0f, 1.0f);
            this.customDiscard();
        }
    }

    public int getTicksUntilFall() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_FALL);
    }

    private void setTicksUntilFall(int ticksUntilFall) {
        this.f_19804_.m_135381_(TICKS_UNTIL_FALL, (Object)ticksUntilFall);
    }

    private int getIdleTicks() {
        return (Integer)this.f_19804_.m_135370_(IDLE_TICKS);
    }

    private void setIdleTicks(int idleTicks) {
        this.f_19804_.m_135381_(IDLE_TICKS, (Object)idleTicks);
    }

    private void damageHitEntities() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        List hitEntities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82363_(0.2, 0.0, 0.2));
        for (LivingEntity hitEntity : hitEntities) {
            this.damage(hitEntity);
        }
    }

    private void damage(LivingEntity hitEntity) {
        LivingEntity livingEntity = this.getOwner();
        if (!hitEntity.m_6084_() || hitEntity.m_20147_() || hitEntity == livingEntity || livingEntity != null && livingEntity.m_7307_((Entity)hitEntity)) {
            return;
        }
        hitEntity.m_6469_(this.m_269291_().m_269109_(), 10.0f);
        if (hitEntity.m_142079_()) {
            hitEntity.m_146917_(345);
        }
    }

    private void customDiscard() {
        this.spawnHitParticles();
        this.m_146870_();
    }

    public void moveTowardsTarget() {
        LivingEntity target = this.getTarget();
        if (target == null || target.m_20184_().m_82556_() < 0.001) {
            return;
        }
        this.m_6034_(target.m_20185_(), this.getYPositionWithHeightOffset(target.m_20186_(), this.getTarget().m_20206_()), target.m_20189_());
    }

    private double getYPositionWithHeightOffset(double y, double height) {
        return Math.min(y + height * height, y + 6.0);
    }

    public void spawnHitParticles() {
        this.spawnParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50568_.m_49966_()), 64);
    }

    private void spawnParticles(ParticleOptions particleEffect, int amount) {
        Level level = this.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)level).m_7106_(particleEffect, this.m_20165_(0.5), this.m_20186_() + 0.5, this.m_20246_(0.5), 5.0, 5.0, 5.0);
        }
    }

    public float getSummonAnimationProgress() {
        return this.summonAnimationProgress;
    }

    public void setSummonAnimationProgress() {
        this.lastSummonAnimationProgress = this.summonAnimationProgress;
        this.summonAnimationProgress = Math.min(1.0f, (float)this.lifetimeTicks / 30.0f);
    }

    public float getLastSummonAnimationProgress() {
        return this.lastSummonAnimationProgress;
    }

    public static FloatingIceBlockEntity createWithOwnerAndTarget(Level world, LivingEntity owner, LivingEntity target) {
        FloatingIceBlockEntity chunkEntity = new FloatingIceBlockEntity((EntityType<? extends FloatingIceBlockEntity>)((EntityType)TTEntityRegistry.FLOATING_ICE.get()), world);
        chunkEntity.setOwnerUuid(owner.m_20148_());
        chunkEntity.setTargetUuid(target.m_20148_());
        chunkEntity.m_6034_(target.m_20185_(), chunkEntity.getYPositionWithHeightOffset(target.m_20186_(), target.m_20192_() + 4.0f), target.m_20189_());
        return chunkEntity;
    }
}

