/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.TTConfigs;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class GhoulEntity
extends FlyingMob
implements Enemy {
    public static final float FLAP_DEGREES_PER_TICK = 7.448451f;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)24.166098f);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(GhoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    Vec3 moveTargetPoint = Vec3.f_82478_;
    BlockPos anchorPoint = BlockPos.f_121853_;
    AttackPhase attackPhase = AttackPhase.CIRCLE;

    public GhoulEntity(EntityType<? extends GhoulEntity> p_33101_, Level p_33102_) {
        super(p_33101_, p_33102_);
        this.f_21364_ = 5;
        this.f_21342_ = new PhantomMoveControl((Mob)this);
        this.f_21365_ = new PhantomLookControl((Mob)this);
    }

    public boolean m_142039_() {
        return (this.getUniqueFlapTickOffset() + this.f_19797_) % TICKS_PER_FLAP == 0;
    }

    protected BodyRotationControl m_7560_() {
        return new GhoulEntityBodyRotationControl((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new GhoulEntityAttackStrategyGoal());
        this.f_21345_.m_25352_(2, (Goal)new PhantomSweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new GhoulEntityCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(1, (Goal)new GhoulEntityAttackPlayerTargetGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33601_, DifficultyInstance p_33602_, MobSpawnType p_33603_, @Nullable SpawnGroupData p_33604_, @Nullable CompoundTag p_33605_) {
        RandomSource randomsource = p_33601_.m_213780_();
        int i = randomsource.m_188503_(3);
        if (i < 2 && randomsource.m_188501_() < 0.5f * p_33602_.m_19057_()) {
            ++i;
        }
        int j = 1 << i;
        this.setPhantomSize(j);
        this.anchorPoint = this.m_20183_().m_6630_(5);
        return super.m_6518_(p_33601_, p_33602_, p_33603_, p_33604_, p_33605_);
    }

    public void setPhantomSize(int p_33109_) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Mth.m_14045_((int)p_33109_, (int)0, (int)64));
    }

    private void updatePhantomSizeInfo() {
        this.m_6210_();
        this.m_21051_(Attributes.f_22281_).m_22100_((double)(6 + this.getPhantomSize()));
    }

    public int getPhantomSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    protected float m_6431_(Pose p_33136_, EntityDimensions p_33137_) {
        return p_33137_.f_20378_ * 0.35f;
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (ID_SIZE.equals(p_33134_)) {
            this.updatePhantomSizeInfo();
        }
        super.m_7350_(p_33134_);
    }

    public int getUniqueFlapTickOffset() {
        return this.m_19879_() * 3;
    }

    protected boolean m_8028_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_ + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.m_188501_() * 0.05f, 0.95f + this.f_19796_.m_188501_() * 0.05f, false);
            }
            int i = this.getPhantomSize();
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
        }
        if (!((Boolean)TTConfigs.CAN_GHOUL_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public void m_7378_(CompoundTag p_33132_) {
        super.m_7378_(p_33132_);
        if (p_33132_.m_128441_("AX")) {
            this.anchorPoint = new BlockPos(p_33132_.m_128451_("AX"), p_33132_.m_128451_("AY"), p_33132_.m_128451_("AZ"));
        }
        this.setPhantomSize(p_33132_.m_128451_("Size"));
    }

    public void m_7380_(CompoundTag p_33141_) {
        super.m_7380_(p_33141_);
        p_33141_.m_128405_("AX", this.anchorPoint.m_123341_());
        p_33141_.m_128405_("AY", this.anchorPoint.m_123342_());
        p_33141_.m_128405_("AZ", this.anchorPoint.m_123343_());
        p_33141_.m_128405_("Size", this.getPhantomSize());
    }

    public boolean m_6783_(double p_33107_) {
        return true;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12227_;
    }

    protected SoundEvent m_7975_(DamageSource p_33152_) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public float m_6100_() {
        return -5.0f;
    }

    public boolean m_6549_(EntityType<?> p_33111_) {
        return true;
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        int i = this.getPhantomSize();
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        float f = (entitydimensions.f_20377_ + 0.2f * (float)i) / entitydimensions.f_20377_;
        return entitydimensions.m_20388_(f);
    }

    public double m_6048_() {
        return this.m_20192_();
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class PhantomMoveControl
    extends MoveControl {
        private float speed;

        public PhantomMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.1f;
        }

        public void m_8126_() {
            if (GhoulEntity.this.f_19862_) {
                GhoulEntity.this.m_146922_(GhoulEntity.this.m_146908_() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = GhoulEntity.this.moveTargetPoint.f_82479_ - GhoulEntity.this.m_20185_();
            double d1 = GhoulEntity.this.moveTargetPoint.f_82480_ - GhoulEntity.this.m_20186_();
            double d2 = GhoulEntity.this.moveTargetPoint.f_82481_ - GhoulEntity.this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = GhoulEntity.this.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(GhoulEntity.this.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                GhoulEntity.this.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                GhoulEntity.this.f_20883_ = GhoulEntity.this.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)GhoulEntity.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                GhoulEntity.this.m_146926_(f4);
                float f5 = GhoulEntity.this.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = GhoulEntity.this.m_20184_();
                GhoulEntity.this.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    class PhantomLookControl
    extends LookControl {
        public PhantomLookControl(Mob p_33235_) {
            super(p_33235_);
        }

        public void m_8128_() {
        }
    }

    class GhoulEntityBodyRotationControl
    extends BodyRotationControl {
        public GhoulEntityBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void m_8121_() {
            GhoulEntity.this.f_20885_ = GhoulEntity.this.f_20883_;
            GhoulEntity.this.f_20883_ = GhoulEntity.this.m_146908_();
        }
    }

    class GhoulEntityAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        GhoulEntityAttackStrategyGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = GhoulEntity.this.m_5448_();
            return livingentity != null ? GhoulEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            GhoulEntity.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            GhoulEntity.this.anchorPoint = GhoulEntity.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, GhoulEntity.this.anchorPoint).m_6630_(10 + GhoulEntity.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (GhoulEntity.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    GhoulEntity.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + GhoulEntity.this.f_19796_.m_188503_(4)) * 20);
                    GhoulEntity.this.m_5496_(SoundEvents.f_12232_, 10.0f, 0.95f + GhoulEntity.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            GhoulEntity.this.anchorPoint = GhoulEntity.this.m_5448_().m_20183_().m_6630_(20 + GhoulEntity.this.f_19796_.m_188503_(20));
            if (GhoulEntity.this.anchorPoint.m_123342_() < GhoulEntity.this.m_9236_().m_5736_()) {
                GhoulEntity.this.anchorPoint = new BlockPos(GhoulEntity.this.anchorPoint.m_123341_(), GhoulEntity.this.m_9236_().m_5736_() + 1, GhoulEntity.this.anchorPoint.m_123343_());
            }
        }
    }

    class PhantomSweepAttackGoal
    extends PhantomMoveTargetGoal {
        private static final int CAT_SEARCH_TICK_DELAY = 20;
        private boolean isScaredOfCat;
        private int catSearchTick;

        PhantomSweepAttackGoal() {
        }

        public boolean m_8036_() {
            return GhoulEntity.this.m_5448_() != null && GhoulEntity.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = GhoulEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            if (!this.m_8036_()) {
                return false;
            }
            if (GhoulEntity.this.f_19797_ > this.catSearchTick) {
                this.catSearchTick = GhoulEntity.this.f_19797_ + 20;
                List list = GhoulEntity.this.m_9236_().m_6443_(Cat.class, GhoulEntity.this.m_20191_().m_82400_(16.0), EntitySelector.f_20402_);
                for (Cat cat : list) {
                    cat.m_28167_();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            GhoulEntity.this.m_6710_(null);
            GhoulEntity.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity livingentity = GhoulEntity.this.m_5448_();
            if (livingentity != null) {
                GhoulEntity.this.moveTargetPoint = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
                if (GhoulEntity.this.m_20191_().m_82400_((double)0.2f).m_82381_(livingentity.m_20191_())) {
                    GhoulEntity.this.m_7327_((Entity)livingentity);
                    GhoulEntity.this.attackPhase = AttackPhase.CIRCLE;
                    if (!GhoulEntity.this.m_20067_()) {
                        GhoulEntity.this.m_9236_().m_46796_(1039, GhoulEntity.this.m_20183_(), 0);
                    }
                } else if (GhoulEntity.this.f_19862_ || GhoulEntity.this.f_20916_ > 0) {
                    GhoulEntity.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class GhoulEntityCircleAroundAnchorGoal
    extends PhantomMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        GhoulEntityCircleAroundAnchorGoal() {
        }

        public boolean m_8036_() {
            return GhoulEntity.this.m_5448_() == null || GhoulEntity.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f + GhoulEntity.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + GhoulEntity.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = GhoulEntity.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (GhoulEntity.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + GhoulEntity.this.f_19796_.m_188501_() * 9.0f;
            }
            if (GhoulEntity.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (GhoulEntity.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = GhoulEntity.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (GhoulEntity.this.moveTargetPoint.f_82480_ < GhoulEntity.this.m_20186_() && !GhoulEntity.this.m_9236_().m_46859_(GhoulEntity.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (GhoulEntity.this.moveTargetPoint.f_82480_ > GhoulEntity.this.m_20186_() && !GhoulEntity.this.m_9236_().m_46859_(GhoulEntity.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)GhoulEntity.this.anchorPoint)) {
                GhoulEntity.this.anchorPoint = GhoulEntity.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            GhoulEntity.this.moveTargetPoint = Vec3.m_82528_((Vec3i)GhoulEntity.this.anchorPoint).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class GhoulEntityAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = GhoulEntityAttackPlayerTargetGoal.m_186073_((int)20);

        GhoulEntityAttackPlayerTargetGoal() {
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = GhoulEntityAttackPlayerTargetGoal.m_186073_((int)60);
            List list = GhoulEntity.this.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)GhoulEntity.this, GhoulEntity.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                for (Player player : list) {
                    if (!GhoulEntity.this.m_21040_((LivingEntity)player, TargetingConditions.f_26872_)) continue;
                    GhoulEntity.this.m_6710_((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = GhoulEntity.this.m_5448_();
            return livingentity != null ? GhoulEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }
    }

    abstract class PhantomMoveTargetGoal
    extends Goal {
        public PhantomMoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return GhoulEntity.this.moveTargetPoint.m_82531_(GhoulEntity.this.m_20185_(), GhoulEntity.this.m_20186_(), GhoulEntity.this.m_20189_()) < 4.0;
        }
    }
}

