/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTSoundsRegistry;
import com.belgieyt.trailsandtalesplus.TTConfigs;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GlareEntity
extends PathfinderMob {
    public static final int DARKNESS_LIGHT = 0;
    @Nullable
    protected BlockPos darkSpotPos;
    private static final EntityDataAccessor<Boolean> IN_DARK = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SEARCHING_DARK = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState IdleAnimationState = new AnimationState();
    public final AnimationState SearchAnimationState = new AnimationState();
    public final AnimationState FoundAnimationState = new AnimationState();

    public GlareEntity(EntityType<? extends GlareEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public float m_5610_(BlockPos blockPos, LevelReader level) {
        return level.m_46859_(blockPos) ? 10.0f : 0.0f;
    }

    protected float m_6121_() {
        return 0.5f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TemptGoal((PathfinderMob)this, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151079_}), false));
        this.f_21345_.m_25352_(1, (Goal)new MoveToDarkGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FindDarkSpotGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GlareWanderAroundGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, 0.3).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_46859_(pos.m_7495_());
            }
        };
        nav.m_26440_(false);
        nav.m_7008_(false);
        nav.m_26443_(true);
        return nav;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("InDarkness", this.inDarkness());
        nbt.m_128379_("SearchingDarkness", this.isSearchingDarkness());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setinDarkness(compound.m_128471_("InDarkness"));
        this.setSearchingDarkness(compound.m_128471_("SearchingDarkness"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IN_DARK, (Object)false);
        this.f_19804_.m_135372_(SEARCHING_DARK, (Object)false);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.55f;
    }

    public boolean inDarkness() {
        return (Boolean)this.f_19804_.m_135370_(IN_DARK);
    }

    public void setinDarkness(boolean dark) {
        this.f_19804_.m_135381_(IN_DARK, (Object)dark);
    }

    public boolean isSearchingDarkness() {
        return (Boolean)this.f_19804_.m_135370_(SEARCHING_DARK);
    }

    public void setSearchingDarkness(boolean dark) {
        this.f_19804_.m_135381_(SEARCHING_DARK, (Object)dark);
    }

    protected SoundEvent m_7515_() {
        return this.inDarkness() ? (SoundEvent)TTSoundsRegistry.GLARE_IDLE_EVIL.get() : (SoundEvent)TTSoundsRegistry.GLARE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_28306_) {
        return (SoundEvent)TTSoundsRegistry.GLARE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TTSoundsRegistry.GLARE_DEATH.get();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
        if (this.m_9236_().m_5776_()) {
            this.FoundAnimationState.m_246184_(this.inDarkness(), this.f_19797_);
            this.SearchAnimationState.m_246184_(this.isSearchingDarkness(), this.f_19797_);
            this.IdleAnimationState.m_246184_(!this.isSearchingDarkness() && !this.inDarkness(), this.f_19797_);
        }
        if (!((Boolean)TTConfigs.CAN_GLARE_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.setinDarkness(this.getLight(this.m_20183_()) <= 0);
        }
        if (this.inDarkness() && this.f_19797_ % 20 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(0.75), this.m_20186_() + this.f_19796_.m_188500_(), this.m_20262_(0.75), this.f_19796_.m_188500_(), this.f_19796_.m_188500_(), this.f_19796_.m_188500_());
        }
    }

    void MovingTo(BlockPos pos) {
        Vec3 vec3d2;
        Vec3 vec3d = Vec3.m_82539_((Vec3i)pos);
        int i = 0;
        BlockPos blockPos = this.m_20183_();
        int j = (int)vec3d.f_82480_ - blockPos.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos.m_123333_((Vec3i)pos);
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec3d2 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3d, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_, 1.0);
        }
    }

    public boolean IsDarkSpot() {
        return this.darkSpotPos != null;
    }

    public boolean isClassedAsDarkness(BlockPos pos) {
        return this.getLight(this.m_20183_()) <= 0 && this.m_9236_().m_46859_(pos);
    }

    public int getLight(BlockPos pos) {
        return this.m_9236_().m_45524_(pos, this.m_9236_().m_7445_());
    }

    boolean isWithinDistance(BlockPos pos, int distance) {
        return this.isWithinDistance(pos, (double)distance);
    }

    boolean isWithinDistance(BlockPos pos, double distance) {
        return pos.m_123314_((Vec3i)this.m_20183_(), distance);
    }

    boolean isTooFar(BlockPos pos) {
        return !this.isWithinDistance(pos, 32);
    }

    class MoveToDarkGoal
    extends Goal {
        int ticks;
        GlareEntity glare;

        MoveToDarkGoal(GlareEntity glare) {
            this.ticks = GlareEntity.this.m_9236_().f_46441_.m_188503_(10);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.glare = glare;
        }

        public boolean m_8036_() {
            return this.glare.darkSpotPos != null && !this.glare.m_21536_() && this.glare.m_20183_() != this.glare.darkSpotPos && !this.glare.m_21523_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.ticks = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            this.ticks = 0;
            this.glare.f_21344_.m_26573_();
            this.glare.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (this.glare.darkSpotPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    this.glare.darkSpotPos = null;
                } else if (!this.glare.f_21344_.m_26572_()) {
                    if (this.glare.isTooFar(this.glare.darkSpotPos)) {
                        this.glare.darkSpotPos = null;
                    } else {
                        this.glare.MovingTo(this.glare.darkSpotPos);
                    }
                }
            }
        }
    }

    class FindDarkSpotGoal
    extends Goal {
        int ticks;
        GlareEntity glare;

        FindDarkSpotGoal(GlareEntity glare) {
            this.ticks = GlareEntity.this.m_9236_().f_46441_.m_188503_(30);
            this.glare = glare;
        }

        public boolean m_8036_() {
            ++this.ticks;
            return (!this.glare.IsDarkSpot() || !GlareEntity.this.isClassedAsDarkness(this.glare.darkSpotPos)) && this.ticks > 40;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.ticks = 0;
            this.glare.setSearchingDarkness(true);
            BlockPos darkestSpot = this.getDarkestSpot();
            if (darkestSpot != null) {
                this.glare.darkSpotPos = darkestSpot;
            }
        }

        public void m_8041_() {
            this.glare.setSearchingDarkness(false);
            super.m_8041_();
        }

        private Map<BlockPos, Integer> getNearbyDarkSpots() {
            int mult = 5;
            HashMap<BlockPos, Integer> map = new HashMap<BlockPos, Integer>();
            for (BlockPos blockPos : BlockPos.m_121925_((BlockPos)this.glare.m_20183_(), (int)mult, (int)(mult - 2), (int)mult)) {
                if (!GlareEntity.this.isClassedAsDarkness(blockPos)) continue;
                map.put(blockPos.m_7949_(), this.glare.getLight(blockPos));
            }
            return map;
        }

        @Nullable
        private BlockPos getDarkestSpot() {
            Map<BlockPos, Integer> map = this.getNearbyDarkSpots();
            BlockPos returnPos = null;
            if (!map.isEmpty()) {
                Map.Entry min = Collections.min(map.entrySet(), Map.Entry.comparingByValue());
                returnPos = (BlockPos)min.getKey();
            }
            return returnPos;
        }
    }

    static class GlareWanderAroundGoal
    extends Goal {
        GlareEntity glare;
        private static final int MAX_DISTANCE = 32;

        GlareWanderAroundGoal(GlareEntity glare) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.glare = glare;
        }

        public boolean m_8036_() {
            return this.glare.f_21344_.m_26571_() && this.glare.f_19796_.m_188503_(20) == 0;
        }

        public boolean m_8045_() {
            return this.glare.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                this.glare.f_21344_.m_26536_(this.glare.f_21344_.m_7864_(new BlockPos((int)vec3d.f_82479_, (int)vec3d.f_82480_, (int)vec3d.f_82481_), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d3 = this.glare.m_20252_(0.0f);
            Vec3 vec3d4 = HoverRandomPos.m_148465_((PathfinderMob)this.glare, (int)8, (int)7, (double)vec3d3.f_82479_, (double)vec3d3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec3d4 != null ? vec3d4 : AirAndWaterRandomPos.m_148357_((PathfinderMob)this.glare, (int)8, (int)4, (int)-2, (double)vec3d3.f_82479_, (double)vec3d3.f_82481_, (double)1.5707963705062866);
        }
    }
}

