/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.TTConfigs;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LurkerEntity
extends Monster {
    private static final EntityDataAccessor<Integer> IS_ATTACKING = SynchedEntityData.m_135353_(LurkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_ENTITY = SynchedEntityData.m_135353_(LurkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity target;
    private static final Map<Integer, UUID> TARGETS = new HashMap<Integer, UUID>();
    public int ATTACK_TIMER;
    private boolean clientSideTouchedGround;
    private boolean initAttack = false;
    public int ATTACK_TIME = 0;
    public AnimationState AttackAnimationState = new AnimationState();
    public AnimationState MoveAnimationState = new AnimationState();

    public LurkerEntity(EntityType<? extends LurkerEntity> lurker, Level level) {
        super(lurker, level);
        this.f_21364_ = 32;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveHelperController(this);
    }

    protected void m_8099_() {
        MoveTowardsRestrictionGoal move = new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0);
        this.f_21345_.m_25352_(3, (Goal)new LurkerAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new HuntTargetCoal(this, 6.0, 48.0f));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, LurkerEntity.class, 72.0f, 4.0, 4.0));
        this.f_21345_.m_25352_(6, (Goal)move);
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.1f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        move.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Dolphin.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, GlowSquid.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.123).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ENTITY, (Object)0);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)0);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.MoveAnimationState.m_246184_(this.isAttacking() == 0, this.f_19797_);
        }
        if (!((Boolean)TTConfigs.CAN_LURKER_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public int getAttackDuration() {
        return 50;
    }

    public static boolean checkLurkerSpawnRules(EntityType<? extends LurkerEntity> p_219020_, LevelAccessor p_219021_, MobSpawnType p_219022_, BlockPos p_219023_, RandomSource p_219024_) {
        return p_219021_.m_46791_() != Difficulty.PEACEFUL && LurkerEntity.m_217057_(p_219020_, (LevelAccessor)p_219021_, (MobSpawnType)p_219022_, (BlockPos)p_219023_, (RandomSource)p_219024_) && p_219021_.m_6425_(p_219023_.m_7495_()).m_205070_(FluidTags.f_13131_) && p_219021_.m_8055_(p_219023_.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    private void setTargetedEntity(int target) {
        this.f_19804_.m_135381_(TARGET_ENTITY, (Object)target);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ENTITY) != 0;
    }

    private void setAttacking(int time) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)time);
    }

    public int isAttacking() {
        return (Integer)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            if (this.target != null) {
                return this.target;
            }
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                this.target = (LivingEntity)entity;
                return this.target;
            }
            return null;
        }
        return this.m_5448_();
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected void updateAir(int breath) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(breath - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 5.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (TARGET_ENTITY.equals(data)) {
            this.ATTACK_TIME = 0;
            this.target = null;
        }
    }

    public int m_8100_() {
        return 200;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12438_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12440_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12439_;
    }

    public float m_6100_() {
        return -3.0f;
    }

    protected float m_6431_(Pose pos, EntityDimensions dim) {
        return dim.f_20378_ * 0.4f;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_6425_(pos).m_205070_(FluidTags.f_13131_) ? 10.0f : super.m_5610_(pos, level);
    }

    public void m_6667_(DamageSource damage) {
        TARGETS.remove(this.f_19804_.m_135370_(TARGET_ENTITY));
        super.m_6667_(damage);
    }

    public void m_147240_(double move, double x, double z) {
        super.m_147240_(move / 12.0, x, z);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (this.m_9236_().f_46443_) {
                if (!this.m_20069_()) {
                    Vec3 vector3d = this.m_20184_();
                    if (vector3d.f_82480_ > 0.0 && this.clientSideTouchedGround && !this.m_20067_()) {
                        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12441_, this.m_5720_(), 1.0f, 1.0f, false);
                    }
                    boolean bl = this.clientSideTouchedGround = vector3d.f_82480_ < 0.0 && this.m_9236_().m_46575_(this.m_20183_().m_7495_(), (Entity)this);
                }
                if (this.hasTargetedEntity() && this.ATTACK_TIME < this.getAttackDuration()) {
                    ++this.ATTACK_TIMER;
                }
            }
            if (this.hasTargetedEntity()) {
                this.m_146922_(this.f_20885_);
                LivingEntity livingentity = this.getTargetedEntity();
                if (livingentity != null) {
                    this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                    this.m_21563_().m_8128_();
                    double d5 = 0.0;
                    double d0 = livingentity.m_20185_() - this.m_20185_();
                    double d1 = livingentity.m_20227_(0.5) - this.m_20188_();
                    double d2 = livingentity.m_20189_() - this.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.f_19796_.m_188500_();
                    if (this.isAttacking() == 0) {
                        this.setAttacking(1);
                    }
                    while (d4 < d3) {
                        d4 += 1.8 - d5 + this.f_19796_.m_188500_() * (1.7 - d5);
                        livingentity.m_7678_(this.m_20185_() + d0 * d3, this.m_20188_(), this.m_20189_() + d2 * d3, livingentity.m_146908_(), livingentity.m_146909_());
                        livingentity.m_20282_(false);
                        livingentity.m_5844_();
                        if (this.isAttacking() != 0) {
                            if (this.ATTACK_TIME > 10) {
                                if (!this.initAttack) {
                                    livingentity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 0.1f);
                                    this.initAttack = true;
                                }
                            } else {
                                ++this.ATTACK_TIME;
                            }
                            livingentity.m_5997_(-d0 / 50.0, -d1 / 50.0, -d2 / 30.0);
                            this.m_9236_().m_7605_((Entity)this, (byte)4);
                            continue;
                        }
                        if (this.initAttack) {
                            this.initAttack = false;
                            continue;
                        }
                        this.ATTACK_TIMER = 0;
                    }
                }
            }
            if (this.m_20072_()) {
                this.m_20301_(300);
            } else if (this.m_20096_()) {
                this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.1f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.1f)));
                this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
                this.f_19812_ = true;
            }
        }
    }

    public void m_6075_() {
        int air = this.m_20146_();
        super.m_6075_();
        this.updateAir(air);
    }

    public boolean m_6914_(LevelReader level) {
        return !level.m_183134_((Entity)this, new AABB(this.m_20097_())).isEmpty();
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.AttackAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7822_(p_21375_);
    }

    public void m_7023_(Vec3 travel) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.1f, travel);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_6113_() == 0.0f && this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.001, 0.0));
            } else if (this.m_5448_() != null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travel);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.m_21536_()) {
            this.m_21446_(this.m_20183_(), 96);
        }
    }

    public boolean waterCheck(LivingEntity entity) {
        return entity.m_20069_();
    }

    static class MoveHelperController
    extends MoveControl {
        private final LurkerEntity mob;

        public MoveHelperController(LurkerEntity entity) {
            super((Mob)entity);
            this.mob = entity;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.mob.m_21573_().m_26571_()) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.mob.m_20185_(), this.f_24976_ - this.mob.m_20186_(), this.f_24977_ - this.mob.m_20189_());
                double d0 = vector3d.m_82553_();
                double d1 = vector3d.f_82479_ / d0;
                double d2 = vector3d.f_82480_ / d0;
                double d3 = vector3d.f_82481_ / d0;
                float f = (float)(Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) * 57.2957763671875) - 90.0f;
                this.mob.m_146922_(this.m_24991_(this.mob.m_146908_(), f, 90.0f));
                this.mob.f_20883_ = this.mob.m_146908_();
                float f1 = (float)(this.f_24978_ * this.mob.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.mob.m_6113_(), (float)f1);
                this.mob.m_7910_(f2);
                double d4 = Math.sin((double)(this.mob.f_19797_ + this.mob.m_19879_()) * 0.5) * 0.05;
                double d5 = Math.cos(this.mob.m_146908_() * ((float)Math.PI / 180));
                double d6 = Math.sin(this.mob.m_146908_() * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.mob.f_19797_ + this.mob.m_19879_()) * 0.75) * 0.05;
                this.mob.m_20256_(this.mob.m_20184_().m_82520_(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f2 * d2 * 0.1, d4 * d6));
                LookControl lookcontroller = this.mob.m_21563_();
                double d8 = this.mob.m_20185_() + d1 * 2.0;
                double d9 = this.mob.m_20188_() + d2 / d0;
                double d10 = this.mob.m_20189_() + d3 * 2.0;
                double d11 = lookcontroller.m_24969_();
                double d12 = lookcontroller.m_24970_();
                double d13 = lookcontroller.m_24971_();
                if (!lookcontroller.m_186069_()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.mob.m_21563_().m_24950_(Mth.m_14139_((double)0.125, (double)d11, (double)d8), Mth.m_14139_((double)0.125, (double)d12, (double)d9), Mth.m_14139_((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
            } else {
                this.mob.m_7910_(0.0f);
            }
        }
    }

    static class LurkerAttackGoal
    extends Goal {
        private final LurkerEntity mob;
        private int tickCounter;
        private boolean hasAttacked;

        public LurkerAttackGoal(LurkerEntity lurker) {
            this.mob = lurker;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.mob.waterCheck(livingentity) && this.mob.m_20280_((Entity)this.mob.m_5448_()) < 48.0;
        }

        public boolean m_8045_() {
            if (this.mob.m_5448_() != null) {
                return this.mob.m_20280_((Entity)this.mob.m_5448_()) < 90.5 && this.mob.waterCheck(this.mob.m_5448_());
            }
            return false;
        }

        public void m_8056_() {
            this.tickCounter = -1;
            this.mob.m_21573_().m_26573_();
            this.mob.f_19812_ = true;
            this.hasAttacked = false;
        }

        public void m_8041_() {
            TARGETS.remove(this.mob.f_19804_.m_135370_(TARGET_ENTITY));
            this.mob.setTargetedEntity(0);
            this.mob.m_6710_(null);
            this.mob.setAttacking(0);
            this.hasAttacked = false;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                this.mob.m_21573_().m_26573_();
                this.mob.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                if (!this.mob.m_142582_((Entity)livingentity)) {
                    this.mob.m_6710_(null);
                } else {
                    ++this.tickCounter;
                    if (this.mob.isAttacking() < 1) {
                        this.mob.setAttacking(1);
                    }
                    if (this.tickCounter == 0) {
                        this.mob.setTargetedEntity(this.mob.m_5448_().m_19879_());
                        TARGETS.put(livingentity.m_19879_(), this.mob.m_20148_());
                    } else if (this.tickCounter >= this.mob.getAttackDuration()) {
                        if (this.tickCounter >= 600) {
                            this.mob.setAttacking(2);
                            if (this.tickCounter % 5 == 0) {
                                livingentity.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 2.0f);
                            }
                        } else if (this.tickCounter % 40 == 0 && this.mob.isAttacking() == 1) {
                            this.mob.setAttacking(3);
                        } else if (this.mob.isAttacking() == 3 && this.tickCounter % 6 == 0) {
                            if (!this.hasAttacked) {
                                livingentity.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 2.0f);
                            } else {
                                this.mob.setAttacking(1);
                            }
                            this.hasAttacked = !this.hasAttacked;
                        }
                    }
                }
            }
        }
    }

    static class HuntTargetCoal
    extends MoveTowardsTargetGoal {
        private final LurkerEntity mob;
        private final double speed;

        public HuntTargetCoal(LurkerEntity lurker, double speed, float nax) {
            super((PathfinderMob)lurker, speed, nax);
            this.mob = lurker;
            this.speed = speed;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                return super.m_8036_() && this.mob.waterCheck(livingentity) && this.mob.m_21533_();
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                return super.m_8045_() && this.mob.waterCheck(livingentity) && this.mob.m_21533_();
            }
            return false;
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                this.mob.m_21573_().m_5624_((Entity)livingentity, this.speed);
            }
        }
    }
}

