/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTItemRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTSoundsRegistry;
import com.belgieyt.trailsandtalesplus.TTConfigs;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;

public class MeerkatEntity
extends Animal {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(MeerkatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_STANDING = 1;
    public static final int FLAG_CRAWLING = 4;
    private static final int FLAG_DEFENDING = 128;
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.m_135353_(MeerkatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.m_135353_(MeerkatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final Predicate<Entity> TRUSTED_TARGET_SELECTOR = p_287481_ -> {
        if (!(p_287481_ instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)p_287481_;
        return livingentity.m_21214_() != null && livingentity.m_21215_() < livingentity.f_19797_ + 600;
    };
    private static final Predicate<Entity> AVOID_PLAYERS = p_28463_ -> !p_28463_.m_20163_() && EntitySelector.f_20406_.test(p_28463_);
    private Goal landTargetGoal;
    @Nullable
    private MeerkatEntity caravanHead;
    @Nullable
    private MeerkatEntity caravanTail;
    public AnimationState IdleAnimationsState = new AnimationState();
    public AnimationState DigAnimationsState = new AnimationState();

    public MeerkatEntity(EntityType<? extends MeerkatEntity> p_28451_, Level p_28452_) {
        super(p_28451_, p_28452_);
        this.f_21365_ = new FoxLookControl();
        this.f_21342_ = new FoxMoveControl();
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 1.0f);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)TTEntityRegistry.MEERKAT.get()).m_20615_((Level)p_146743_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_0, Optional.empty());
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_1, Optional.empty());
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    void setDefending(boolean p_28623_) {
        this.setFlag(128, p_28623_);
    }

    protected void m_8099_() {
        this.landTargetGoal = new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, false, false, p_28604_ -> p_28604_ instanceof Spider);
        this.f_21345_.m_25352_(0, (Goal)new FoxFloatGoal());
        this.f_21345_.m_25352_(0, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(2, (Goal)new FoxPanicGoal(2.2));
        this.f_21345_.m_25352_(3, (Goal)new FoxBreedGoal(1.0));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.6, 1.4, p_289437_ -> AVOID_PLAYERS.test((Entity)p_289437_) && !this.trusts(p_289437_.m_20148_()) && !this.isDefending()));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 8.0f, 1.6, 1.4, p_289439_ -> !((Wolf)p_289439_).m_21824_() && !this.isDefending()));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 8.0f, 1.6, 1.4, p_28585_ -> !this.isDefending()));
        this.f_21345_.m_25352_(7, (Goal)new FoxMeleeAttackGoal(1.2f, true));
        this.f_21345_.m_25352_(8, (Goal)new FoxFollowParentGoal(this, 1.25));
        this.f_21345_.m_25352_(10, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 24.0f));
        this.f_21346_.m_25352_(3, (Goal)new DefendTrustedTargetGoal(LivingEntity.class, false, false, p_289440_ -> TRUSTED_TARGET_SELECTOR.test((Entity)p_289440_) && !this.trusts(p_289440_.m_20148_())));
        this.f_21345_.m_25352_(2, (Goal)new FollowCaravanGoal(this, 2.1f));
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public static boolean checkMeerkatSpawnRules(EntityType<MeerkatEntity> p_218176_, LevelAccessor p_218177_, MobSpawnType p_218178_, BlockPos p_218179_, RandomSource p_218180_) {
        return p_218177_.m_8055_(p_218179_.m_7495_()).m_60713_(Blocks.f_49992_) && MeerkatEntity.m_186209_((BlockAndTintGetter)p_218177_, (BlockPos)p_218179_);
    }

    public void m_8107_() {
        LivingEntity livingentity;
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_() && ((livingentity = this.m_5448_()) == null || !livingentity.m_6084_())) {
            this.setIsCrouching(false);
        }
        super.m_8107_();
        if (this.isDefending() && this.f_19796_.m_188501_() < 0.05f) {
            this.m_5496_(SoundEvents.f_11943_, 1.0f, 1.0f);
        }
    }

    public boolean m_7327_(Entity p_21372_) {
        if (this.m_9236_().f_46441_.m_188501_() < 0.3f) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + 0.5, this.m_20186_() + 0.1, this.m_20189_() + 0.5, new ItemStack((ItemLike)TTItemRegistry.SAND_BALL.get(), 2));
            this.m_9236_().m_7967_((Entity)itementity);
        }
        return super.m_7327_(p_21372_);
    }

    protected boolean m_6107_() {
        return this.m_21224_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    void clearStates() {
        this.setIsCrouching(false);
        this.setSitting(false);
        this.setDefending(false);
    }

    List<UUID> getTrustedUUIDs() {
        ArrayList list = Lists.newArrayList();
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).orElse(null));
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_1)).orElse(null));
        return list;
    }

    void addTrustedUUID(@Nullable UUID p_28516_) {
        if (((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).isPresent()) {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.ofNullable(p_28516_));
        } else {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.ofNullable(p_28516_));
        }
    }

    public void m_7380_(CompoundTag p_28518_) {
        super.m_7380_(p_28518_);
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listtag = new ListTag();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listtag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        p_28518_.m_128365_("Trusted", (Tag)listtag);
        p_28518_.m_128379_("Crouching", this.m_6047_());
    }

    private void setTargetGoals() {
        this.f_21346_.m_25352_(4, this.landTargetGoal);
    }

    public void m_7378_(CompoundTag p_28493_) {
        super.m_7378_(p_28493_);
        ListTag listtag = p_28493_.m_128437_("Trusted", 11);
        for (int i = 0; i < listtag.size(); ++i) {
            this.addTrustedUUID(NbtUtils.m_129233_((Tag)listtag.get(i)));
        }
        this.setIsCrouching(p_28493_.m_128471_("Crouching"));
        if (this.m_9236_() instanceof ServerLevel) {
            this.setTargetGoals();
        }
    }

    public boolean isSitting() {
        return this.getFlag(1);
    }

    public void setSitting(boolean p_28611_) {
        this.setFlag(1, p_28611_);
    }

    private void setFlag(int p_28533_, boolean p_28534_) {
        if (p_28534_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | p_28533_)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~p_28533_)));
        }
    }

    private boolean getFlag(int p_28609_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & p_28609_) != 0;
    }

    public void m_8119_() {
        boolean flag;
        super.m_8119_();
        if (this.m_21515_() && (flag = this.m_20069_())) {
            this.setSitting(false);
        }
        if (this.m_9236_().m_5776_()) {
            this.IdleAnimationsState.m_246184_(!this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (!((Boolean)TTConfigs.CAN_MEERKAT_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
    }

    public boolean m_6898_(ItemStack p_28594_) {
        return p_28594_.m_150930_((Item)TTItemRegistry.TERMITE.get());
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(MeerkatEntity p_30767_) {
        this.caravanHead = p_30767_;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public MeerkatEntity getCaravanHead() {
        return this.caravanHead;
    }

    public void setIsCrouching(boolean p_28615_) {
        this.setFlag(4, p_28615_);
    }

    public boolean m_6047_() {
        return this.getFlag(4);
    }

    public void m_6710_(@Nullable LivingEntity p_28574_) {
        if (this.isDefending() && p_28574_ == null) {
            this.setDefending(false);
        }
        super.m_6710_(p_28574_);
    }

    boolean canMove() {
        return !this.m_5803_() && !this.isSitting();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)TTSoundsRegistry.MEERKAT_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_28548_) {
        return (SoundEvent)TTSoundsRegistry.MEERKAT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TTSoundsRegistry.MEERKAT_DEATH.get();
    }

    boolean trusts(UUID p_28530_) {
        return this.getTrustedUUIDs().contains(p_28530_);
    }

    public static boolean isPathClear(Fox p_28472_, LivingEntity p_28473_) {
        double d0 = p_28473_.m_20189_() - p_28472_.m_20189_();
        double d1 = p_28473_.m_20185_() - p_28472_.m_20185_();
        double d2 = d0 / d1;
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (p_28472_.m_9236_().m_8055_(BlockPos.m_274561_((double)(p_28472_.m_20185_() + d4), (double)(p_28472_.m_20186_() + (double)k), (double)(p_28472_.m_20189_() + d3))).m_247087_()) continue;
                return false;
            }
        }
        return true;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.55f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public class FoxLookControl
    extends LookControl {
        public FoxLookControl() {
            super((Mob)MeerkatEntity.this);
        }

        public void m_8128_() {
            if (!MeerkatEntity.this.m_5803_()) {
                super.m_8128_();
            }
        }

        protected boolean m_8106_() {
            return !MeerkatEntity.this.m_6047_();
        }
    }

    class FoxMoveControl
    extends MoveControl {
        public FoxMoveControl() {
            super((Mob)MeerkatEntity.this);
        }

        public void m_8126_() {
            if (MeerkatEntity.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    class FoxFloatGoal
    extends FloatGoal {
        public FoxFloatGoal() {
            super((Mob)MeerkatEntity.this);
        }

        public void m_8056_() {
            super.m_8056_();
            MeerkatEntity.this.clearStates();
        }

        public boolean m_8036_() {
            return MeerkatEntity.this.m_20069_() && MeerkatEntity.this.m_204036_(FluidTags.f_13131_) > 0.25 || MeerkatEntity.this.m_20077_() || MeerkatEntity.this.isInFluidType((fluidType, height) -> MeerkatEntity.this.canSwimInFluidType((FluidType)fluidType) && height > 0.25);
        }
    }

    class FoxPanicGoal
    extends PanicGoal {
        public FoxPanicGoal(double p_28734_) {
            super((PathfinderMob)MeerkatEntity.this, p_28734_);
        }

        public boolean m_202729_() {
            return !MeerkatEntity.this.isDefending() && super.m_202729_();
        }
    }

    class FoxBreedGoal
    extends BreedGoal {
        public FoxBreedGoal(double p_28668_) {
            super((Animal)MeerkatEntity.this, p_28668_);
        }

        public void m_8056_() {
            ((MeerkatEntity)this.f_25113_).clearStates();
            ((MeerkatEntity)this.f_25115_).clearStates();
            super.m_8056_();
        }

        protected void m_8026_() {
            ServerLevel serverlevel = (ServerLevel)this.f_25114_;
            MeerkatEntity fox = (MeerkatEntity)this.f_25113_.m_142606_(serverlevel, (AgeableMob)this.f_25115_);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.f_25113_, (Mob)this.f_25115_, (AgeableMob)fox);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            fox = (MeerkatEntity)event.getChild();
            if (cancelled) {
                this.f_25113_.m_146762_(6000);
                this.f_25115_.m_146762_(6000);
                this.f_25113_.m_27594_();
                this.f_25115_.m_27594_();
                return;
            }
            if (fox != null) {
                ServerPlayer serverplayer = this.f_25113_.m_27592_();
                ServerPlayer serverplayer1 = this.f_25115_.m_27592_();
                ServerPlayer serverplayer2 = serverplayer;
                if (serverplayer != null) {
                    fox.addTrustedUUID(serverplayer.m_20148_());
                } else {
                    serverplayer2 = serverplayer1;
                }
                if (serverplayer1 != null && serverplayer != serverplayer1) {
                    fox.addTrustedUUID(serverplayer1.m_20148_());
                }
                if (serverplayer2 != null) {
                    serverplayer2.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(serverplayer2, this.f_25113_, this.f_25115_, (AgeableMob)fox);
                }
                this.f_25113_.m_146762_(6000);
                this.f_25115_.m_146762_(6000);
                this.f_25113_.m_27594_();
                this.f_25115_.m_27594_();
                fox.m_146762_(-24000);
                fox.m_7678_(this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), 0.0f, 0.0f);
                serverlevel.m_47205_((Entity)fox);
                this.f_25114_.m_7605_((Entity)this.f_25113_, (byte)18);
                if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), this.f_25113_.m_217043_().m_188503_(7) + 1));
                }
            }
        }
    }

    class FoxMeleeAttackGoal
    extends MeleeAttackGoal {
        public FoxMeleeAttackGoal(double p_28720_, boolean p_28721_) {
            super((PathfinderMob)MeerkatEntity.this, p_28720_, p_28721_);
        }

        protected void m_6739_(LivingEntity p_28724_, double p_28725_) {
            double d0 = this.m_6639_(p_28724_);
            if (p_28725_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_28724_);
                MeerkatEntity.this.m_5496_(SoundEvents.f_11945_, 1.0f, 1.0f);
            }
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8036_() {
            return !MeerkatEntity.this.isSitting() && !MeerkatEntity.this.m_5803_() && !MeerkatEntity.this.m_6047_() && super.m_8036_();
        }
    }

    class FoxFollowParentGoal
    extends FollowParentGoal {
        private final MeerkatEntity fox;

        public FoxFollowParentGoal(MeerkatEntity p_28696_, double p_28697_) {
            super((Animal)p_28696_, p_28697_);
            this.fox = p_28696_;
        }

        public boolean m_8036_() {
            return !this.fox.isDefending() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.fox.isDefending() && super.m_8045_();
        }

        public void m_8056_() {
            this.fox.clearStates();
            super.m_8056_();
        }
    }

    class DefendTrustedTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity trustedLastHurtBy;
        @Nullable
        private LivingEntity trustedLastHurt;
        private int timestamp;

        public DefendTrustedTargetGoal(Class<LivingEntity> p_28634_, boolean p_28635_, @Nullable boolean p_28636_, Predicate<LivingEntity> p_28637_) {
            super((Mob)MeerkatEntity.this, p_28634_, 10, p_28635_, p_28636_, p_28637_);
        }

        public boolean m_8036_() {
            if (this.f_26049_ > 0 && this.f_26135_.m_217043_().m_188503_(this.f_26049_) != 0) {
                return false;
            }
            for (UUID uuid : MeerkatEntity.this.getTrustedUUIDs()) {
                LivingEntity livingentity;
                Entity entity;
                if (uuid == null || !(MeerkatEntity.this.m_9236_() instanceof ServerLevel) || !((entity = ((ServerLevel)MeerkatEntity.this.m_9236_()).m_8791_(uuid)) instanceof LivingEntity)) continue;
                this.trustedLastHurt = livingentity = (LivingEntity)entity;
                this.trustedLastHurtBy = livingentity.m_21188_();
                int i = livingentity.m_21213_();
                return i != this.timestamp && this.m_26150_(this.trustedLastHurtBy, this.f_26051_);
            }
            return false;
        }

        public void m_8056_() {
            this.m_26070_(this.trustedLastHurtBy);
            this.f_26050_ = this.trustedLastHurtBy;
            if (this.trustedLastHurt != null) {
                this.timestamp = this.trustedLastHurt.m_21213_();
            }
            MeerkatEntity.this.m_5496_(SoundEvents.f_11943_, 1.0f, 1.0f);
            MeerkatEntity.this.setDefending(true);
            super.m_8056_();
        }
    }

    static class FollowCaravanGoal
    extends Goal {
        public final MeerkatEntity llama;
        private double speedModifier;
        private static final int CARAVAN_LIMIT = 8;
        private int distCheckCounter;

        public FollowCaravanGoal(MeerkatEntity p_25501_, double p_25502_) {
            this.llama = p_25501_;
            this.speedModifier = p_25502_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.llama.m_21523_() && !this.llama.inCaravan()) {
                List list = this.llama.m_9236_().m_6249_((Entity)this.llama, this.llama.m_20191_().m_82377_(9.0, 4.0, 9.0), p_25505_ -> {
                    EntityType entitytype = p_25505_.m_6095_();
                    return entitytype == TTEntityRegistry.MEERKAT.get();
                });
                MeerkatEntity llama = null;
                double d0 = Double.MAX_VALUE;
                for (Entity entity : list) {
                    double d1;
                    MeerkatEntity llama1 = (MeerkatEntity)entity;
                    if (!llama1.inCaravan() || llama1.hasCaravanTail() || (d1 = this.llama.m_20280_((Entity)llama1)) > d0) continue;
                    d0 = d1;
                    llama = llama1;
                }
                if (llama == null) {
                    for (Entity entity1 : list) {
                        double d2;
                        MeerkatEntity llama2 = (MeerkatEntity)entity1;
                        if (!llama2.m_21523_() || llama2.hasCaravanTail() || (d2 = this.llama.m_20280_((Entity)llama2)) > d0) continue;
                        d0 = d2;
                        llama = llama2;
                    }
                }
                if (llama == null) {
                    return false;
                }
                if (d0 < 4.0) {
                    return false;
                }
                if (!llama.m_21523_() && !this.firstIsLeashed(llama, 1)) {
                    return false;
                }
                this.llama.joinCaravan(llama);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.llama.inCaravan() && this.llama.getCaravanHead().m_6084_() && this.firstIsLeashed(this.llama, 0)) {
                double d0 = this.llama.m_20280_((Entity)this.llama.getCaravanHead());
                if (d0 > 676.0) {
                    if (this.speedModifier <= 3.0) {
                        this.speedModifier *= 1.2;
                        this.distCheckCounter = FollowCaravanGoal.m_186073_((int)40);
                        return true;
                    }
                    if (this.distCheckCounter == 0) {
                        return false;
                    }
                }
                if (this.distCheckCounter > 0) {
                    --this.distCheckCounter;
                }
                return true;
            }
            return false;
        }

        public void m_8041_() {
            this.llama.leaveCaravan();
            this.speedModifier = 2.1;
        }

        public void m_8037_() {
            if (this.llama.inCaravan() && !(this.llama.m_21524_() instanceof LeashFenceKnotEntity)) {
                MeerkatEntity llama = this.llama.getCaravanHead();
                double d0 = this.llama.m_20270_((Entity)llama);
                float f = 2.0f;
                Vec3 vec3 = new Vec3(llama.m_20185_() - this.llama.m_20185_(), llama.m_20186_() - this.llama.m_20186_(), llama.m_20189_() - this.llama.m_20189_()).m_82541_().m_82490_(Math.max(d0 - 2.0, 0.0));
                this.llama.m_21573_().m_26519_(this.llama.m_20185_() + vec3.f_82479_, this.llama.m_20186_() + vec3.f_82480_, this.llama.m_20189_() + vec3.f_82481_, this.speedModifier);
            }
        }

        private boolean firstIsLeashed(MeerkatEntity p_25507_, int p_25508_) {
            if (p_25508_ > 8) {
                return false;
            }
            if (p_25507_.inCaravan()) {
                if (p_25507_.getCaravanHead().m_21523_()) {
                    return true;
                }
                MeerkatEntity llama = p_25507_.getCaravanHead();
                return this.firstIsLeashed(llama, ++p_25508_);
            }
            return false;
        }
    }

    public class FoxAlertableEntitiesSelector
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_28653_) {
            if (p_28653_ instanceof MeerkatEntity) {
                return false;
            }
            if (!(p_28653_ instanceof Monster)) {
                if (p_28653_ instanceof TamableAnimal) {
                    return !((TamableAnimal)p_28653_).m_21824_();
                }
                if (!(p_28653_ instanceof Player) || !p_28653_.m_5833_() && !((Player)p_28653_).m_7500_()) {
                    if (MeerkatEntity.this.trusts(p_28653_.m_20148_())) {
                        return false;
                    }
                    return !p_28653_.m_5803_() && !p_28653_.m_20163_();
                }
                return false;
            }
            return true;
        }
    }
}

