/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.entity.ai.PenguinDiveGoal;
import com.belgieyt.trailsandtalesplus.TTConfigs;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class MobC2023Entity
extends Animal {
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(MobC2023Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<BlockPos> TRAVEL_POS = SynchedEntityData.m_135353_(MobC2023Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(MobC2023Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TRAVELLING = SynchedEntityData.m_135353_(MobC2023Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42527_});
    public static final Predicate<LivingEntity> BABY_ON_LAND_SELECTOR = p_289447_ -> p_289447_.m_6162_() && !p_289447_.m_20069_();
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(MobC2023Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    static final TargetingConditions SWIM_WITH_PLAYER_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    public final AnimationState swimIdleAnimationState = new AnimationState();
    public final AnimationState LandIdleAnimationState = new AnimationState();

    public MobC2023Entity(EntityType<? extends MobC2023Entity> p_30132_, Level p_30133_) {
        super(p_30132_, p_30133_);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, -1.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, -1.0f);
        this.m_21441_(BlockPathTypes.DOOR_OPEN, -1.0f);
        this.f_21342_ = new TurtleMoveControl(this);
        this.m_274367_(1.0f);
    }

    public void setHomePos(BlockPos p_30220_) {
        this.f_19804_.m_135381_(HOME_POS, (Object)p_30220_);
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    void setHasEgg(boolean p_30235_) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)p_30235_);
    }

    BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    void setTravelPos(BlockPos p_30224_) {
        this.f_19804_.m_135381_(TRAVEL_POS, (Object)p_30224_);
    }

    BlockPos getTravelPos() {
        return (BlockPos)this.f_19804_.m_135370_(TRAVEL_POS);
    }

    boolean isGoingHome() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    void setGoingHome(boolean p_30239_) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)p_30239_);
    }

    boolean isTravelling() {
        return (Boolean)this.f_19804_.m_135370_(TRAVELLING);
    }

    void setTravelling(boolean p_30241_) {
        this.f_19804_.m_135381_(TRAVELLING, (Object)p_30241_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(TRAVEL_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(GOING_HOME, (Object)false);
        this.f_19804_.m_135372_(TRAVELLING, (Object)false);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
    }

    public void m_7380_(CompoundTag p_30176_) {
        super.m_7380_(p_30176_);
        p_30176_.m_128405_("HomePosX", this.getHomePos().m_123341_());
        p_30176_.m_128405_("HomePosY", this.getHomePos().m_123342_());
        p_30176_.m_128405_("HomePosZ", this.getHomePos().m_123343_());
        p_30176_.m_128379_("HasEgg", this.hasEgg());
        p_30176_.m_128405_("TravelPosX", this.getTravelPos().m_123341_());
        p_30176_.m_128405_("TravelPosY", this.getTravelPos().m_123342_());
        p_30176_.m_128405_("TravelPosZ", this.getTravelPos().m_123343_());
    }

    public void m_7378_(CompoundTag p_30162_) {
        int i = p_30162_.m_128451_("HomePosX");
        int j = p_30162_.m_128451_("HomePosY");
        int k = p_30162_.m_128451_("HomePosZ");
        this.setHomePos(new BlockPos(i, j, k));
        super.m_7378_(p_30162_);
        this.setHasEgg(p_30162_.m_128471_("HasEgg"));
        int l = p_30162_.m_128451_("TravelPosX");
        int i1 = p_30162_.m_128451_("TravelPosY");
        int j1 = p_30162_.m_128451_("TravelPosZ");
        this.setTravelPos(new BlockPos(l, i1, j1));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_30153_, DifficultyInstance p_30154_, MobSpawnType p_30155_, @Nullable SpawnGroupData p_30156_, @Nullable CompoundTag p_30157_) {
        this.setHomePos(this.m_20183_());
        this.setTravelPos(BlockPos.f_121853_);
        return super.m_6518_(p_30153_, p_30154_, p_30155_, p_30156_, p_30157_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TurtlePanicGoal(this, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new DolphinSwimWithPlayerGoal(this, 4.0));
        this.f_21345_.m_25352_(1, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new TurtleBreedGoal(this, 0.3f));
        this.f_21345_.m_25352_(3, (Goal)new PenguinDiveGoal(this, 10));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new TurtleGoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TurtleGoHomeGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new TurtleTravelGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new TurtleRandomStrollGoal(this, 1.0, 100));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public int m_8100_() {
        return 200;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return !this.m_20069_() && this.m_20096_() && !this.m_6162_() ? SoundEvents.f_12530_ : super.m_7515_();
    }

    protected void m_5625_(float p_30192_) {
        super.m_5625_(p_30192_ * 1.5f);
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_12489_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_30202_) {
        return this.m_6162_() ? SoundEvents.f_12485_ : SoundEvents.f_12536_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return this.m_6162_() ? SoundEvents.f_12532_ : SoundEvents.f_12531_;
    }

    protected void m_7355_(BlockPos p_30173_, BlockState p_30174_) {
        SoundEvent soundevent = this.m_6162_() ? SoundEvents.f_12488_ : SoundEvents.f_12487_;
        this.m_5496_(soundevent, 0.15f, 1.0f);
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.15f;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.3f : 1.0f;
    }

    protected PathNavigation m_6037_(Level p_30171_) {
        return new TurtlePathNavigation(this, p_30171_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.hasEgg() && this.f_19796_.m_188503_(10000) == 0) {
            this.setHasEgg(false);
            MobC2023Entity penguin = (MobC2023Entity)((EntityType)TTEntityRegistry.MOB_C_2023.get()).m_20615_(this.m_9236_());
            penguin.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            penguin.m_6863_(true);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_276434_, SoundSource.BLOCKS, 1.0f, 1.0f);
            penguin.m_21530_();
            this.m_9236_().m_7967_((Entity)penguin);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_149068_, AgeableMob p_149069_) {
        return (AgeableMob)((EntityType)TTEntityRegistry.MOB_C_2023.get()).m_20615_((Level)p_149068_);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.swimIdleAnimationState.m_246184_(this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
            this.LandIdleAnimationState.m_246184_(this.m_20096_() && !this.f_267362_.m_267780_() && this.hasEgg(), this.f_19797_);
        }
        if (!((Boolean)TTConfigs.CAN_PENGUIN_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        if ((float)this.m_9236_().f_46441_.m_188502_() < 0.3f && p_27567_.m_7640_() instanceof Zombie) {
            this.setHasEgg(false);
        }
        return super.m_6469_(p_27567_, p_27568_);
    }

    public boolean m_6898_(ItemStack p_30231_) {
        return p_30231_.m_150930_(Items.f_42527_);
    }

    public float m_5610_(BlockPos p_30159_, LevelReader p_30160_) {
        if (!this.isGoingHome() && p_30160_.m_6425_(p_30159_).m_205070_(FluidTags.f_13131_)) {
            return 10.0f;
        }
        return TurtleEggBlock.m_57762_((BlockGetter)p_30160_, (BlockPos)p_30159_) ? 10.0f : p_30160_.m_220419_(p_30159_);
    }

    public void m_7023_(Vec3 p_30218_) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(0.1f, p_30218_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!(this.m_5448_() != null || this.isGoingHome() && this.getHomePos().m_203195_((Position)this.m_20182_(), 20.0))) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_30218_);
        }
    }

    public boolean m_6573_(Player p_30151_) {
        return false;
    }

    static class TurtleMoveControl
    extends MoveControl {
        private final MobC2023Entity turtle;

        TurtleMoveControl(MobC2023Entity p_30286_) {
            super((Mob)p_30286_);
            this.turtle = p_30286_;
        }

        private void updateSpeed() {
            if (this.turtle.m_20069_()) {
                this.turtle.m_20256_(this.turtle.m_20184_().m_82520_(0.0, 0.005, 0.0));
                if (!this.turtle.getHomePos().m_203195_((Position)this.turtle.m_20182_(), 16.0)) {
                    this.turtle.m_7910_(Math.max(this.turtle.m_6113_() / 2.0f, 0.08f));
                }
                if (this.turtle.m_6162_()) {
                    this.turtle.m_7910_(Math.max(this.turtle.m_6113_() / 3.0f, 0.06f));
                }
            } else if (this.turtle.m_20096_()) {
                this.turtle.m_7910_(Math.max(this.turtle.m_6113_() / 2.0f, 0.06f));
            }
        }

        public void m_8126_() {
            this.updateSpeed();
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.turtle.m_21573_().m_26571_()) {
                double d2;
                double d1;
                double d0 = this.f_24975_ - this.turtle.m_20185_();
                double d3 = Math.sqrt(d0 * d0 + (d1 = this.f_24976_ - this.turtle.m_20186_()) * d1 + (d2 = this.f_24977_ - this.turtle.m_20189_()) * d2);
                if (d3 < (double)1.0E-5f) {
                    this.f_24974_.m_7910_(0.0f);
                } else {
                    d1 /= d3;
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.turtle.m_146922_(this.m_24991_(this.turtle.m_146908_(), f, 90.0f));
                    this.turtle.f_20883_ = this.turtle.m_146908_();
                    float f1 = (float)(this.f_24978_ * this.turtle.m_21133_(Attributes.f_22279_));
                    this.turtle.m_7910_(Mth.m_14179_((float)0.125f, (float)this.turtle.m_6113_(), (float)f1));
                    this.turtle.m_20256_(this.turtle.m_20184_().m_82520_(0.0, (double)this.turtle.m_6113_() * d1 * 0.1, 0.0));
                }
            } else {
                this.turtle.m_7910_(0.0f);
            }
        }
    }

    static class TurtlePanicGoal
    extends PanicGoal {
        TurtlePanicGoal(MobC2023Entity p_30290_, double p_30291_) {
            super((PathfinderMob)p_30290_, p_30291_);
        }

        public boolean m_8036_() {
            if (!this.m_202729_()) {
                return false;
            }
            BlockPos blockpos = this.m_198172_((BlockGetter)this.f_25684_.m_9236_(), (Entity)this.f_25684_, 7);
            if (blockpos != null) {
                this.f_25686_ = blockpos.m_123341_();
                this.f_25687_ = blockpos.m_123342_();
                this.f_25688_ = blockpos.m_123343_();
                return true;
            }
            return this.m_25702_();
        }
    }

    static class DolphinSwimWithPlayerGoal
    extends Goal {
        private final MobC2023Entity dolphin;
        private final double speedModifier;
        @Nullable
        private Player player;

        DolphinSwimWithPlayerGoal(MobC2023Entity p_28413_, double p_28414_) {
            this.dolphin = p_28413_;
            this.speedModifier = p_28414_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.player = this.dolphin.m_9236_().m_45946_(SWIM_WITH_PLAYER_TARGETING, (LivingEntity)this.dolphin);
            if (this.player == null) {
                return false;
            }
            return this.player.m_6069_() && this.dolphin.m_5448_() != this.player;
        }

        public boolean m_8045_() {
            return this.player != null && this.player.m_6069_() && this.dolphin.m_20280_((Entity)this.player) < 256.0;
        }

        public void m_8056_() {
            this.player.m_147207_(new MobEffectInstance(MobEffects.f_19608_, 100), (Entity)this.dolphin);
        }

        public void m_8041_() {
            this.player = null;
            this.dolphin.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.dolphin.m_21563_().m_24960_((Entity)this.player, (float)(this.dolphin.m_8085_() + 20), (float)this.dolphin.m_8132_());
            if (this.dolphin.m_20280_((Entity)this.player) < 6.25) {
                this.dolphin.m_21573_().m_26573_();
            } else {
                this.dolphin.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
            }
            if (this.player.m_6069_() && this.player.m_9236_().f_46441_.m_188503_(6) == 0) {
                this.player.m_147207_(new MobEffectInstance(MobEffects.f_19608_, 100), (Entity)this.dolphin);
            }
        }
    }

    static class TurtleBreedGoal
    extends BreedGoal {
        private final MobC2023Entity turtle;

        TurtleBreedGoal(MobC2023Entity p_30244_, double p_30245_) {
            super((Animal)p_30244_, p_30245_);
            this.turtle = p_30244_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.turtle.hasEgg();
        }

        protected void m_8026_() {
            ServerPlayer serverplayer = this.f_25113_.m_27592_();
            if (serverplayer == null && this.f_25115_.m_27592_() != null) {
                serverplayer = this.f_25115_.m_27592_();
            }
            if (serverplayer != null) {
                serverplayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayer, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.turtle.setHasEgg(true);
            this.f_25113_.m_146762_(6000);
            this.f_25115_.m_146762_(6000);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource randomsource = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), randomsource.m_188503_(7) + 1));
            }
        }
    }

    static class TurtleGoToWaterGoal
    extends MoveToBlockGoal {
        private static final int GIVE_UP_TICKS = 1200;
        private final MobC2023Entity turtle;

        TurtleGoToWaterGoal(MobC2023Entity p_30262_, double p_30263_) {
            super((PathfinderMob)p_30262_, p_30262_.m_6162_() ? 2.0 : p_30263_, 24);
            this.turtle = p_30262_;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.turtle.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.turtle.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            if (this.turtle.m_6162_() && !this.turtle.m_20069_()) {
                return super.m_8036_();
            }
            return !this.turtle.isGoingHome() && !this.turtle.m_20069_() ? super.m_8036_() : false;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader p_30270_, BlockPos p_30271_) {
            return p_30270_.m_8055_(p_30271_).m_60713_(Blocks.f_49990_);
        }
    }

    static class TurtleGoHomeGoal
    extends Goal {
        private final MobC2023Entity turtle;
        private final double speedModifier;
        private boolean stuck;
        private int closeToHomeTryTicks;
        private static final int GIVE_UP_TICKS = 600;

        TurtleGoHomeGoal(MobC2023Entity p_30253_, double p_30254_) {
            this.turtle = p_30253_;
            this.speedModifier = p_30254_;
        }

        public boolean m_8036_() {
            if (this.turtle.m_6162_()) {
                return false;
            }
            if (this.turtle.m_217043_().m_188503_(TurtleGoHomeGoal.m_186073_((int)700)) != 0) {
                return false;
            }
            return !this.turtle.getHomePos().m_203195_((Position)this.turtle.m_20182_(), 64.0);
        }

        public void m_8056_() {
            this.turtle.setGoingHome(true);
            this.stuck = false;
            this.closeToHomeTryTicks = 0;
        }

        public void m_8041_() {
            this.turtle.setGoingHome(false);
        }

        public boolean m_8045_() {
            return !this.turtle.getHomePos().m_203195_((Position)this.turtle.m_20182_(), 7.0) && !this.stuck && this.closeToHomeTryTicks <= this.m_183277_(600);
        }

        public void m_8037_() {
            BlockPos blockpos = this.turtle.getHomePos();
            boolean flag = blockpos.m_203195_((Position)this.turtle.m_20182_(), 16.0);
            if (flag) {
                ++this.closeToHomeTryTicks;
            }
            if (this.turtle.m_21573_().m_26571_()) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)blockpos);
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)16, (int)3, (Vec3)vec3, (double)0.3141592741012573);
                if (vec31 == null) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)8, (int)7, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 != null && !flag && !this.turtle.m_9236_().m_8055_(BlockPos.m_274446_((Position)vec31)).m_60713_(Blocks.f_49990_)) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)16, (int)5, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 == null) {
                    this.stuck = true;
                    return;
                }
                this.turtle.m_21573_().m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
            }
        }
    }

    static class TurtleTravelGoal
    extends Goal {
        private final MobC2023Entity turtle;
        private final double speedModifier;
        private boolean stuck;

        TurtleTravelGoal(MobC2023Entity p_30333_, double p_30334_) {
            this.turtle = p_30333_;
            this.speedModifier = p_30334_;
        }

        public boolean m_8036_() {
            return !this.turtle.isGoingHome() && this.turtle.m_20069_();
        }

        public void m_8056_() {
            int i = 512;
            int j = 4;
            RandomSource randomsource = this.turtle.f_19796_;
            int k = randomsource.m_188503_(1025) - 512;
            int l = randomsource.m_188503_(9) - 4;
            int i1 = randomsource.m_188503_(1025) - 512;
            if ((double)l + this.turtle.m_20186_() > (double)(this.turtle.m_9236_().m_5736_() - 1)) {
                l = 0;
            }
            BlockPos blockpos = BlockPos.m_274561_((double)((double)k + this.turtle.m_20185_()), (double)((double)l + this.turtle.m_20186_()), (double)((double)i1 + this.turtle.m_20189_()));
            this.turtle.setTravelPos(blockpos);
            this.turtle.setTravelling(true);
            this.stuck = false;
        }

        public void m_8037_() {
            if (this.turtle.m_21573_().m_26571_()) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)this.turtle.getTravelPos());
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)16, (int)3, (Vec3)vec3, (double)0.3141592741012573);
                if (vec31 == null) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)8, (int)7, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 != null) {
                    int i = Mth.m_14107_((double)vec31.f_82479_);
                    int j = Mth.m_14107_((double)vec31.f_82481_);
                    int k = 34;
                    if (!this.turtle.m_9236_().m_151572_(i - 34, j - 34, i + 34, j + 34)) {
                        vec31 = null;
                    }
                }
                if (vec31 == null) {
                    this.stuck = true;
                    return;
                }
                this.turtle.m_21573_().m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
            }
        }

        public boolean m_8045_() {
            return !this.turtle.m_21573_().m_26571_() && !this.stuck && !this.turtle.isGoingHome() && !this.turtle.m_27593_();
        }

        public void m_8041_() {
            this.turtle.setTravelling(false);
            super.m_8041_();
        }
    }

    static class TurtleRandomStrollGoal
    extends RandomStrollGoal {
        private final MobC2023Entity turtle;

        TurtleRandomStrollGoal(MobC2023Entity p_30303_, double p_30304_, int p_30305_) {
            super((PathfinderMob)p_30303_, p_30304_, p_30305_);
            this.turtle = p_30303_;
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_20069_() && !this.turtle.isGoingHome() ? super.m_8036_() : false;
        }
    }

    static class TurtlePathNavigation
    extends AmphibiousPathNavigation {
        TurtlePathNavigation(MobC2023Entity p_30294_, Level p_30295_) {
            super((Mob)p_30294_, p_30295_);
        }

        public boolean m_6342_(BlockPos p_30300_) {
            MobC2023Entity turtle;
            Mob mob = this.f_26494_;
            if (mob instanceof MobC2023Entity && (turtle = (MobC2023Entity)mob).isTravelling()) {
                return this.f_26495_.m_8055_(p_30300_).m_60713_(Blocks.f_49990_);
            }
            return !this.f_26495_.m_8055_(p_30300_.m_7495_()).m_60795_();
        }
    }
}

