/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MushroomChickenEntity
extends Animal
implements Shearable,
IForgeShearable {
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.m_135353_(MushroomChickenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final int MUTATE_CHANCE = 1024;
    @javax.annotation.Nullable
    private MobEffect effect;
    private int effectDuration;
    @javax.annotation.Nullable
    private UUID lastLightningBoltUUID;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_, Items.f_271133_, Items.f_276594_});
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public int eggTime = this.f_19796_.m_188503_(6000) + 6000;
    public boolean isChickenJockey;

    public MushroomChickenEntity(EntityType<? extends MushroomChickenEntity> p_28914_, Level p_28915_) {
        super(p_28914_, p_28915_);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected float m_6431_(Pose p_28251_, EntityDimensions p_28252_) {
        return this.m_6162_() ? p_28252_.f_20378_ * 0.85f : p_28252_.f_20378_ * 0.92f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_8107_() {
        super.m_8107_();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.m_20096_() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && !this.isChickenJockey() && --this.eggTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)Items.f_42521_);
            this.m_146850_(GameEvent.f_157810_);
            this.eggTime = this.f_19796_.m_188503_(6000) + 6000;
        }
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11750_;
    }

    protected SoundEvent m_7975_(DamageSource p_28262_) {
        return SoundEvents.f_11753_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11751_;
    }

    protected void m_7355_(BlockPos p_28254_, BlockState p_28255_) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public boolean m_6898_(ItemStack p_28271_) {
        return FOOD_ITEMS.test(p_28271_);
    }

    public int m_213860_() {
        return this.isChickenJockey() ? 10 : super.m_213860_();
    }

    public float m_5610_(BlockPos p_28933_, LevelReader p_28934_) {
        return p_28934_.m_8055_(p_28933_.m_7495_()).m_60713_(Blocks.f_50195_) ? 10.0f : p_28934_.m_220419_(p_28933_);
    }

    public static boolean checkMushroomSpawnRules(EntityType<MushroomChickenEntity> p_218201_, LevelAccessor p_218202_, MobSpawnType p_218203_, BlockPos p_218204_, RandomSource p_218205_) {
        return p_218202_.m_8055_(p_218204_.m_7495_()).m_204336_(BlockTags.f_184231_) && MushroomChickenEntity.m_186209_((BlockAndTintGetter)p_218202_, (BlockPos)p_218204_);
    }

    public void m_8038_(ServerLevel p_28921_, LightningBolt p_28922_) {
        UUID uuid = p_28922_.m_20148_();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == MushroomType.RED ? MushroomType.BROWN : MushroomType.RED);
            this.lastLightningBoltUUID = uuid;
            this.m_5496_(SoundEvents.f_12071_, 2.0f, 1.0f);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE, (Object)MushroomType.RED.type);
    }

    public InteractionResult m_6071_(Player p_28941_, InteractionHand p_28942_) {
        ItemStack itemstack = p_28941_.m_21120_(p_28942_);
        if (itemstack.m_150930_(Items.f_42399_) && !this.m_6162_()) {
            ItemStack itemstack1;
            boolean flag = false;
            if (this.effect != null) {
                flag = true;
                itemstack1 = new ItemStack((ItemLike)Items.f_42718_);
                SuspiciousStewItem.m_43258_((ItemStack)itemstack1, (MobEffect)this.effect, (int)this.effectDuration);
                this.effect = null;
                this.effectDuration = 0;
            } else {
                itemstack1 = new ItemStack((ItemLike)Items.f_42400_);
            }
            ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)itemstack, (Player)p_28941_, (ItemStack)itemstack1, (boolean)false);
            p_28941_.m_21008_(p_28942_, itemstack2);
            SoundEvent soundevent = flag ? SoundEvents.f_12074_ : SoundEvents.f_12073_;
            this.m_5496_(soundevent, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.getVariant() == MushroomType.BROWN && itemstack.m_204117_(ItemTags.f_13145_)) {
            if (this.effect != null) {
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + this.f_19796_.m_188500_() / 2.0, this.m_20227_(0.5), this.m_20189_() + this.f_19796_.m_188500_() / 2.0, 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                }
            } else {
                Optional<Pair<MobEffect, Integer>> optional = this.getEffectFromItemStack(itemstack);
                if (!optional.isPresent()) {
                    return InteractionResult.PASS;
                }
                Pair<MobEffect, Integer> pair = optional.get();
                if (!p_28941_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                for (int j = 0; j < 4; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123806_, this.m_20185_() + this.f_19796_.m_188500_() / 2.0, this.m_20227_(0.5), this.m_20189_() + this.f_19796_.m_188500_() / 2.0, 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                }
                this.effect = (MobEffect)pair.getLeft();
                this.effectDuration = (Integer)pair.getRight();
                this.m_5496_(SoundEvents.f_12072_, 2.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_28941_, p_28942_);
    }

    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level world, BlockPos pos, int fortune) {
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        return this.shearInternal(player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS);
    }

    public void m_5851_(SoundSource p_28924_) {
        this.shearInternal(p_28924_).forEach(s -> this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), s)));
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.m_6162_();
    }

    private List<ItemStack> shearInternal(SoundSource p_28924_) {
        Chicken cow;
        this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12075_, p_28924_, 1.0f, 1.0f);
        if (!this.m_9236_().m_5776_() && (cow = (Chicken)EntityType.f_20555_.m_20615_(this.m_9236_())) != null) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
            cow.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            cow.m_21153_(this.m_21223_());
            cow.f_20883_ = this.f_20883_;
            if (this.m_8077_()) {
                cow.m_6593_(this.m_7770_());
                cow.m_20340_(this.m_20151_());
            }
            if (this.m_21532_()) {
                cow.m_21530_();
            }
            cow.m_20331_(this.m_20147_());
            this.m_9236_().m_7967_((Entity)cow);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < 5; ++i) {
                items.add(new ItemStack((ItemLike)this.getVariant().blockState.m_60734_()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public boolean m_6785_(double p_28266_) {
        return this.isChickenJockey();
    }

    protected void m_19956_(Entity p_289537_, Entity.MoveFunction p_289541_) {
        super.m_19956_(p_289537_, p_289541_);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        p_289541_.m_20372_(p_289537_, this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.5) + p_289537_.m_6049_() + 0.0, this.m_20189_() - (double)(0.1f * f1));
        if (p_289537_ instanceof LivingEntity) {
            ((LivingEntity)p_289537_).f_20883_ = this.f_20883_;
        }
    }

    public boolean isChickenJockey() {
        return this.isChickenJockey;
    }

    public void setChickenJockey(boolean p_28274_) {
        this.isChickenJockey = p_28274_;
    }

    public void m_7380_(CompoundTag p_28944_) {
        super.m_7380_(p_28944_);
        p_28944_.m_128359_("Type", this.getVariant().m_7912_());
        if (this.effect != null) {
            p_28944_.m_128405_("EffectId", MobEffect.m_19459_((MobEffect)this.effect));
            ForgeHooks.saveMobEffect((CompoundTag)p_28944_, (String)"forge:effect_id", (MobEffect)this.effect);
            p_28944_.m_128405_("EffectDuration", this.effectDuration);
        }
        p_28944_.m_128379_("IsChickenJockey", this.isChickenJockey);
        p_28944_.m_128405_("EggLayTime", this.eggTime);
    }

    public void m_7378_(CompoundTag p_28936_) {
        super.m_7378_(p_28936_);
        this.setVariant(MushroomType.byType(p_28936_.m_128461_("Type")));
        if (p_28936_.m_128425_("EffectId", 99)) {
            this.effect = MobEffect.m_19453_((int)p_28936_.m_128451_("EffectId"));
            this.effect = ForgeHooks.loadMobEffect((CompoundTag)p_28936_, (String)"forge:effect_id", (MobEffect)this.effect);
        }
        if (p_28936_.m_128425_("EffectDuration", 99)) {
            this.effectDuration = p_28936_.m_128451_("EffectDuration");
        }
        this.isChickenJockey = p_28936_.m_128471_("IsChickenJockey");
        if (p_28936_.m_128441_("EggLayTime")) {
            this.eggTime = p_28936_.m_128451_("EggLayTime");
        }
    }

    private Optional<Pair<MobEffect, Integer>> getEffectFromItemStack(ItemStack p_28957_) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.m_257980_((ItemLike)p_28957_.m_41720_());
        return suspiciouseffectholder != null ? Optional.of(Pair.of((Object)suspiciouseffectholder.m_53521_(), (Object)suspiciouseffectholder.m_53522_())) : Optional.empty();
    }

    public void setVariant(MushroomType p_28929_) {
        this.f_19804_.m_135381_(DATA_TYPE, (Object)p_28929_.type);
    }

    public MushroomType getVariant() {
        return MushroomType.byType((String)this.f_19804_.m_135370_(DATA_TYPE));
    }

    @javax.annotation.Nullable
    public MushroomChickenEntity getBreedOffspring(ServerLevel p_148942_, AgeableMob p_148943_) {
        MushroomChickenEntity mushroomcow = (MushroomChickenEntity)((EntityType)TTEntityRegistry.MUSHROOM_CHICKEN.get()).m_20615_((Level)p_148942_);
        if (mushroomcow != null) {
            mushroomcow.setVariant(this.getOffspringType((MushroomChickenEntity)p_148943_));
        }
        return mushroomcow;
    }

    private MushroomType getOffspringType(MushroomChickenEntity p_28931_) {
        MushroomType mushroomcow$mushroomtype1;
        MushroomType mushroomcow$mushroomtype = this.getVariant();
        MushroomType mushroomcow$mushroomtype2 = mushroomcow$mushroomtype == (mushroomcow$mushroomtype1 = p_28931_.getVariant()) && this.f_19796_.m_188503_(1024) == 0 ? (mushroomcow$mushroomtype == MushroomType.BROWN ? MushroomType.RED : MushroomType.BROWN) : (this.f_19796_.m_188499_() ? mushroomcow$mushroomtype : mushroomcow$mushroomtype1);
        return mushroomcow$mushroomtype2;
    }

    public boolean isShearable(@NotNull ItemStack item, Level world, BlockPos pos) {
        return this.m_6220_();
    }

    private static /* synthetic */ void lambda$mobInteract$0(InteractionHand p_28942_, Player p_28927_) {
        p_28927_.m_21190_(p_28942_);
    }

    public static enum MushroomType implements StringRepresentable
    {
        RED("red", Blocks.f_50073_.m_49966_()),
        BROWN("brown", Blocks.f_50072_.m_49966_());

        public static final StringRepresentable.EnumCodec<MushroomType> CODEC;
        final String type;
        final BlockState blockState;

        private MushroomType(String p_28967_, BlockState p_28968_) {
            this.type = p_28967_;
            this.blockState = p_28968_;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public String m_7912_() {
            return this.type;
        }

        static MushroomType byType(String p_28977_) {
            return (MushroomType)CODEC.m_262792_(p_28977_, (Enum)RED);
        }

        static {
            CODEC = StringRepresentable.m_216439_(MushroomType::values);
        }
    }
}

