/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTBlockRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTItemRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTSoundsRegistry;
import com.belgieyt.trailsandtalesplus.Objects.blocks.DirtyGrassBlock;
import com.belgieyt.trailsandtalesplus.TTConfigs;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class OstrichEntity
extends AbstractHorse
implements RiderShieldingMount,
Saddleable {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAYING_EGG = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int layEggCounter;
    public static final Ingredient TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_});
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public final AnimationState diggingAnimationState = new AnimationState();

    public OstrichEntity(EntityType<? extends OstrichEntity> p_28285_, Level p_28286_) {
        super(p_28285_, p_28286_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(1, (Goal)new TurtleBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new OstrichLayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TTItemRegistry.TERMITE.get()}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void setHomePos(BlockPos p_30220_) {
        this.f_19804_.m_135381_(HOME_POS, (Object)p_30220_);
    }

    BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    void setHasEgg(boolean p_30235_) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)p_30235_);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(LAYING_EGG);
    }

    void setLayingEgg(boolean p_30237_) {
        this.layEggCounter = p_30237_ ? 1 : 0;
        this.f_19804_.m_135381_(LAYING_EGG, (Object)p_30237_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 16.0);
    }

    public boolean m_203441_(FluidState p_204067_) {
        return p_204067_.m_205070_(FluidTags.f_13131_);
    }

    private void floatStrider() {
        if (this.m_20069_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_().m_6625_(2), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13131_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ == 66) {
            this.diggingAnimationState.m_216977_(this.f_19797_);
            this.m_20256_(Vec3.f_82478_);
        } else if (p_219360_ == 67) {
            this.diggingAnimationState.m_216973_();
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
            this.setLayingEgg(false);
        } else {
            super.m_7822_(p_219360_);
        }
    }

    public boolean m_6898_(ItemStack p_248671_) {
        return TEMPTATION_ITEM.test(p_248671_);
    }

    protected boolean m_5994_(Player p_249923_, ItemStack p_248995_) {
        SoundEvent soundevent;
        boolean flag2;
        boolean flag1;
        boolean flag;
        if (!this.m_6898_(p_248995_)) {
            return false;
        }
        boolean bl = flag = this.m_21223_() < this.m_21233_();
        if (flag) {
            this.m_5634_(2.0f);
        }
        boolean bl2 = flag1 = this.m_30614_() && this.m_146764_() == 0 && this.m_5957_();
        if (flag1) {
            this.m_27595_(p_249923_);
        }
        if (flag2 = this.m_6162_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146758_(10);
            }
        }
        if (!(flag || flag1 || flag2)) {
            return false;
        }
        if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        return true;
    }

    protected boolean m_245259_() {
        return false;
    }

    public boolean m_7848_(Animal p_251650_) {
        if (p_251650_ != this && p_251650_ instanceof OstrichEntity) {
            OstrichEntity camel = (OstrichEntity)p_251650_;
            if (this.m_30628_() && camel.m_30628_()) {
                return true;
            }
        }
        return false;
    }

    public boolean m_30614_() {
        return true;
    }

    @javax.annotation.Nullable
    public OstrichEntity getBreedOffspring(ServerLevel p_251227_, AgeableMob p_251047_) {
        return (OstrichEntity)((EntityType)TTEntityRegistry.OSTRICH.get()).m_20615_((Level)p_251227_);
    }

    public InteractionResult m_6071_(Player p_249032_, InteractionHand p_251004_) {
        ItemStack itemstack = p_249032_.m_21120_(p_251004_);
        if (p_249032_.m_36341_() && !this.m_6162_()) {
            this.m_213583_(p_249032_);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult interactionresult = itemstack.m_41647_(p_249032_, (LivingEntity)this, p_251004_);
        if (interactionresult.m_19077_()) {
            return interactionresult;
        }
        if (this.m_6898_(itemstack)) {
            return this.m_30580_(p_249032_, itemstack);
        }
        if (this.m_20197_().size() < 2 && !this.m_6162_()) {
            this.m_6835_(p_249032_);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(LAYING_EGG, (Object)false);
        this.f_19804_.m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
    }

    public void m_7380_(CompoundTag p_30176_) {
        super.m_7380_(p_30176_);
        p_30176_.m_128379_("HasEgg", this.hasEgg());
        p_30176_.m_128405_("HomePosX", this.getHomePos().m_123341_());
        p_30176_.m_128405_("HomePosY", this.getHomePos().m_123342_());
        p_30176_.m_128405_("HomePosZ", this.getHomePos().m_123343_());
    }

    public void m_7378_(CompoundTag p_30162_) {
        super.m_7378_(p_30162_);
        this.setHasEgg(p_30162_.m_128471_("HasEgg"));
        int i = p_30162_.m_128451_("HomePosX");
        int j = p_30162_.m_128451_("HomePosY");
        int k = p_30162_.m_128451_("HomePosZ");
        this.setHomePos(new BlockPos(i, j, k));
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_30153_, DifficultyInstance p_30154_, MobSpawnType p_30155_, @javax.annotation.Nullable SpawnGroupData p_30156_, @javax.annotation.Nullable CompoundTag p_30157_) {
        this.setHomePos(this.m_20183_());
        return super.m_6518_(p_30153_, p_30154_, p_30155_, p_30156_, p_30157_);
    }

    public void m_8119_() {
        super.m_8119_();
        this.floatStrider();
        this.m_20101_();
        this.emitDiggingParticles();
        if (!((Boolean)TTConfigs.CAN_OSTRICH_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
    }

    public double m_262813_() {
        return 0.5;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TTSoundsRegistry.OSTRICH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_28306_) {
        return (SoundEvent)TTSoundsRegistry.OSTRICH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TTSoundsRegistry.OSTRICH_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected float m_6431_(Pose p_28295_, EntityDimensions p_28296_) {
        return this.m_6162_() ? p_28296_.f_20378_ * 0.95f : 2.4f;
    }

    protected float m_245547_(Player p_278317_) {
        float f = 0.1f;
        if (this.m_20069_()) {
            return (float)this.m_21133_(Attributes.f_22279_) - f;
        }
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    @javax.annotation.Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            return (Mob)entity;
        }
        entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public boolean m_7132_() {
        return false;
    }

    public boolean m_6741_() {
        return true;
    }

    public void m_5853_(@Nullable SoundSource p_21748_) {
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.hasEgg();
    }

    public boolean m_6254_() {
        return true;
    }

    public float m_5610_(BlockPos p_30159_, LevelReader p_30160_) {
        if (p_30160_.m_6425_(p_30159_).m_205070_(FluidTags.f_13131_)) {
            return 10.0f;
        }
        return DirtyGrassBlock.onSand((BlockGetter)p_30160_, p_30159_) ? 10.0f : p_30160_.m_220419_(p_30159_);
    }

    private BlockPos getHeadBlock() {
        Vec3 vec3 = this.getHeadPosition();
        return BlockPos.m_274561_((double)vec3.m_7096_(), (double)(this.m_20186_() + (double)0.2f), (double)vec3.m_7094_());
    }

    private Vec3 getHeadPosition() {
        return this.m_20182_().m_82549_(this.m_20156_().m_82490_(1.25));
    }

    private OstrichEntity emitDiggingParticles() {
        if (this.isLayingEgg()) {
            BlockPos blockpos = this.getHeadBlock();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos.m_7495_());
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 vec3 = Vec3.m_82512_((Vec3i)blockpos).m_82520_(0.0, (double)-0.65f, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
                }
                if (this.f_19797_ % 10 == 0) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), blockstate.getSoundType((LevelReader)this.m_9236_(), blockpos.m_7495_(), (Entity)this).m_56778_(), this.m_5720_(), 0.5f, 0.5f, false);
                }
            }
        }
        return this;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0) {
            BlockPos blockpos = this.m_20183_();
            if (DirtyGrassBlock.onSand((BlockGetter)this.m_9236_(), blockpos)) {
                this.m_9236_().m_46796_(2001, blockpos, Block.m_49956_((BlockState)this.m_9236_().m_8055_(blockpos.m_7495_())));
            }
        }
    }

    static class TurtleBreedGoal
    extends BreedGoal {
        private final OstrichEntity turtle;

        TurtleBreedGoal(OstrichEntity p_30244_, double p_30245_) {
            super((Animal)p_30244_, p_30245_);
            this.turtle = p_30244_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.turtle.hasEgg();
        }

        protected void m_8026_() {
            ServerPlayer serverplayer = this.f_25113_.m_27592_();
            if (serverplayer == null && this.f_25115_.m_27592_() != null) {
                serverplayer = this.f_25115_.m_27592_();
            }
            if (serverplayer != null) {
                serverplayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayer, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.turtle.setHasEgg(true);
            this.f_25113_.m_146762_(6000);
            this.f_25115_.m_146762_(6000);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource randomsource = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), randomsource.m_188503_(7) + 1));
            }
        }
    }

    static class OstrichLayEggGoal
    extends MoveToBlockGoal {
        private final OstrichEntity ostrich;

        OstrichLayEggGoal(OstrichEntity p_30276_, double p_30277_) {
            super((PathfinderMob)p_30276_, p_30277_, 16);
            this.ostrich = p_30276_;
        }

        public boolean m_8036_() {
            return this.ostrich.hasEgg() && this.ostrich.m_9236_().m_8055_(this.ostrich.getHeadBlock().m_7495_()).m_60713_(Blocks.f_50440_) && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.ostrich.hasEgg() && this.ostrich.m_9236_().m_8055_(this.ostrich.getHeadBlock().m_7495_()).m_60713_(Blocks.f_50440_);
        }

        public void m_8056_() {
            this.ostrich.m_9236_().m_7605_((Entity)this.ostrich, (byte)66);
            super.m_8056_();
        }

        public void m_8041_() {
            this.ostrich.m_9236_().m_7605_((Entity)this.ostrich, (byte)67);
            super.m_8041_();
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockpos = this.ostrich.m_20183_();
            if (!this.ostrich.m_20069_() && this.m_25625_()) {
                if (this.ostrich.layEggCounter < 1) {
                    this.ostrich.setLayingEgg(true);
                } else if (this.ostrich.layEggCounter > this.m_183277_(200)) {
                    Level level = this.ostrich.m_9236_();
                    level.m_5594_((Player)null, blockpos, SoundEvents.f_279531_, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                    BlockPos blockpos1 = this.ostrich.getHeadBlock().m_7495_();
                    this.ostrich.f_21365_.m_24946_((double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_());
                    BlockState blockstate = (BlockState)((Block)TTBlockRegistry.DIRTY_GRASS_BLOCK.get()).m_49966_().m_61124_((Property)DirtyGrassBlock.EGGS, (Comparable)Integer.valueOf(this.ostrich.f_19796_.m_188503_(4) + 1));
                    level.m_7731_(blockpos1, blockstate, 3);
                    level.m_220407_(GameEvent.f_157797_, blockpos1, GameEvent.Context.m_223719_((Entity)this.ostrich, (BlockState)blockstate));
                    this.ostrich.setHasEgg(false);
                    this.ostrich.setLayingEgg(false);
                    this.ostrich.m_27601_(600);
                    if (level.f_46441_.m_188501_() < 0.5f) {
                        ItemEntity itementity = new ItemEntity(level, this.ostrich.m_20185_() + 0.5, this.ostrich.m_20186_() + 0.1, this.ostrich.m_20189_() + 0.5, new ItemStack((ItemLike)TTItemRegistry.TERMITE.get(), 1));
                        level.m_7967_((Entity)itementity);
                    }
                }
                if (this.ostrich.isLayingEgg()) {
                    ++this.ostrich.layEggCounter;
                }
            }
        }

        protected boolean m_6465_(LevelReader p_30280_, BlockPos p_30281_) {
            return !p_30280_.m_46859_(p_30281_.m_7494_()) ? false : OstrichLayEggGoal.isSand((BlockGetter)p_30280_, p_30281_);
        }

        public static boolean isSand(BlockGetter p_57801_, BlockPos p_57802_) {
            return p_57801_.m_8055_(p_57802_).m_60713_(Blocks.f_50440_);
        }
    }
}

