/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTLootTableRegistry;
import com.belgieyt.trailsandtalesplus.TTConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RascalEntity
extends Animal {
    protected static final EntityDataAccessor<Integer> FOUND_DATA = SynchedEntityData.m_135353_(RascalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState VanishAnimationState = new AnimationState();
    public static int VanishTicks = 0;
    public static int TIME_BETWEEN_CLICKS = 0;

    public RascalEntity(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 64.0f, 2.0, 2.2));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        this.setTimeBetweenClicks(0);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 0.75f;
    }

    public void m_8107_() {
        if (this.getTimeBetweenClicks() > 750) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 20, 4, false, false, false));
        }
        super.m_8107_();
    }

    public InteractionResult m_6071_(Player p_28298_, InteractionHand p_28299_) {
        if (this.getFoundStage() < 2 && !this.m_6162_() && this.getTimeBetweenClicks() == 0) {
            this.IncreaseFoundStage();
            this.setTimeBetweenClicks(1500);
            Level level = p_28298_.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                this.FleefromPlayer(level2);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.getFoundStage() == 2 && !this.m_6162_() && this.getTimeBetweenClicks() == 0) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123759_);
            this.VanishAnimationState.m_216982_(this.f_19797_);
            this.IncreaseFoundStage();
            VanishTicks = 75;
            if (!this.m_9236_().f_46443_) {
                this.giveMorningGift();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_28298_, p_28299_);
    }

    private void FleefromPlayer(ServerLevel level) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        double d3 = this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * 16.0;
        double d4 = Mth.m_14008_((double)(this.m_20186_() + (double)(this.m_217043_().m_188503_(16) - 8)), (double)level.m_141937_(), (double)(level.m_141937_() + level.m_143344_() - 1));
        double d5 = this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * 16.0;
        if (this.m_20159_()) {
            this.m_8127_();
        }
        Vec3 vec3 = this.m_20182_();
        this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
        if (this.m_20984_(d3, d4, d5, false)) {
            this.m_9236_().m_6263_((Player)null, d0, d1, d2, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
    }

    protected void addParticlesAroundSelf(ParticleOptions p_35288_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(p_35288_, this.m_20208_(0.5), this.m_20187_() + 0.5, this.m_20262_(0.5), d0, d1, d2);
        }
    }

    public static boolean checkRascalSpawnRules(EntityType<? extends RascalEntity> p_217018_, ServerLevelAccessor p_217019_, MobSpawnType p_217020_, BlockPos p_217021_, RandomSource p_217022_) {
        return p_217021_.m_123342_() < 63 && !p_217019_.m_45527_(p_217021_);
    }

    public void m_8119_() {
        if (VanishTicks > 0) {
            --VanishTicks;
        }
        if (TIME_BETWEEN_CLICKS > 0) {
            --TIME_BETWEEN_CLICKS;
        }
        if (VanishTicks == 1) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (!((Boolean)TTConfigs.CAN_RASCAL_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    private void giveMorningGift() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        blockpos$mutableblockpos.m_122190_((Vec3i)(this.m_21523_() ? this.m_21524_().m_20183_() : this.m_20183_()));
        blockpos$mutableblockpos.m_122190_((Vec3i)this.m_20183_());
        LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(TTLootTableRegistry.RASCAL_ITEMS);
        LootParams lootparams = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_);
        for (ItemStack itemstack : loottable.m_287195_(lootparams)) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), (double)blockpos$mutableblockpos.m_123341_() - (double)Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))), (double)blockpos$mutableblockpos.m_123342_(), (double)blockpos$mutableblockpos.m_123343_() + (double)Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))), itemstack));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FOUND_DATA, (Object)0);
    }

    public void setFoundStage(int stage) {
        this.f_19804_.m_135381_(FOUND_DATA, (Object)stage);
    }

    public int getFoundStage() {
        return (Integer)this.f_19804_.m_135370_(FOUND_DATA);
    }

    public void setTimeBetweenClicks(int stage) {
        TIME_BETWEEN_CLICKS = stage;
    }

    public int getTimeBetweenClicks() {
        return TIME_BETWEEN_CLICKS;
    }

    public void IncreaseFoundStage() {
        if (this.getFoundStage() < 3) {
            this.setFoundStage(this.getFoundStage() + 1);
        }
    }

    public void RemoveFoundStage() {
        this.setFoundStage(this.getFoundStage() - 1);
    }

    public void m_7380_(CompoundTag p_28867_) {
        super.m_7380_(p_28867_);
        p_28867_.m_128405_("Found", this.getFoundStage());
        p_28867_.m_128405_("Time_Between_finding", this.getTimeBetweenClicks());
    }

    public void m_7378_(CompoundTag p_28857_) {
        super.m_7378_(p_28857_);
        this.setFoundStage(p_28857_.m_128445_("Found"));
        this.setTimeBetweenClicks(p_28857_.m_128445_("Time_Between_finding"));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }
}

