/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTBlockRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTEntityDataRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTItemRegistry;
import com.belgieyt.trailsandtalesplus.Objects.entity.ai.SuspiciousSnifferAI;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SkeletonSnifferEntity
extends Animal {
    private static final int DIGGING_PARTICLES_DELAY_TICKS = 1700;
    private static final int DIGGING_PARTICLES_DURATION_TICKS = 6000;
    private static final int DIGGING_PARTICLES_AMOUNT = 30;
    private static final int DIGGING_DROP_SEED_OFFSET_TICKS = 120;
    private static final int SNIFFER_BABY_AGE_TICKS = 48000;
    private static final float DIGGING_BB_HEIGHT_OFFSET = 0.4f;
    private static final EntityDimensions DIGGING_DIMENSIONS = EntityDimensions.m_20395_((float)((EntityType)TTEntityRegistry.SKELETON_SNIFFER.get()).m_20678_(), (float)(((EntityType)TTEntityRegistry.SKELETON_SNIFFER.get()).m_20679_() - 0.4f));
    private static final EntityDataAccessor<State> DATA_STATE = SynchedEntityData.m_135353_(SkeletonSnifferEntity.class, TTEntityDataRegistry.SNIFFER_STATE);
    private static final EntityDataAccessor<Integer> DATA_DROP_SEED_AT_TICK = SynchedEntityData.m_135353_(SkeletonSnifferEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState feelingHappyAnimationState = new AnimationState();
    public final AnimationState scentingAnimationState = new AnimationState();
    public final AnimationState sniffingAnimationState = new AnimationState();
    public final AnimationState diggingAnimationState = new AnimationState();
    public final AnimationState risingAnimationState = new AnimationState();

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22276_, 14.0);
    }

    public SkeletonSnifferEntity(EntityType<? extends Animal> p_273717_, Level p_273562_) {
        super(p_273717_, p_273562_);
        this.f_19804_.m_135372_(DATA_STATE, (Object)State.IDLING);
        this.f_19804_.m_135372_(DATA_DROP_SEED_AT_TICK, (Object)0);
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CAUTIOUS, -1.0f);
    }

    protected float m_6431_(Pose p_272721_, EntityDimensions p_273353_) {
        return this.m_6972_((Pose)p_272721_).f_20378_ * 0.6f;
    }

    public void m_284177_() {
        super.m_284177_();
        if (this.m_6060_() || this.m_20069_()) {
            this.m_21441_(BlockPathTypes.WATER, 0.0f);
        }
    }

    public void m_284461_() {
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    public EntityDimensions m_6972_(Pose p_286815_) {
        return this.f_19804_.m_285897_(DATA_STATE) && this.getState() == State.DIGGING ? DIGGING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(p_286815_);
    }

    public boolean isPanicking() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_217768_).isPresent();
    }

    public boolean isSearching() {
        return this.getState() == State.SEARCHING;
    }

    public boolean isTempted() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_148198_).orElse(false);
    }

    public boolean canSniff() {
        return !this.isTempted() && !this.isPanicking() && !this.m_20069_() && !this.m_27593_() && this.m_20096_() && !this.m_20159_();
    }

    public boolean canPlayDiggingSound() {
        return this.getState() == State.DIGGING || this.getState() == State.SEARCHING;
    }

    private BlockPos getHeadBlock() {
        Vec3 vec3 = this.getHeadPosition();
        return BlockPos.m_274561_((double)vec3.m_7096_(), (double)(this.m_20186_() + (double)0.2f), (double)vec3.m_7094_());
    }

    private Vec3 getHeadPosition() {
        return this.m_20182_().m_82549_(this.m_20156_().m_82490_(2.25));
    }

    private State getState() {
        return (State)((Object)this.f_19804_.m_135370_(DATA_STATE));
    }

    private SkeletonSnifferEntity setState(State p_273359_) {
        this.f_19804_.m_135381_(DATA_STATE, (Object)p_273359_);
        return this;
    }

    public void m_7350_(EntityDataAccessor<?> p_272936_) {
        if (DATA_STATE.equals(p_272936_)) {
            State sniffer$state = this.getState();
            this.resetAnimations();
            switch (sniffer$state) {
                case SCENTING: {
                    this.scentingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case SNIFFING: {
                    this.sniffingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case DIGGING: {
                    this.diggingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case RISING: {
                    this.risingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case FEELING_HAPPY: {
                    this.feelingHappyAnimationState.m_216982_(this.f_19797_);
                }
            }
            this.m_6210_();
        }
        super.m_7350_(p_272936_);
    }

    private void resetAnimations() {
        this.diggingAnimationState.m_216973_();
        this.sniffingAnimationState.m_216973_();
        this.risingAnimationState.m_216973_();
        this.feelingHappyAnimationState.m_216973_();
        this.scentingAnimationState.m_216973_();
    }

    public SkeletonSnifferEntity transitionTo(State p_273096_) {
        switch (p_273096_) {
            case SCENTING: {
                this.setState(State.SCENTING).onScentingStart();
                break;
            }
            case SNIFFING: {
                this.m_5496_(SoundEvents.f_271283_, 1.0f, 1.0f);
                this.setState(State.SNIFFING);
                break;
            }
            case DIGGING: {
                this.setState(State.DIGGING).onDiggingStart();
                break;
            }
            case RISING: {
                this.m_5496_(SoundEvents.f_271405_, 1.0f, 1.0f);
                this.setState(State.RISING);
                break;
            }
            case FEELING_HAPPY: {
                this.m_5496_(SoundEvents.f_271300_, 1.0f, 1.0f);
                this.setState(State.FEELING_HAPPY);
                break;
            }
            case IDLING: {
                this.setState(State.IDLING);
                break;
            }
            case SEARCHING: {
                this.setState(State.SEARCHING);
            }
        }
        return this;
    }

    private SkeletonSnifferEntity onScentingStart() {
        this.m_5496_(SoundEvents.f_271121_, 1.0f, this.m_6162_() ? 1.3f : 1.0f);
        return this;
    }

    private SkeletonSnifferEntity onDiggingStart() {
        this.f_19804_.m_135381_(DATA_DROP_SEED_AT_TICK, (Object)(this.f_19797_ + 120));
        return this;
    }

    public SkeletonSnifferEntity onDiggingComplete(boolean p_272677_) {
        if (p_272677_) {
            this.storeExploredPosition(this.m_20097_());
        }
        return this;
    }

    public Optional<BlockPos> calculateDigPosition() {
        return IntStream.range(0, 5).mapToObj(p_273771_ -> LandRandomPos.m_148488_((PathfinderMob)this, (int)(10 + 2 * p_273771_), (int)3)).filter(Objects::nonNull).map(BlockPos::m_274446_).filter(p_289451_ -> this.m_9236_().m_6857_().m_61937_(p_289451_)).map(BlockPos::m_7495_).filter(this::canDig).findFirst();
    }

    public boolean canDig() {
        return !this.isPanicking() && !this.isTempted() && !this.m_6162_() && !this.m_20069_() && this.m_20096_() && !this.m_20159_() && this.canDig(this.getHeadBlock().m_7495_());
    }

    private boolean canDig(BlockPos p_272757_) {
        return this.m_9236_().m_8055_(p_272757_).m_204336_(BlockTags.f_271391_) && this.getExploredPositions().noneMatch(p_289453_ -> GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)p_272757_).equals(p_289453_)) && Optional.ofNullable(this.m_21573_().m_7864_(p_272757_, 1)).map(Path::m_77403_).orElse(false) != false;
    }

    private void dropSeed() {
        if (!this.m_9236_().m_5776_() && (Integer)this.f_19804_.m_135370_(DATA_DROP_SEED_AT_TICK) == this.f_19797_) {
            ServerLevel serverlevel = (ServerLevel)this.m_9236_();
            serverlevel.m_7731_(this.getHeadBlock().m_7495_(), ((Block)TTBlockRegistry.SUS_MOSS_BLOCK.get()).m_49966_(), 3);
            this.m_5496_(SoundEvents.f_271330_, 1.0f, 1.0f);
        }
    }

    private SkeletonSnifferEntity emitDiggingParticles(AnimationState p_273528_) {
        boolean flag;
        boolean bl = flag = p_273528_.m_216981_() > 1700L && p_273528_.m_216981_() < 6000L;
        if (flag) {
            BlockPos blockpos = this.getHeadBlock();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos.m_7495_());
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 vec3 = Vec3.m_82512_((Vec3i)blockpos).m_82520_(0.0, (double)-0.65f, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
                }
                if (this.f_19797_ % 10 == 0) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), blockstate.getSoundType((LevelReader)this.m_9236_(), blockpos.m_7495_(), (Entity)this).m_56778_(), this.m_5720_(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.f_19797_ % 10 == 0) {
            this.m_9236_().m_220407_(GameEvent.f_223710_, this.getHeadBlock(), GameEvent.Context.m_223717_((Entity)this));
        }
        return this;
    }

    private SkeletonSnifferEntity storeExploredPosition(BlockPos p_273015_) {
        List list = this.getExploredPositions().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)p_273015_));
        this.m_6274_().m_21879_(MemoryModuleType.f_271415_, list);
        return this;
    }

    private Stream<GlobalPos> getExploredPositions() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_271415_).stream().flatMap(Collection::stream);
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
    }

    public void m_27563_(ServerLevel p_277923_, Animal p_277857_) {
        ItemStack itemstack = new ItemStack((ItemLike)TTItemRegistry.SUSPICIOUS_SNIFFER_SPAWN_EGG.get());
        ItemEntity itementity = new ItemEntity((Level)p_277923_, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemstack);
        itementity.m_32060_();
        this.m_277117_(p_277923_, p_277857_, null);
        this.m_5496_(SoundEvents.f_279531_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        p_277923_.m_7967_((Entity)itementity);
    }

    public void m_6667_(DamageSource p_277689_) {
        this.transitionTo(State.IDLING);
        super.m_6667_(p_277689_);
    }

    public void m_8119_() {
        switch (this.getState()) {
            case DIGGING: {
                this.emitDiggingParticles(this.diggingAnimationState).dropSeed();
                break;
            }
            case SEARCHING: {
                this.playSearchingSound();
            }
        }
        super.m_8119_();
    }

    public InteractionResult m_6071_(Player p_273046_, InteractionHand p_272687_) {
        ItemStack itemstack = p_273046_.m_21120_(p_272687_);
        boolean flag = this.m_6898_(itemstack);
        InteractionResult interactionresult = super.m_6071_(p_273046_, p_272687_);
        if (interactionresult.m_19077_() && flag) {
            this.m_9236_().m_6269_((Player)null, (Entity)this, this.m_7866_(itemstack), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
        }
        return interactionresult;
    }

    public double m_6048_() {
        return 1.8;
    }

    public float m_278726_() {
        return super.m_278726_() + 0.3f;
    }

    private void playSearchingSound() {
        if (this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_271418_, this.m_5720_(), 1.0f, 1.0f, false);
        }
    }

    protected void m_7355_(BlockPos p_272953_, BlockState p_273729_) {
        this.m_5496_(SoundEvents.f_271325_, 0.15f, 1.0f);
    }

    public SoundEvent m_7866_(ItemStack p_272747_) {
        return SoundEvents.f_271147_;
    }

    protected SoundEvent m_7515_() {
        return Set.of(State.DIGGING, State.SEARCHING).contains((Object)this.getState()) ? null : SoundEvents.f_271535_;
    }

    protected SoundEvent m_7975_(DamageSource p_273718_) {
        return SoundEvents.f_271520_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_271214_;
    }

    public int m_8085_() {
        return 50;
    }

    public void m_6863_(boolean p_272995_) {
        this.m_146762_(p_272995_ ? -48000 : 0);
    }

    public AgeableMob m_142606_(ServerLevel p_273401_, AgeableMob p_273310_) {
        return (AgeableMob)((EntityType)TTEntityRegistry.SKELETON_SNIFFER.get()).m_20615_((Level)p_273401_);
    }

    public boolean m_7848_(Animal p_272966_) {
        if (!(p_272966_ instanceof SkeletonSnifferEntity)) {
            return false;
        }
        SkeletonSnifferEntity sniffer = (SkeletonSnifferEntity)p_272966_;
        Set<State> set = Set.of(State.IDLING, State.SCENTING, State.FEELING_HAPPY);
        return set.contains((Object)this.getState()) && set.contains((Object)sniffer.getState()) && super.m_7848_(p_272966_);
    }

    public AABB m_6921_() {
        return super.m_6921_().m_82400_((double)0.6f);
    }

    public boolean m_6898_(ItemStack p_273659_) {
        return p_273659_.m_204117_(ItemTags.f_271449_);
    }

    protected Brain<?> m_8075_(Dynamic<?> p_273174_) {
        return SuspiciousSnifferAI.makeBrain((Brain<SkeletonSnifferEntity>)this.m_5490_().m_22073_(p_273174_));
    }

    public Brain<SkeletonSnifferEntity> m_6274_() {
        return super.m_6274_();
    }

    protected Brain.Provider<SkeletonSnifferEntity> m_5490_() {
        return Brain.m_21923_(SuspiciousSnifferAI.MEMORY_TYPES, SuspiciousSnifferAI.SENSOR_TYPES);
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("snifferBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_6182_("snifferActivityUpdate");
        SuspiciousSnifferAI.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public static enum State {
        IDLING,
        FEELING_HAPPY,
        SCENTING,
        SNIFFING,
        SEARCHING,
        DIGGING,
        RISING;

    }
}

