/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.Objects.TTBlockRegistry;
import com.belgieyt.trailsandtalesplus.Objects.TTSoundsRegistry;
import com.belgieyt.trailsandtalesplus.TTConfigs;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class SnarelingEntity
extends Monster {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final int DELAY_BETWEEN_CREEPY_STARE_SOUND = 400;
    private static final int MIN_DEAGGRESSION_TIME = 600;
    private static final EntityDataAccessor<Optional<BlockState>> DATA_CARRY_STATE = SynchedEntityData.m_135353_(SnarelingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);
    private static final EntityDataAccessor<Boolean> DATA_CREEPY = SynchedEntityData.m_135353_(SnarelingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_STARED_AT = SynchedEntityData.m_135353_(SnarelingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastStareSound = Integer.MIN_VALUE;
    private int targetChangeTime;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private int spawngooTicks;
    @Nullable
    private UUID persistentAngerTarget;
    public AnimationState attackAnimationState = new AnimationState();
    public final AnimationState IdleAnimationState = new AnimationState();
    public final AnimationState GoopAnimationState = new AnimationState();

    public SnarelingEntity(EntityType<? extends SnarelingEntity> p_32485_, Level p_32486_) {
        super(p_32485_, p_32486_);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            this.attackAnimationState.m_216973_();
        }
        if (p_219360_ == 64) {
            this.GoopAnimationState.m_216977_(this.f_19797_);
        }
    }

    protected float m_6121_() {
        return 0.5f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new EndermanLeaveBlockGoal(this));
        this.f_21345_.m_25352_(11, (Goal)new EndermanTakeBlockGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.IdleAnimationState.m_246184_(this.m_20096_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (this.spawngooTicks > 0) {
            --this.spawngooTicks;
        }
        if (!((Boolean)TTConfigs.CAN_SNARELING_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void m_6710_(@Nullable LivingEntity p_32537_) {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (p_32537_ == null) {
            this.targetChangeTime = 0;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)false);
            this.f_19804_.m_135381_(DATA_STARED_AT, (Object)false);
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        } else {
            this.targetChangeTime = this.f_19797_;
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)true);
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        }
        super.m_6710_(p_32537_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CARRY_STATE, Optional.empty());
        this.f_19804_.m_135372_(DATA_CREEPY, (Object)false);
        this.f_19804_.m_135372_(DATA_STARED_AT, (Object)false);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void setRemainingPersistentAngerTime(int p_32515_) {
        this.remainingPersistentAngerTime = p_32515_;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_32509_) {
        this.persistentAngerTarget = p_32509_;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void playStareSound() {
        if (this.f_19797_ >= this.lastStareSound + 400) {
            this.lastStareSound = this.f_19797_;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_11851_, this.m_5720_(), 2.5f, 1.0f, false);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_32513_) {
        if (DATA_CREEPY.equals(p_32513_) && this.hasBeenStaredAt() && this.m_9236_().f_46443_) {
            this.playStareSound();
        }
        super.m_7350_(p_32513_);
    }

    public void m_7380_(CompoundTag p_32520_) {
        super.m_7380_(p_32520_);
        BlockState blockstate = this.getCarriedBlock();
        if (blockstate != null) {
            p_32520_.m_128365_("carriedBlockState", (Tag)NbtUtils.m_129202_((BlockState)blockstate));
        }
    }

    public void m_7378_(CompoundTag p_32511_) {
        super.m_7378_(p_32511_);
        BlockState blockstate = null;
        if (p_32511_.m_128425_("carriedBlockState", 10) && (blockstate = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)p_32511_.m_128469_("carriedBlockState"))).m_60795_()) {
            blockstate = null;
        }
        this.setCarriedBlock(blockstate);
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        return 2.35f;
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        this.f_20899_ = false;
        if (!this.m_9236_().f_46443_ && this.f_19797_ >= this.targetChangeTime + 600 && this.m_5448_() != null) {
            this.teleportTowards((Entity)this.m_5448_());
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    protected void m_8024_() {
        float f;
        if (this.m_9236_().m_46461_() && this.f_19797_ >= this.targetChangeTime + 600 && (f = this.m_213856_()) > 0.5f && this.m_9236_().m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleport();
        }
        if (this.m_5448_() != null) {
            LivingEntity player = this.m_5448_();
            if (this.spawngooTicks != 0) {
                return;
            }
            BlockPos playerpos = player.m_20183_();
            int radius = 8;
            for (Entity attacker : this.m_9236_().m_45933_((Entity)player, new AABB((double)(playerpos.m_123341_() - radius), (double)(playerpos.m_123342_() - radius), (double)(playerpos.m_123343_() - radius), (double)(playerpos.m_123341_() + radius), (double)(playerpos.m_123342_() + radius), (double)(playerpos.m_123343_() + radius)))) {
                if (!(attacker instanceof SnarelingEntity)) continue;
                BlockPos epos = attacker.m_20183_();
                if (!this.m_9236_().m_8055_(playerpos).m_60734_().equals(Blocks.f_50016_)) continue;
                this.m_9236_().m_46597_(playerpos, ((Block)TTBlockRegistry.SNARELING_GOO.get()).m_49966_());
                this.spawngooTicks = 300;
                this.m_9236_().m_7605_((Entity)this, (byte)64);
                this.m_5496_((SoundEvent)TTSoundsRegistry.SNARELING_GOO.get(), 1.0f, this.m_6100_());
            }
        }
        super.m_8024_();
    }

    protected boolean teleport() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    protected boolean teleportTarget() {
        if (!this.m_9236_().m_5776_() && this.m_5448_().m_6084_()) {
            double d0 = this.m_5448_().m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_5448_().m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_5448_().m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    boolean teleportTowards(Entity p_32501_) {
        Vec3 vec3 = new Vec3(this.m_20185_() - p_32501_.m_20185_(), this.m_20227_(0.5) - p_32501_.m_20188_(), this.m_20189_() - p_32501_.m_20189_());
        vec3 = vec3.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TTSoundsRegistry.SNARELING_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_32527_) {
        return (SoundEvent)TTSoundsRegistry.SNARELING_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TTSoundsRegistry.SNARELING_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)TTSoundsRegistry.SNARELING_WALK.get(), 0.15f, 1.0f);
    }

    protected void m_7472_(DamageSource p_32497_, int p_32498_, boolean p_32499_) {
        super.m_7472_(p_32497_, p_32498_, p_32499_);
        BlockState blockstate = this.getCarriedBlock();
        if (blockstate != null) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42391_);
            itemstack.m_41663_(Enchantments.f_44985_, 1);
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)itemstack).m_287289_(LootContextParams.f_81455_, (Object)this);
            for (ItemStack itemstack1 : blockstate.m_287290_(lootparams$builder)) {
                this.m_19983_(itemstack1);
            }
        }
    }

    public void setCarriedBlock(@Nullable BlockState p_32522_) {
        this.f_19804_.m_135381_(DATA_CARRY_STATE, Optional.ofNullable(p_32522_));
    }

    @Nullable
    public BlockState getCarriedBlock() {
        return ((Optional)this.f_19804_.m_135370_(DATA_CARRY_STATE)).orElse(null);
    }

    public boolean m_6469_(DamageSource p_32494_, float p_32495_) {
        if (this.m_6673_(p_32494_)) {
            return false;
        }
        boolean flag = p_32494_.m_7640_() instanceof ThrownPotion;
        if (!p_32494_.m_269533_(DamageTypeTags.f_268524_) && !flag) {
            boolean flag2 = super.m_6469_(p_32494_, p_32495_);
            if (!this.m_9236_().m_5776_() && !(p_32494_.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
                this.teleport();
            }
            return flag2;
        }
        boolean flag1 = flag && this.hurtWithCleanWater(p_32494_, (ThrownPotion)p_32494_.m_7640_(), p_32495_);
        for (int i = 0; i < 64; ++i) {
            if (!this.teleport()) continue;
            return true;
        }
        return flag1;
    }

    public boolean m_7327_(Entity p_21372_) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_((SoundEvent)TTSoundsRegistry.SNARELING_HIT.get(), 1.0f, this.m_6100_());
        if (!this.m_9236_().m_5776_() && (float)this.m_9236_().m_213780_().m_188502_() < 0.3f && !this.m_9236_().f_46443_) {
            this.teleportTarget();
        }
        return super.m_7327_(p_21372_);
    }

    private boolean hurtWithCleanWater(DamageSource p_186273_, ThrownPotion p_186274_, float p_186275_) {
        ItemStack itemstack = p_186274_.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
        List list = PotionUtils.m_43547_((ItemStack)itemstack);
        boolean flag = potion == Potions.f_43599_ && list.isEmpty();
        return flag ? super.m_6469_(p_186273_, p_186275_) : false;
    }

    boolean isLookingAtMe(Player p_32535_) {
        ItemStack itemstack = (ItemStack)p_32535_.m_150109_().f_35975_.get(3);
        Vec3 vec3 = p_32535_.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - p_32535_.m_20185_(), this.m_20188_() - p_32535_.m_20188_(), this.m_20189_() - p_32535_.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? p_32535_.m_142582_((Entity)this) : false;
    }

    public boolean isCreepy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CREEPY);
    }

    public boolean hasBeenStaredAt() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STARED_AT);
    }

    public void setBeingStaredAt() {
        this.f_19804_.m_135381_(DATA_STARED_AT, (Object)true);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.getCarriedBlock() != null;
    }

    static class EndermanLeaveBlockGoal
    extends Goal {
        private final SnarelingEntity enderman;

        public EndermanLeaveBlockGoal(SnarelingEntity p_32556_) {
            this.enderman = p_32556_;
        }

        public boolean m_8036_() {
            if (this.enderman.getCarriedBlock() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.enderman.m_9236_(), (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.m_217043_().m_188503_(EndermanLeaveBlockGoal.m_186073_((int)2000)) == 0;
        }

        public void m_8037_() {
            RandomSource randomsource = this.enderman.m_217043_();
            Level level = this.enderman.m_9236_();
            int i = Mth.m_14107_((double)(this.enderman.m_20185_() - 1.0 + randomsource.m_188500_() * 2.0));
            int j = Mth.m_14107_((double)(this.enderman.m_20186_() + randomsource.m_188500_() * 2.0));
            int k = Mth.m_14107_((double)(this.enderman.m_20189_() - 1.0 + randomsource.m_188500_() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = level.m_8055_(blockpos);
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate1 = level.m_8055_(blockpos1);
            BlockState blockstate2 = this.enderman.getCarriedBlock();
            if (blockstate2 != null && this.canPlaceBlock(level, blockpos, blockstate2 = Block.m_49931_((BlockState)blockstate2, (LevelAccessor)this.enderman.m_9236_(), (BlockPos)blockpos), blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.enderman, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)blockpos1), (Direction)Direction.UP)) {
                level.m_7731_(blockpos, blockstate2, 3);
                level.m_220407_(GameEvent.f_157797_, blockpos, GameEvent.Context.m_223719_((Entity)this.enderman, (BlockState)blockstate2));
                this.enderman.setCarriedBlock(null);
            }
        }

        private boolean canPlaceBlock(Level p_32559_, BlockPos p_32560_, BlockState p_32561_, BlockState p_32562_, BlockState p_32563_, BlockPos p_32564_) {
            return p_32562_.m_60795_() && !p_32563_.m_60795_() && !p_32563_.m_60713_(Blocks.f_50752_) && !p_32563_.m_204336_(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST) && p_32563_.m_60838_((BlockGetter)p_32559_, p_32564_) && p_32561_.m_60710_((LevelReader)p_32559_, p_32560_) && p_32559_.m_45933_((Entity)this.enderman, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)p_32560_))).isEmpty();
        }
    }

    static class EndermanTakeBlockGoal
    extends Goal {
        private final SnarelingEntity enderman;

        public EndermanTakeBlockGoal(SnarelingEntity p_32585_) {
            this.enderman = p_32585_;
        }

        public boolean m_8036_() {
            if (this.enderman.getCarriedBlock() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.enderman.m_9236_(), (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.m_217043_().m_188503_(EndermanTakeBlockGoal.m_186073_((int)20)) == 0;
        }

        public void m_8037_() {
            RandomSource randomsource = this.enderman.m_217043_();
            Level level = this.enderman.m_9236_();
            int i = Mth.m_14107_((double)(this.enderman.m_20185_() - 2.0 + randomsource.m_188500_() * 4.0));
            int j = Mth.m_14107_((double)(this.enderman.m_20186_() + randomsource.m_188500_() * 3.0));
            int k = Mth.m_14107_((double)(this.enderman.m_20189_() - 2.0 + randomsource.m_188500_() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = level.m_8055_(blockpos);
            Vec3 vec3 = new Vec3((double)this.enderman.m_146903_() + 0.5, (double)j + 0.5, (double)this.enderman.m_146907_() + 0.5);
            Vec3 vec31 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockHitResult blockhitresult = level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.enderman));
            boolean flag = blockhitresult.m_82425_().equals((Object)blockpos);
            if (blockstate.m_204336_(BlockTags.f_13046_) && flag) {
                level.m_7471_(blockpos, false);
                level.m_220407_(GameEvent.f_157794_, blockpos, GameEvent.Context.m_223719_((Entity)this.enderman, (BlockState)blockstate));
                this.enderman.setCarriedBlock(blockstate.m_60734_().m_49966_());
            }
        }
    }
}

