/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity;

import com.belgieyt.trailsandtalesplus.TTConfigs;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TuffGolemEntity
extends Animal {
    private static final EntityDataAccessor<Byte> DATA_WOOL_ID = SynchedEntityData.m_135353_(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<BlockPos> SPAWNED_POS = SynchedEntityData.m_135353_(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Direction> ENTITY_DIRECTION = SynchedEntityData.m_135353_(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private final SimpleContainer inventory = new SimpleContainer(1);
    public AnimationState HoldAnimationState = new AnimationState();
    public AnimationState DropAnimationState = new AnimationState();
    private static final Map<DyeColor, float[]> COLORARRAY_BY_COLOR = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(p_29868_ -> p_29868_, TuffGolemEntity::createCapeColor)));

    private static float[] createCapeColor(DyeColor p_29866_) {
        if (p_29866_ == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = p_29866_.m_41068_();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public TuffGolemEntity(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22277_, 16.0);
    }

    public static float[] getColorArray(DyeColor p_29830_) {
        return COLORARRAY_BY_COLOR.get(p_29830_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TurtleGoHomeGoal(this, 1.0));
    }

    public void m_6667_(DamageSource p_21014_) {
        this.m_5907_();
        super.m_6667_(p_21014_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (this.m_6107_()) {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            } else {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.1);
            }
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.HoldAnimationState.m_216984_() || this.DropAnimationState.m_216984_() || this.hasItemInHand();
    }

    protected void m_5907_() {
        super.m_5907_();
        this.inventory.m_19195_().forEach(arg_0 -> ((TuffGolemEntity)this).m_19983_(arg_0));
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack)) {
            this.m_19983_(itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    public boolean m_6094_() {
        return !this.hasItemInHand() && super.m_6094_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WOOL_ID, (Object)0);
        this.f_19804_.m_135372_(ENTITY_DIRECTION, (Object)Direction.NORTH);
        this.f_19804_.m_135372_(SPAWNED_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(GOING_HOME, (Object)false);
    }

    public void setHomePos(BlockPos p_28385_) {
        this.f_19804_.m_135381_(SPAWNED_POS, (Object)p_28385_);
    }

    public BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(SPAWNED_POS);
    }

    public Direction m_6350_() {
        return (Direction)this.f_19804_.m_135370_(ENTITY_DIRECTION);
    }

    public void setDirection(Direction p_28465_) {
        this.f_19804_.m_135381_(ENTITY_DIRECTION, (Object)p_28465_);
    }

    boolean isGoingHome() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    void setGoingHome(boolean p_30239_) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)p_30239_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.hasItemInHand()) {
                this.HoldAnimationState.m_216982_(this.f_19797_);
            } else {
                this.HoldAnimationState.m_216973_();
            }
        }
        if (!((Boolean)TTConfigs.CAN_TUFF_GOLEM_SPAWN.get()).booleanValue()) {
            this.m_146870_();
        }
    }

    private void removeInteractionItem(Player p_239359_, ItemStack p_239360_) {
        if (!p_239359_.m_150110_().f_35937_) {
            p_239360_.m_41774_(1);
        }
    }

    public InteractionResult m_6071_(Player p_218361_, InteractionHand p_218362_) {
        ItemStack itemstack = p_218361_.m_21120_(p_218362_);
        ItemStack itemstack1 = this.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_150930_(Items.f_151048_) && this.hasItemInHand() && this.m_21223_() < this.m_21233_()) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_5634_(2.0f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            if (!p_218361_.m_7500_()) {
                itemstack.m_41774_(1);
            }
            p_218361_.m_6674_(p_218362_);
        } else {
            if (itemstack1.m_41619_() && !itemstack.m_41619_() && !(itemstack.m_41720_() instanceof DyeItem)) {
                ItemStack itemstack3 = itemstack.m_255036_(1);
                this.m_21008_(InteractionHand.MAIN_HAND, itemstack3);
                this.removeInteractionItem(p_218361_, itemstack);
                this.m_9236_().m_7605_((Entity)this, (byte)65);
                this.m_9236_().m_6269_(p_218361_, (Entity)this, SoundEvents.f_215676_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!itemstack1.m_41619_() && p_218362_ == InteractionHand.MAIN_HAND && itemstack.m_41619_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.m_9236_().m_6269_(p_218361_, (Entity)this, SoundEvents.f_215677_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.m_9236_().m_7605_((Entity)this, (byte)66);
                for (ItemStack itemstack2 : this.getInventory().m_19195_()) {
                    BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)itemstack2, (Vec3)this.m_20182_());
                }
                p_218361_.m_36356_(itemstack1);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(p_218361_, p_218362_);
    }

    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        this.m_5907_();
        return super.m_6469_(p_27567_, p_27568_);
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ == 65) {
            this.HoldAnimationState.m_216977_(this.f_19797_);
        } else if (p_219360_ == 66) {
            this.DropAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(p_219360_);
        }
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 0.8f;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public void m_7380_(CompoundTag p_28518_) {
        super.m_7380_(p_28518_);
        p_28518_.m_128344_("Color", (byte)this.getColor().m_41060_());
        p_28518_.m_128359_("Direction", this.m_6350_().m_7912_());
        p_28518_.m_128405_("HomePosX", this.getHomePos().m_123341_());
        p_28518_.m_128405_("HomePosY", this.getHomePos().m_123342_());
        p_28518_.m_128405_("HomePosZ", this.getHomePos().m_123343_());
    }

    public void m_7378_(CompoundTag p_28493_) {
        super.m_7378_(p_28493_);
        this.setColor(DyeColor.m_41053_((int)p_28493_.m_128445_("Color")));
        this.setDirection(this.m_6350_());
        int i = p_28493_.m_128451_("HomePosX");
        int j = p_28493_.m_128451_("HomePosY");
        int k = p_28493_.m_128451_("HomePosZ");
        this.setHomePos(new BlockPos(i, j, k));
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Byte)this.f_19804_.m_135370_(DATA_WOOL_ID) & 0xF));
    }

    public void setColor(DyeColor p_29856_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_WOOL_ID);
        this.f_19804_.m_135381_(DATA_WOOL_ID, (Object)((byte)(b0 & 0xF0 | p_29856_.m_41060_() & 0xF)));
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return SoundEvents.f_144236_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_144233_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_144234_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public boolean hasItemInHand() {
        return !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    static class TurtleGoHomeGoal
    extends Goal {
        private final TuffGolemEntity turtle;
        private final double speedModifier;
        private boolean stuck;
        private int closeToHomeTryTicks;
        private static final int GIVE_UP_TICKS = 600;

        TurtleGoHomeGoal(TuffGolemEntity p_30253_, double p_30254_) {
            this.turtle = p_30253_;
            this.speedModifier = p_30254_;
        }

        public boolean m_8036_() {
            if (this.turtle.m_6162_()) {
                return false;
            }
            if (this.turtle.hasItemInHand()) {
                return true;
            }
            if (this.turtle.m_217043_().m_188503_(TurtleGoHomeGoal.m_186073_((int)700)) != 0) {
                return false;
            }
            return !this.turtle.getHomePos().m_203195_((Position)this.turtle.m_20182_(), 64.0);
        }

        public void m_8056_() {
            this.turtle.setGoingHome(true);
            this.stuck = false;
            this.closeToHomeTryTicks = 0;
        }

        public void m_8041_() {
            this.turtle.setGoingHome(false);
        }

        public boolean m_8045_() {
            return !this.turtle.getHomePos().m_203195_((Position)this.turtle.m_20182_(), 7.0) && !this.stuck && this.closeToHomeTryTicks <= this.m_183277_(600);
        }

        public void m_8037_() {
            BlockPos blockpos = this.turtle.getHomePos();
            boolean flag = blockpos.m_203195_((Position)this.turtle.m_20182_(), 16.0);
            if (flag) {
                ++this.closeToHomeTryTicks;
            }
            if (this.turtle.m_21573_().m_26571_()) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)blockpos);
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)16, (int)3, (Vec3)vec3, (double)0.3141592741012573);
                if (vec31 == null) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)8, (int)7, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 != null && !flag && !this.turtle.m_9236_().m_8055_(BlockPos.m_274446_((Position)vec31)).m_60713_(Blocks.f_49990_)) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.turtle, (int)16, (int)5, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 == null) {
                    this.stuck = true;
                    return;
                }
                this.turtle.m_21573_().m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
            }
        }
    }

    public static enum Type implements StringRepresentable
    {
        RED(0, "red", Items.f_42197_),
        BLACK(1, "black", Items.f_42198_),
        WHITE(2, "white", Items.f_42130_),
        GRAY(3, "gray", Items.f_42137_),
        LIGHT_GRAY(4, "light_gray", Items.f_42138_),
        BROWN(5, "brown", Items.f_42142_),
        LIME(6, "lime", Items.f_42135_),
        GREEN(7, "green", Items.f_42143_),
        YELLOW(8, "yellow", Items.f_42134_),
        ORANGE(9, "orange", Items.f_42131_),
        BLUE(10, "blue", Items.f_42141_),
        CYAN(11, "cyan", Items.f_42139_),
        LIGHT_BLUE(12, "light_blue", Items.f_42133_),
        PINK(13, "pink", Items.f_42136_),
        PURPLE(14, "purple", Items.f_42140_),
        MAGENTA(15, "magenta", Items.f_42132_);

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final int id;
        private final String name;
        private final Item item;

        private Type(int p_196658_, String p_196659_, Item item) {
            this.id = p_196658_;
            this.name = p_196659_;
            this.item = item;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public Item byItem() {
            return this.item;
        }

        public static Type byName(String p_28817_) {
            return (Type)CODEC.m_262792_(p_28817_, (Enum)RED);
        }

        public static Type byId(int p_28813_) {
            return BY_ID.apply(p_28813_);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

