/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity.ai;

import com.belgieyt.trailsandtalesplus.Objects.TTEntityRegistry;
import com.belgieyt.trailsandtalesplus.Objects.entity.SkeletonSnifferEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

public class SuspiciousSnifferAI {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_LOOK_DISTANCE = 6;
    public static final List<SensorType<? extends Sensor<? super SkeletonSnifferEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)SensorType.f_26812_, (Object)SensorType.f_278390_);
    public static final List<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_217768_, (Object)MemoryModuleType.f_271134_, (Object)MemoryModuleType.f_271280_, (Object)MemoryModuleType.f_271087_, (Object)MemoryModuleType.f_217772_, (Object)MemoryModuleType.f_271415_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26375_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148196_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_});
    private static final int SNIFFING_COOLDOWN_TICKS = 9600;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_SNIFFING = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.25f;

    public static Ingredient getTemptations() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_271133_});
    }

    public static Brain<?> makeBrain(Brain<SkeletonSnifferEntity> p_273175_) {
        SuspiciousSnifferAI.initCoreActivity(p_273175_);
        SuspiciousSnifferAI.initIdleActivity(p_273175_);
        SuspiciousSnifferAI.initSniffingActivity(p_273175_);
        SuspiciousSnifferAI.initDigActivity(p_273175_);
        p_273175_.m_21930_(Set.of(Activity.f_37978_));
        p_273175_.m_21944_(Activity.f_37979_);
        p_273175_.m_21962_();
        return p_273175_;
    }

    static SkeletonSnifferEntity resetSniffing(SkeletonSnifferEntity p_279301_) {
        p_279301_.m_6274_().m_21936_(MemoryModuleType.f_271280_);
        p_279301_.m_6274_().m_21936_(MemoryModuleType.f_271134_);
        return p_279301_.transitionTo(SkeletonSnifferEntity.State.IDLING);
    }

    private static void initCoreActivity(Brain<SkeletonSnifferEntity> p_273185_) {
        p_273185_.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic(2.0f){

            protected void m_6735_(ServerLevel p_272973_, PathfinderMob p_273233_, long p_273492_) {
                SuspiciousSnifferAI.resetSniffing((SkeletonSnifferEntity)p_273233_);
                super.m_6735_(p_272973_, p_273233_, p_273492_);
            }
        }, (Object)new MoveToTargetSink(10000, 15000), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_)));
    }

    private static void initSniffingActivity(Brain<SkeletonSnifferEntity> p_273183_) {
        p_273183_.m_21903_(Activity.f_219849_, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Searching()))), Set.of(Pair.of((Object)MemoryModuleType.f_217768_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_271134_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initDigActivity(Brain<SkeletonSnifferEntity> p_273677_) {
        p_273677_.m_21903_(Activity.f_219853_, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Digging(160, 180))), (Object)Pair.of((Object)0, (Object)((Object)new FinishedDigging(40)))), Set.of(Pair.of((Object)MemoryModuleType.f_217768_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_271280_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initIdleActivity(Brain<SkeletonSnifferEntity> p_273750_) {
        p_273750_.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)TTEntityRegistry.SKELETON_SNIFFER.get(), 1.0f){

            protected void m_6735_(ServerLevel p_279149_, Animal p_279090_, long p_279482_) {
                SuspiciousSnifferAI.resetSniffing((SkeletonSnifferEntity)p_279090_);
                super.m_6735_(p_279149_, p_279090_, p_279482_);
            }
        }), (Object)Pair.of((Object)1, (Object)new FollowTemptation(p_279492_ -> Float.valueOf(1.25f), p_288909_ -> p_288909_.m_6162_() ? 2.5 : 3.5){

            protected void m_6735_(ServerLevel p_279230_, PathfinderMob p_279386_, long p_279139_) {
                SuspiciousSnifferAI.resetSniffing((SkeletonSnifferEntity)p_279386_);
                super.m_6735_(p_279230_, p_279386_, p_279139_);
            }
        }), (Object)Pair.of((Object)2, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)3, (Object)((Object)new FeelingHappy(40, 100))), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)((Object)new Scenting(40, 80)), (Object)1), (Object)Pair.of((Object)((Object)new Sniffing(40, 80)), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)6.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(5, 20), (Object)2))))), Set.of(Pair.of((Object)MemoryModuleType.f_271280_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(SkeletonSnifferEntity p_273301_) {
        p_273301_.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219853_, (Object)Activity.f_219849_, (Object)Activity.f_37979_));
    }

    static class Searching
    extends Behavior<SkeletonSnifferEntity> {
        Searching() {
            super(Map.of(MemoryModuleType.f_26370_, MemoryStatus.VALUE_PRESENT, MemoryModuleType.f_217768_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_271134_, MemoryStatus.VALUE_PRESENT), 600);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_273493_, SkeletonSnifferEntity p_272857_) {
            return p_272857_.canSniff();
        }

        protected boolean canStillUse(ServerLevel p_273196_, SkeletonSnifferEntity p_273769_, long p_273602_) {
            if (!p_273769_.canSniff()) {
                p_273769_.transitionTo(SkeletonSnifferEntity.State.IDLING);
                return false;
            }
            Optional<BlockPos> optional = p_273769_.m_6274_().m_21952_(MemoryModuleType.f_26370_).map(WalkTarget::m_26420_).map(PositionTracker::m_6675_);
            Optional optional1 = p_273769_.m_6274_().m_21952_(MemoryModuleType.f_271134_);
            return !optional.isEmpty() && !optional1.isEmpty() ? ((BlockPos)optional1.get()).equals((Object)optional.get()) : false;
        }

        protected void start(ServerLevel p_273563_, SkeletonSnifferEntity p_273394_, long p_273358_) {
            p_273394_.transitionTo(SkeletonSnifferEntity.State.SEARCHING);
        }

        protected void stop(ServerLevel p_273705_, SkeletonSnifferEntity p_273135_, long p_272667_) {
            if (p_273135_.canDig() && p_273135_.canSniff()) {
                p_273135_.m_6274_().m_21879_(MemoryModuleType.f_271280_, (Object)true);
            }
            p_273135_.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            p_273135_.m_6274_().m_21936_(MemoryModuleType.f_271134_);
        }
    }

    static class Digging
    extends Behavior<SkeletonSnifferEntity> {
        Digging(int p_272666_, int p_273420_) {
            super(Map.of(MemoryModuleType.f_217768_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_26370_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_271280_, MemoryStatus.VALUE_PRESENT, MemoryModuleType.f_217772_, MemoryStatus.VALUE_ABSENT), p_272666_, p_273420_);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_273442_, Sniffer p_273370_) {
            return p_273370_.m_278650_();
        }

        protected boolean canStillUse(ServerLevel p_272686_, SkeletonSnifferEntity p_273617_, long p_273124_) {
            return p_273617_.m_6274_().m_21952_(MemoryModuleType.f_271280_).isPresent() && p_273617_.canDig() && !p_273617_.m_27593_();
        }

        protected void start(ServerLevel p_272951_, SkeletonSnifferEntity p_272688_, long p_272979_) {
            p_272688_.transitionTo(SkeletonSnifferEntity.State.DIGGING);
        }

        protected void stop(ServerLevel p_273656_, SkeletonSnifferEntity p_273063_, long p_272844_) {
            boolean flag = this.m_7773_(p_272844_);
            if (flag) {
                p_273063_.m_6274_().m_21882_(MemoryModuleType.f_217772_, (Object)Unit.INSTANCE, 9600L);
            } else {
                SuspiciousSnifferAI.resetSniffing(p_273063_);
            }
        }
    }

    static class FinishedDigging
    extends Behavior<SkeletonSnifferEntity> {
        FinishedDigging(int p_272941_) {
            super(Map.of(MemoryModuleType.f_217768_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_26370_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_271280_, MemoryStatus.VALUE_PRESENT, MemoryModuleType.f_217772_, MemoryStatus.VALUE_PRESENT), p_272941_, p_272941_);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_273692_, SkeletonSnifferEntity p_272856_) {
            return true;
        }

        protected boolean canStillUse(ServerLevel p_273775_, SkeletonSnifferEntity p_273131_, long p_273569_) {
            return p_273131_.m_6274_().m_21952_(MemoryModuleType.f_271280_).isPresent();
        }

        protected void start(ServerLevel p_272708_, SkeletonSnifferEntity p_273502_, long p_272739_) {
            p_273502_.transitionTo(SkeletonSnifferEntity.State.RISING);
        }

        protected void stop(ServerLevel p_273210_, SkeletonSnifferEntity p_273648_, long p_272804_) {
            boolean flag = this.m_7773_(p_272804_);
            p_273648_.transitionTo(SkeletonSnifferEntity.State.IDLING).onDiggingComplete(flag);
            p_273648_.m_6274_().m_21936_(MemoryModuleType.f_271280_);
            p_273648_.m_6274_().m_21879_(MemoryModuleType.f_271087_, (Object)true);
        }
    }

    static class FeelingHappy
    extends Behavior<SkeletonSnifferEntity> {
        FeelingHappy(int p_273286_, int p_272777_) {
            super(Map.of(MemoryModuleType.f_271087_, MemoryStatus.VALUE_PRESENT), p_273286_, p_272777_);
        }

        protected boolean canStillUse(ServerLevel p_272660_, SkeletonSnifferEntity p_273250_, long p_273180_) {
            return true;
        }

        protected void start(ServerLevel p_273624_, SkeletonSnifferEntity p_273470_, long p_273501_) {
            p_273470_.transitionTo(SkeletonSnifferEntity.State.FEELING_HAPPY);
        }

        protected void stop(ServerLevel p_273216_, SkeletonSnifferEntity p_273271_, long p_273738_) {
            p_273271_.transitionTo(SkeletonSnifferEntity.State.IDLING);
            p_273271_.m_6274_().m_21936_(MemoryModuleType.f_271087_);
        }
    }

    static class Scenting
    extends Behavior<SkeletonSnifferEntity> {
        Scenting(int p_272680_, int p_273445_) {
            super(Map.of(MemoryModuleType.f_217768_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_271280_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_271134_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_271087_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_26375_, MemoryStatus.VALUE_ABSENT), p_272680_, p_273445_);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_279176_, SkeletonSnifferEntity p_279496_) {
            return !p_279496_.isTempted();
        }

        protected boolean canStillUse(ServerLevel p_273482_, SkeletonSnifferEntity p_273724_, long p_273191_) {
            return true;
        }

        protected void start(ServerLevel p_272795_, SkeletonSnifferEntity p_272788_, long p_273611_) {
            p_272788_.transitionTo(SkeletonSnifferEntity.State.SCENTING);
        }

        protected void stop(ServerLevel p_272816_, SkeletonSnifferEntity p_273426_, long p_272832_) {
            p_273426_.transitionTo(SkeletonSnifferEntity.State.IDLING);
        }
    }

    static class Sniffing
    extends Behavior<SkeletonSnifferEntity> {
        Sniffing(int p_272703_, int p_272735_) {
            super(Map.of(MemoryModuleType.f_26370_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_271134_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_217772_, MemoryStatus.VALUE_ABSENT), p_272703_, p_272735_);
        }

        protected boolean checkExtraStartConditions(ServerLevel p_272972_, SkeletonSnifferEntity p_273676_) {
            return !p_273676_.m_6162_() && p_273676_.canSniff();
        }

        protected boolean canStillUse(ServerLevel p_273156_, SkeletonSnifferEntity p_273448_, long p_272841_) {
            return p_273448_.canSniff();
        }

        protected void start(ServerLevel p_272950_, SkeletonSnifferEntity p_272614_, long p_273573_) {
            p_272614_.transitionTo(SkeletonSnifferEntity.State.SNIFFING);
        }

        protected void stop(ServerLevel p_272617_, SkeletonSnifferEntity p_273181_, long p_272635_) {
            boolean flag = this.m_7773_(p_272635_);
            p_273181_.transitionTo(SkeletonSnifferEntity.State.IDLING);
            if (flag) {
                p_273181_.calculateDigPosition().ifPresent(p_273341_ -> {
                    p_273181_.m_6274_().m_21879_(MemoryModuleType.f_271134_, p_273341_);
                    p_273181_.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(p_273341_, 1.25f, 0));
                });
            }
        }
    }
}

