/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.entity.renderer;

import com.belgieyt.trailsandtalesplus.Objects.entity.TTBoatEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class TTBoatRenderer
extends EntityRenderer<TTBoatEntity> {
    private static final ResourceLocation BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/boat/geoxyle.png");
    private static final ResourceLocation CHEST_BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/chest_boat/geoxyle.png");
    private static final ResourceLocation AZALEA_BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/boat/azalea.png");
    private static final ResourceLocation AZALEA_CHEST_BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/chest_boat/azalea.png");
    private static final ResourceLocation BAOBAB_BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/boat/baobab.png");
    private static final ResourceLocation BAOBAB_CHEST_BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/chest_boat/baobab.png");
    private static final ResourceLocation BURDEN_BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/boat/burden.png");
    private static final ResourceLocation BURDEN_CHEST_BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/chest_boat/burden.png");
    private static final ResourceLocation VOCAL_BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/boat/vocal.png");
    private static final ResourceLocation VOCAL_CHEST_BOAT_TEXTURE = new ResourceLocation("trailsandtalesplus", "textures/entity/chest_boat/vocal.png");
    private final boolean hasChest;
    private ListModel<Boat> boatModel;

    public TTBoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.hasChest = hasChest;
        this.boatModel = this.createBoatModel(context, Boat.Type.OAK, hasChest);
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, Boat.Type type, boolean bl) {
        ModelLayerLocation modelLayerLocation = bl ? ModelLayers.m_233550_((Boat.Type)type) : ModelLayers.m_171289_((Boat.Type)type);
        ModelPart modelPart = context.m_174023_(modelLayerLocation);
        return bl ? new ChestBoatModel(modelPart) : new BoatModel(modelPart);
    }

    public void render(TTBoatEntity p_113929_, float p_113930_, float p_113931_, PoseStack p_113932_, MultiBufferSource p_113933_, int p_113934_) {
        float f2;
        p_113932_.m_85836_();
        p_113932_.m_252880_(0.0f, 0.375f, 0.0f);
        p_113932_.m_252781_(Axis.f_252436_.m_252977_(180.0f - p_113930_));
        float f = (float)p_113929_.m_38385_() - p_113931_;
        float f1 = p_113929_.m_38384_() - p_113931_;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            p_113932_.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)p_113929_.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = p_113929_.m_38352_(p_113931_)), (float)0.0f)) {
            p_113932_.m_252781_(new Quaternionf().setAngleAxis(p_113929_.m_38352_(p_113931_) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        p_113932_.m_85841_(-1.0f, -1.0f, 1.0f);
        p_113932_.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        this.boatModel.m_6973_((Entity)p_113929_, p_113931_, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = p_113933_.m_6299_(this.boatModel.m_103119_(this.getTextureLocation(p_113929_)));
        this.boatModel.m_7695_(p_113932_, vertexConsumer, p_113934_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!p_113929_.m_5842_()) {
            VertexConsumer vertexconsumer1 = p_113933_.m_6299_(RenderType.m_110478_());
            ListModel<Boat> var12 = this.boatModel;
            if (var12 instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)var12;
                waterpatchmodel.m_102282_().m_104301_(p_113932_, vertexconsumer1, p_113934_, OverlayTexture.f_118083_);
            }
        }
        p_113932_.m_85849_();
        super.m_7392_((Entity)p_113929_, p_113930_, p_113931_, p_113932_, p_113933_, p_113934_);
    }

    public ResourceLocation getTextureLocation(TTBoatEntity boat) {
        if (boat.getWoodType() == TTBoatEntity.Type.AZALEA) {
            return this.hasChest ? AZALEA_CHEST_BOAT_TEXTURE : AZALEA_BOAT_TEXTURE;
        }
        if (boat.getWoodType() == TTBoatEntity.Type.GEOXYLE) {
            return this.hasChest ? CHEST_BOAT_TEXTURE : BOAT_TEXTURE;
        }
        if (boat.getWoodType() == TTBoatEntity.Type.BAOBAB) {
            return this.hasChest ? BAOBAB_CHEST_BOAT_TEXTURE : BAOBAB_BOAT_TEXTURE;
        }
        if (boat.getWoodType() == TTBoatEntity.Type.BURDEN) {
            return this.hasChest ? BURDEN_CHEST_BOAT_TEXTURE : BURDEN_BOAT_TEXTURE;
        }
        if (boat.getWoodType() == TTBoatEntity.Type.VOCAL) {
            return this.hasChest ? VOCAL_CHEST_BOAT_TEXTURE : VOCAL_BOAT_TEXTURE;
        }
        return this.hasChest ? CHEST_BOAT_TEXTURE : BOAT_TEXTURE;
    }
}

