/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.fluids;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class EndFluidType
extends FluidType {
    public static final ResourceLocation STILL_TEXTURE = new ResourceLocation("trailsandtalesplus", "block/voiva_still");
    public static final ResourceLocation FLOWING_TEXTURE = new ResourceLocation("trailsandtalesplus", "block/voiva_flow");
    public static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("trailsandtalesplus", "block/voiva_overlay");
    private static final ResourceLocation UNDERWATER = new ResourceLocation("trailsandtalesplus", "textures/block/voiva_overlay.png");

    public EndFluidType() {
        super(FluidType.Properties.create().supportsBoating(false).canHydrate(false).canDrown(true).canExtinguish(false).canPushEntity(true).canSwim(true).pathType(BlockPathTypes.WATER).adjacentPathType(BlockPathTypes.WATER_BORDER).canConvertToSource(true).fallDistanceModifier(0.0f).motionScale(0.014).rarity(Rarity.COMMON).viscosity(1100).density(1100).temperature(300).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public ResourceLocation getOverlayTexture() {
                return OVERLAY_TEXTURE;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.8784314f, 0.21960784f, 0.8156863f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)1.0f);
                RenderSystem.setShaderFogEnd((float)3.0f);
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER;
            }
        });
    }
}

