/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.items;

import com.belgieyt.trailsandtalesplus.Objects.TTItemRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EnderPouchItem
extends BundleItem {
    protected final int size = 576;

    public EnderPouchItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142207_(@Nonnull ItemStack stack, @Nonnull Slot slot, @Nonnull ClickAction action, @Nonnull Player player) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack var5 = slot.m_7993_();
        if (var5.m_41619_()) {
            EnderPouchItem.m_150780_(stack).ifPresent(p_150740_ -> EnderPouchItem.add(stack, slot.m_150659_(p_150740_), 576, player));
        } else if (var5.m_41720_().m_142095_()) {
            int var6 = (576 - EnderPouchItem.getContentWeight(stack, 64)) / EnderPouchItem.getWeight(var5, 64);
            EnderPouchItem.add(stack, slot.m_150647_(var5.m_41613_(), var6, player), 576, player);
        }
        return true;
    }

    public boolean m_142305_(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2, @Nonnull Slot slot, @Nonnull ClickAction action, @Nonnull Player player, @Nonnull SlotAccess slotAccess) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (stack2.m_41619_()) {
                Optional<ItemStack> var10000 = EnderPouchItem.m_150780_(stack1);
                Objects.requireNonNull(slotAccess);
                var10000.ifPresent(arg_0 -> ((SlotAccess)slotAccess).m_142104_(arg_0));
            } else {
                stack2.m_41774_(EnderPouchItem.add(stack1, stack2, 576, player));
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack var4 = player.m_21120_(hand);
        if (EnderPouchItem.m_150729_(var4, player)) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)var4, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)var4);
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return EnderPouchItem.getContentWeight(stack, 64) > 0;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return Math.min(1 + 12 * EnderPouchItem.getContentWeight(stack, 64) / 576, 13);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return super.m_142159_(stack);
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack stack) {
        NonNullList var2 = NonNullList.m_122779_();
        Stream<ItemStack> var10000 = EnderPouchItem.m_150782_(stack);
        Objects.requireNonNull(var2);
        var10000.forEach(arg_0 -> var2.add(arg_0));
        return Optional.of(new BundleTooltip(var2, EnderPouchItem.getContentWeight(stack, 64)));
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nonnull Level level, List<Component> components, @Nonnull TooltipFlag flag) {
        components.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{EnderPouchItem.getContentWeight(stack, 64), 576}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142023_(@Nonnull ItemEntity entity) {
        ItemUtils.m_150952_((ItemEntity)entity, EnderPouchItem.m_150782_(entity.m_32055_()));
    }

    private static int add(ItemStack bundleStack, ItemStack addStack, int size, @Nullable Player player) {
        if (!addStack.m_41619_() && addStack.m_41720_().m_142095_()) {
            CompoundTag tag = bundleStack.m_41784_();
            if (!tag.m_128441_("Items")) {
                tag.m_128365_("Items", (Tag)new ListTag());
            }
            int contentWeight = EnderPouchItem.getContentWeight(bundleStack, 64);
            int addStackWeight = EnderPouchItem.getWeight(addStack, 64);
            if (addStackWeight == 0) {
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"text.betterbundles.stack_size_to_large"), false);
                }
                return 0;
            }
            int remainingSlots = Math.min(addStack.m_41613_(), (size - contentWeight) / addStackWeight);
            if (remainingSlots == 0) {
                return 0;
            }
            int putSize = remainingSlots;
            ListTag list = tag.m_128437_("Items", 10);
            List<CompoundTag> var7 = EnderPouchItem.getMatchingItem(addStack, list);
            for (CompoundTag itemTag : var7) {
                if (remainingSlots <= 0) break;
                ItemStack var9 = ItemStack.m_41712_((CompoundTag)itemTag);
                int freeSlots = Math.min(var9.m_41741_() - var9.m_41613_(), remainingSlots);
                var9.m_41769_(freeSlots);
                var9.m_41739_(itemTag);
                list.remove((Object)itemTag);
                list.add(0, (Tag)itemTag);
                remainingSlots -= freeSlots;
            }
            if (remainingSlots > 0) {
                ItemStack var10 = addStack.m_41777_();
                var10.m_41764_(remainingSlots);
                CompoundTag var11 = new CompoundTag();
                var10.m_41739_(var11);
                list.add(0, (Tag)var11);
            }
            return putSize;
        }
        return 0;
    }

    private static List<CompoundTag> getMatchingItem(ItemStack p_150757_, ListTag p_150758_) {
        if (p_150757_.m_150930_((Item)TTItemRegistry.BUNDLE.get())) {
            return Collections.emptyList();
        }
        Stream<Object> var10000 = p_150758_.stream();
        var10000 = var10000.filter(CompoundTag.class::isInstance);
        return var10000.map(CompoundTag.class::cast).filter(p_150755_ -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)p_150755_), (ItemStack)p_150757_)).filter(tag -> {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag);
            return stack.m_41613_() < stack.m_41741_();
        }).toList();
    }

    private static int getWeight(ItemStack stack, int size) {
        CompoundTag var1;
        if (stack.m_150930_((Item)TTItemRegistry.BUNDLE.get())) {
            return 4 + EnderPouchItem.getContentWeight(stack, size);
        }
        if ((stack.m_150930_(Items.f_42786_) || stack.m_150930_(Items.f_42785_)) && stack.m_41782_() && (var1 = stack.m_41737_("BlockEntityTag")) != null && !var1.m_128437_("Bees", 10).isEmpty()) {
            return size;
        }
        return size / stack.m_41741_();
    }

    private static int getContentWeight(ItemStack bundleStack, int size) {
        return EnderPouchItem.m_150782_(bundleStack).mapToInt(stack -> EnderPouchItem.getWeight(stack, size) * stack.m_41613_()).sum();
    }

    private static Optional<ItemStack> m_150780_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("Items")) {
            return Optional.empty();
        }
        ListTag tagList = tag.m_128437_("Items", 10);
        if (tagList.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag tag1 = tagList.m_128728_(0);
        ItemStack stack1 = ItemStack.m_41712_((CompoundTag)tag1);
        tagList.remove(0);
        if (tagList.isEmpty()) {
            stack.m_41749_("Items");
        }
        return Optional.of(stack1);
    }

    private static boolean m_150729_(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("Items")) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag tagList = tag.m_128437_("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tag2 = tagList.m_128728_(i);
                ItemStack stack2 = ItemStack.m_41712_((CompoundTag)tag2);
                player.m_36176_(stack2, true);
            }
        }
        stack.m_41749_("Items");
        return true;
    }

    private static Stream<ItemStack> m_150782_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Stream.empty();
        }
        ListTag itemList = tag.m_128437_("Items", 10);
        Stream items = itemList.stream();
        return items.map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }
}

