/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.world;

import com.belgieyt.trailsandtalesplus.Objects.world.TTTrunkPlacerTypes;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaobabTrunkPlacer
extends TrunkPlacer {
    public static final Codec<BaobabTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BaobabTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BaobabTrunkPlacer::new));

    public BaobabTrunkPlacer(int i, int j, int k) {
        super(i, j, k);
    }

    private static void addDirt(@NotNull LevelSimulatedReader levelreader, @NotNull BiConsumer<BlockPos, BlockState> bicom, @NotNull RandomSource random, @NotNull BlockPos beginpos, @NotNull TreeConfiguration config, @NotNull List<BlockPos> logpos) {
        BlockGetter level = (BlockGetter)levelreader;
        BlockPos.MutableBlockPos pos = beginpos.m_122032_();
        int y = 0;
        while (true) {
            pos.m_122154_((Vec3i)beginpos, 0, -y, 0);
            if (BaobabTrunkPlacer.isSolid(level, (BlockPos)pos) && level.m_8055_((BlockPos)pos).m_60734_() != Blocks.f_50440_) break;
            BaobabTrunkPlacer.addDirtAt(levelreader, bicom, random, (BlockPos)pos, config, logpos);
            ++y;
        }
    }

    private static void addDirtAt(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> biConsumer, @NotNull RandomSource random, BlockPos pos, @NotNull TreeConfiguration config, List<BlockPos> logpos) {
        if (config.f_161215_ || !BaobabTrunkPlacer.m_70295_(level, pos)) {
            biConsumer.accept(pos, config.f_161212_.m_213972_(random, pos));
            logpos.add(pos);
        }
    }

    private static boolean m_70295_(LevelSimulatedReader p_70296_, BlockPos p_70297_) {
        return p_70296_.m_7433_(p_70297_, p_70304_ -> Feature.m_159759_((BlockState)p_70304_) && !p_70304_.m_60713_(Blocks.f_50440_) && !p_70304_.m_60713_(Blocks.f_50195_));
    }

    private static boolean isSolid(@NotNull BlockGetter level, @NotNull BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_60783_(level, pos, Direction.DOWN);
    }

    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TTTrunkPlacerTypes.DARK_OAK_TRUNK_PLACER.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> replacer, @NotNull RandomSource random, int height, @NotNull BlockPos startPos, @NotNull TreeConfiguration config) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos usedPos = new BlockPos.MutableBlockPos();
        BlockPos center = new BlockPos(startPos.m_123341_() - 1, startPos.m_123342_(), startPos.m_123343_() - 1);
        ArrayList list = Lists.newArrayList();
        ArrayList place = Lists.newArrayList();
        double percentage = 30.0;
        double branchPercentage = 40.0;
        float topPercentage = 25.0f;
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                FoliagePlacer.FoliageAttachment attachment;
                boolean chance;
                BaobabTrunkPlacer.addDirt(level, replacer, random, (BlockPos)usedPos.m_122154_((Vec3i)center, x, -1, z), config, place);
                for (int y = 0; y <= height; ++y) {
                    this.setLog(level, replacer, random, mutable, config, center, x, y, z, place);
                }
                if (BaobabTrunkPlacer.squareBetween(x, z, 1, 2)) continue;
                boolean x0 = x == 0;
                boolean x3 = x == 3;
                Direction dir1 = Direction.WEST;
                Direction dir2 = null;
                boolean bl = chance = random.m_188500_() <= percentage / 100.0;
                if (x0) {
                    if (chance) {
                        this.setLogs(level, replacer, random, mutable, config, center, x - 1, 0, z, height / 2, place);
                        this.setLogs(level, replacer, random, mutable, config, center, x - 2, 0, z, height / 2 - 1, place);
                        BaobabTrunkPlacer.addDirt(level, replacer, random, (BlockPos)usedPos.m_122154_((Vec3i)center, x - 1, -1, z), config, place);
                        BaobabTrunkPlacer.addDirt(level, replacer, random, (BlockPos)usedPos.m_122154_((Vec3i)center, x - 2, -1, z), config, place);
                    }
                } else if (x3) {
                    dir1 = Direction.EAST;
                    if (chance) {
                        this.setLogs(level, replacer, random, mutable, config, center, x + 1, 0, z, height / 2, place);
                        this.setLogs(level, replacer, random, mutable, config, center, x + 2, 0, z, height / 2 - 1, place);
                        BaobabTrunkPlacer.addDirt(level, replacer, random, (BlockPos)usedPos.m_122154_((Vec3i)center, x + 1, -1, z), config, place);
                        BaobabTrunkPlacer.addDirt(level, replacer, random, (BlockPos)usedPos.m_122154_((Vec3i)center, x + 2, -1, z), config, place);
                    }
                }
                if (z == 0) {
                    dir1 = Direction.NORTH;
                    if (x0) {
                        dir2 = Direction.WEST;
                    } else if (x3) {
                        dir2 = Direction.EAST;
                    }
                    if (chance) {
                        this.setLogs(level, replacer, random, mutable, config, center, x, 0, z - 1, height / 2, place);
                        this.setLogs(level, replacer, random, mutable, config, center, x, 0, z - 2, height / 2 - 1, place);
                        BaobabTrunkPlacer.addDirt(level, replacer, random, (BlockPos)usedPos.m_122154_((Vec3i)center, x, -1, z - 1), config, place);
                        BaobabTrunkPlacer.addDirt(level, replacer, random, (BlockPos)usedPos.m_122154_((Vec3i)center, x, -1, z - 2), config, place);
                    }
                } else if (z == 3) {
                    dir1 = Direction.SOUTH;
                    if (x0) {
                        dir2 = Direction.WEST;
                    } else if (x3) {
                        dir2 = Direction.EAST;
                    }
                    if (chance) {
                        this.setLogs(level, replacer, random, mutable, config, center, x, 0, z + 1, height / 2, place);
                        this.setLogs(level, replacer, random, mutable, config, center, x, 0, z + 2, height / 2 - 1, place);
                        BaobabTrunkPlacer.addDirt(level, replacer, random, (BlockPos)usedPos.m_122154_((Vec3i)center, x, -1, z + 1), config, place);
                        BaobabTrunkPlacer.addDirt(level, replacer, random, (BlockPos)usedPos.m_122154_((Vec3i)center, x, -1, z + 2), config, place);
                    }
                }
                if (random.m_188500_() <= (double)topPercentage * 0.01 && (attachment = this.generateBranch(dir1, dir2, 0.25f, height, height / 4, 4, level, replacer, random, mutable, config, center, x, z, place)) != null) {
                    list.add(attachment);
                }
                if (!(random.m_188500_() <= branchPercentage * 0.01)) continue;
                float min = 0.33333334f;
                float max = 1.0f;
                float p = random.m_188501_() * (max - min) + min;
                FoliagePlacer.FoliageAttachment attachment2 = this.generateBranch(dir1, dir2, p, height, height, 4, level, replacer, random, mutable, config, center, x, z, place);
                if (attachment2 == null) continue;
                list.add(attachment2);
            }
        }
        BlockPos.MutableBlockPos placedLogPos = startPos.m_122032_();
        for (BlockPos pos : place) {
            for (Direction dir : Direction.values()) {
                placedLogPos.m_122190_((Vec3i)pos).m_122173_(dir);
            }
        }
        return list;
    }

    public static boolean squareBetween(int x, int z, int between1, int between2) {
        boolean cond1 = x > between1 && x < between2;
        boolean cond2 = z > between1 && z < between2;
        return cond1 && cond2;
    }

    @Nullable
    private FoliagePlacer.FoliageAttachment generateBranch(@NotNull Direction direction, @Nullable Direction direction2, float y, int h, int minh, int max, @NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> replacer, @NotNull RandomSource random, @NotNull BlockPos.MutableBlockPos mutable, @NotNull TreeConfiguration config, @NotNull BlockPos startPos, int x, int z, @NotNull List<BlockPos> logpose) {
        int height = (int)(random.m_188500_() * (double)(h - minh) + (double)minh);
        BlockPos.MutableBlockPos prevFPos = startPos.m_122032_();
        BlockPos.MutableBlockPos fPos = startPos.m_122032_();
        BlockPos.MutableBlockPos fPos2 = startPos.m_122032_();
        for (int length = 1; length <= max; ++length) {
            int eq = (int)Math.floor(y * (float)length);
            prevFPos.m_122190_((Vec3i)fPos);
            fPos.m_122190_((Vec3i)startPos).m_122175_(direction, length);
            if (direction2 != null) {
                fPos.m_122175_(direction2, length);
            }
            this.m_226175_(level, replacer, random, (BlockPos)mutable.m_122154_((Vec3i)fPos, x, height + eq, z), config, state -> (BlockState)state.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)this.getLogAxis((BlockPos)prevFPos, (BlockPos)fPos)));
            if (length != max) continue;
            return new FoliagePlacer.FoliageAttachment((BlockPos)fPos2.m_122154_((Vec3i)fPos, x, height + eq + 1, z), 0, true);
        }
        return null;
    }

    private void placeLogIfFree(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockSetter, @NotNull RandomSource random, @NotNull BlockPos.MutableBlockPos pos, @NotNull TreeConfiguration config, @NotNull List<BlockPos> logPoses) {
        if (this.m_226184_(level, (BlockPos)pos)) {
            this.m_226187_(level, blockSetter, random, (BlockPos)pos, config);
            logPoses.add(pos.m_7949_());
        }
    }

    private void setLog(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> replacer, @NotNull RandomSource random, @NotNull BlockPos.MutableBlockPos pos, @NotNull TreeConfiguration config, @NotNull BlockPos startPos, int x, int y, int z, boolean condition, List<BlockPos> logPoses) {
        if (condition) {
            pos.m_122154_((Vec3i)startPos, x, y, z);
            this.placeLogIfFree(level, replacer, random, pos, config, logPoses);
        }
    }

    private void setLogs(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> replacer, @NotNull RandomSource random, @NotNull BlockPos.MutableBlockPos pos, @NotNull TreeConfiguration config, @NotNull BlockPos startPos, int x, int y, int z, int height, List<BlockPos> logPoses) {
        for (int h = 0; h <= height; ++h) {
            this.setLog(level, replacer, random, pos, config, startPos, x, y + h, z, logPoses);
        }
    }

    private void setLog(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> replacer, @NotNull RandomSource random, @NotNull BlockPos.MutableBlockPos pos, @NotNull TreeConfiguration config, @NotNull BlockPos startPos, int x, int y, int z, List<BlockPos> logPoses) {
        this.setLog(level, replacer, random, pos, config, startPos, x, y, z, true, logPoses);
    }

    @NotNull
    private Direction.Axis getLogAxis(@NotNull BlockPos pos, @NotNull BlockPos otherPos) {
        int j;
        Direction.Axis axis = Direction.Axis.Y;
        int i = Math.abs(otherPos.m_123341_() - pos.m_123341_());
        int k = Math.max(i, j = Math.abs(otherPos.m_123343_() - pos.m_123343_()));
        if (k > 0) {
            axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }
}

