/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.world.spawners;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;

public class WanderingCamelTrader
implements CustomSpawner {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private final RandomSource random = RandomSource.m_216327_();
    private final ServerLevelData serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public WanderingCamelTrader(ServerLevelData p_35914_) {
        this.serverLevelData = p_35914_;
        this.tickDelay = 1200;
        this.spawnDelay = p_35914_.m_6530_();
        this.spawnChance = p_35914_.m_6528_();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 24000;
            p_35914_.m_6391_(this.spawnDelay);
            this.spawnChance = 25;
            p_35914_.m_6387_(this.spawnChance);
        }
    }

    public int m_7995_(ServerLevel p_35922_, boolean p_35923_, boolean p_35924_) {
        if (!p_35922_.m_46469_().m_46207_(GameRules.f_46125_)) {
            return 0;
        }
        if (--this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = 1200;
        this.spawnDelay -= 1200;
        this.serverLevelData.m_6391_(this.spawnDelay);
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = 24000;
        if (!p_35922_.m_46469_().m_46207_(GameRules.f_46134_)) {
            return 0;
        }
        int i = this.spawnChance;
        this.spawnChance = Mth.m_14045_((int)(this.spawnChance + 25), (int)25, (int)75);
        this.serverLevelData.m_6387_(this.spawnChance);
        if (this.random.m_188503_(100) > i) {
            return 0;
        }
        if (this.spawn(p_35922_)) {
            this.spawnChance = 25;
            return 1;
        }
        return 0;
    }

    private boolean spawn(ServerLevel p_35916_) {
        ServerPlayer player = p_35916_.m_8890_();
        if (player == null) {
            return true;
        }
        if (this.random.m_188503_(10) != 0) {
            return false;
        }
        BlockPos blockpos = player.m_20183_();
        int i = 48;
        PoiManager poimanager = p_35916_.m_8904_();
        Optional optional = poimanager.m_27186_(p_219713_ -> p_219713_.m_203565_(PoiTypes.f_218061_), p_219711_ -> true, blockpos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockpos1 = optional.orElse(blockpos);
        BlockPos blockpos2 = this.findSpawnPositionNear((LevelReader)p_35916_, blockpos1, 48);
        if (blockpos2 != null && this.hasEnoughSpace((BlockGetter)p_35916_, blockpos2)) {
            if (!p_35916_.m_204166_(blockpos2).m_203565_(Biomes.f_48203_)) {
                return false;
            }
            WanderingTrader wanderingtrader = (WanderingTrader)EntityType.f_20494_.m_262496_(p_35916_, blockpos2, MobSpawnType.EVENT);
            if (wanderingtrader != null) {
                Camel traderllama;
                BlockPos newpos = this.findSpawnPositionNear((LevelReader)p_35916_, wanderingtrader.m_20183_(), 4);
                if (newpos != null && (traderllama = (Camel)EntityType.f_243976_.m_262496_(p_35916_, newpos, MobSpawnType.EVENT)) != null) {
                    wanderingtrader.m_7998_((Entity)traderllama, true);
                }
                this.serverLevelData.m_8115_(wanderingtrader.m_20148_());
                wanderingtrader.m_35891_(48000);
                wanderingtrader.m_35883_(blockpos1);
                wanderingtrader.m_21446_(blockpos1, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnLlamaFor(ServerLevel p_35918_, WanderingTrader p_35919_, int p_35920_) {
        TraderLlama traderllama;
        BlockPos blockpos = this.findSpawnPositionNear((LevelReader)p_35918_, p_35919_.m_20183_(), p_35920_);
        if (blockpos != null && (traderllama = (TraderLlama)EntityType.f_20488_.m_262496_(p_35918_, blockpos, MobSpawnType.EVENT)) != null) {
            traderllama.m_21463_((Entity)p_35919_, true);
        }
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader p_35929_, BlockPos p_35930_, int p_35931_) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = p_35930_.m_123341_() + this.random.m_188503_(p_35931_ * 2) - p_35931_;
            BlockPos blockpos1 = new BlockPos(j, l = p_35929_.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = p_35930_.m_123343_() + this.random.m_188503_(p_35931_ * 2) - p_35931_), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)p_35929_, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean hasEnoughSpace(BlockGetter p_35926_, BlockPos p_35927_) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_35927_, (BlockPos)p_35927_.m_7918_(1, 2, 1))) {
            if (p_35926_.m_8055_(blockpos).m_60812_(p_35926_, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

