/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.trailsandtalesplus.Objects.world.spawners;

import com.belgieyt.trailsandtalesplus.Objects.world.spawners.HoveringInfernoSpawner;
import com.belgieyt.trailsandtalesplus.Objects.world.spawners.WanderingCamelTrader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trailsandtalesplus")
public class WorldSpawnersRegistry {
    private static Map<ResourceLocation, WanderingCamelTrader> worldSpawners = new HashMap<ResourceLocation, WanderingCamelTrader>();
    private static Map<ResourceLocation, HoveringInfernoSpawner> hoveringWorldSpawner = new HashMap<ResourceLocation, HoveringInfernoSpawner>();

    @SubscribeEvent
    public static void onWorldLoad(ServerStartingEvent event) {
        ServerLevelData server = event.getServer().m_129910_().m_5996_();
        worldSpawners.put(BuiltinDimensionTypes.f_223538_.m_135782_(), new WanderingCamelTrader(server));
        hoveringWorldSpawner.put(BuiltinDimensionTypes.f_223538_.m_135782_(), new HoveringInfernoSpawner(server));
    }

    @SubscribeEvent
    public static void onServerStart(ServerStoppedEvent event) {
        worldSpawners.clear();
        hoveringWorldSpawner.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        WanderingCamelTrader spawner = worldSpawners.get(event.level.m_46472_().m_135782_());
        HoveringInfernoSpawner spawner2 = hoveringWorldSpawner.get(event.level.m_46472_().m_135782_());
        if (spawner != null) {
            spawner.m_7995_(event.level.m_7654_().m_129783_(), true, true);
        }
        if (spawner2 != null) {
            spawner2.m_7995_(event.level.m_7654_().m_129783_(), true, true);
        }
    }
}

